/* @(#) MQMBID sn=p800-003-150615.2 su=_O7DtFhOPEeWRp7-5NNeHyQ pn=samples/c/xatm/oraswit0d.c */
/******************************************************************************/
/*                                                                            */
/* Module name: oraswitd.c                                                    */
/*                                                                            */
/* Description: WebSphere MQ XA Dynamic Registration switch program for       */
/*              Oracle                                                        */
/*                                                                            */
/*   <copyright                                                                */
/*   notice="lm-source-program"                                                */
/*   pids="5724-H72,"                                                          */
/*   years="2008,2012"                                                         */
/*   crc="2020572666" >                                                        */
/*   Licensed Materials - Property of IBM                                      */
/*                                                                             */
/*   5724-H72,                                                                 */
/*                                                                             */
/*   (C) Copyright IBM Corp. 2008, 2012 All Rights Reserved.                   */
/*                                                                             */
/*   US Government Users Restricted Rights - Use, duplication or               */
/*   disclosure restricted by GSA ADP Schedule Contract with                   */
/*   IBM Corp.                                                                 */
/*   </copyright>                                                              */
/*                                                                            */
/******************************************************************************/

/******************************************************************************/
/* Includes                                                                   */
/******************************************************************************/

#include <cmqc.h>                                /* MQ header                 */
#include "xa.h"                                  /* MQ supplied XA header     */

/******************************************************************************/
/* External data declarations                                                 */
/******************************************************************************/

extern struct xa_switch_t xaoswd;

/******************************************************************************/
/*                                                                            */
/* Function name:  MQStart                                                    */
/*                                                                            */
/* Description: The queue manager calls this function to access the XA        */
/*              Dynamic Registration switch of Oracle                         */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/* Input Parameters:  None                                                    */
/*                                                                            */
/* Output Parameters: None                                                    */
/*                                                                            */
/* Returns:           Pointer to Oracle XA Dynamic Registration switch        */
/*                                                                            */
/******************************************************************************/
struct xa_switch_t * MQENTRY MQStart(void)
{
   return(&xaoswd);
}

/******************************************************************************/
/* End of oraswitd.c                                                          */
/******************************************************************************/
