#-------------------------------------------------------------------------------
#  a2w/core/bo/BOPool.pm:
#
#  Pool of SINGLETON business objects
#
#  Author  : Panneer, Maas Holding GmbH
#  Date    : 2013-10-11
#  Version : 1.0.0
#
#  $V100   2013-10-11    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::core::bo::BOPool;

use a2w::core::process::Logger;
use a2w::TypeConstants;

#-----------------------------------------------------------------------
# Private variables
#-----------------------------------------------------------------------
my $theBOPool = undef;

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    my $this = {
        'LogHandles' => undef # Hash of loggers (category=>instance)
    };

    bless( $this, $class );

    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;

    if ( $this->{ 'LogHandles' } != undef ){
        foreach my $lc ( keys %{ $this->{ 'LogHandles' } } ){
            undef( $this->{ 'LogHandles' }->{ $lc } );
        }
        undef( $this->{ 'LogHandles' } );
    }

    $theBOPool = 0;
}

#-----------------------------------------------------------------------
# Accessor
#-----------------------------------------------------------------------
sub getBOPool{
    if ( $theBOPool == undef ){
        $theBOPool = new a2w::core::bo::BOPool();
    }

    return $theBOPool;
}

sub getLogger{
    my $this = shift;
    my $category = "root"; # Default category
    if ( @_ > 0 ){ $category = shift; }

    if ( $this->{ 'LogHandles' } == undef ){ $this->{ 'LogHandles' } = {}; }

    if ( $this->{ 'LogHandles' }->{ $category } == undef ){
        $this->{ 'LogHandles' }->{ $category } = new a2w::core::process::Logger( $FALSE );
    }

    return $this->{ 'LogHandles' }->{ $category };
}

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
