#-------------------------------------------------------------------------------
#  a2w::core::dm::ParagraphContentDef.pm:
#  Data Mining Framework Paragraph Content Definition
#
#  Author  : AFP2web Team, Maas Holding GmbH
#
#  $V100   2014-05-08    Initial Release
#
#  $V101   2015-09-28    Extended to group texts based on font (identifier) (AFP-297)
#
#  $V102   2018-12-10    AFP-772: Extended to tag line objects under one <P> tag based on "TagLineAsParagraph" flag
#
#-------------------------------------------------------------------------------
package a2w::core::dm::ParagraphContentDef;

#-----------------------------------------------------------------------
# Include required modules
#-----------------------------------------------------------------------
use a2w::TypeConstants;
use a2w::core::log::Logger;
use a2w::core::dm::Constants;
use a2w::core::dm::ContentDef;

#-----------------------------------------------------------------------
# Inherit from base class
#-----------------------------------------------------------------------
our @ISA = qw( a2w::core::dm::ContentDef );

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    #---- Instantiate from base class to inherit base class attributes
    my $this = a2w::core::dm::ContentDef->new( @_ );

    #---- Add this derived class specific attributes
    $this->{ 'Group' }     = $FALSE; # Flag to join all texts that belong to a line as one on output or not
    $this->{ 'Separator' } = "";     # String that will be used as separator when grouping (concatenating) texts. The string could be space (' ') or empty ('')

    # $V101 Begin
    $this->{ 'GroupBy' }   = 'line'; # Group texts based on line. i.e, based on same Y position (with some tolerance)
                                     # Possible values are line, font. 'line' is default
    # $V101 End

    # $V102 Begin
    $this->{ 'TagLineAsParagraph' } = 0; # 0|1 (where 1 means tag each line under one <P> tag and 0 means tag whole block objects under one <P> tag. 0 is default)
    # $V102 End

    bless( $this, $class );

    #---- Set base class details
    $this->{ 'Type' } = 'paragraph';

    #---- Get logger
    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "new" );
    #}

    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;
}

#-----------------------------------------------------------------------
# Mutators
#-----------------------------------------------------------------------
sub setGroup{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setGroup()" );
    #}

    $this->{ 'Group' } = shift;
}

sub setSeparator{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setSeparator()" );
    #}

    $this->{ 'Separator' } = shift;
}

# $V101 Begin
sub setGroupBy{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setGroupBy()" );
    #}

    $this->{ 'GroupBy' } = shift;
}
# $V101 End

# $V102 Begin
sub setTagLineAsParagraph{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "setTagLineAsParagraph()" );
    #}

    $this->{ 'TagLineAsParagraph' } = shift;
}
# $V102 End

#-----------------------------------------------------------------------
# Accessors
#-----------------------------------------------------------------------
sub getGroup{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getGroup()" );
    #}

    return $this->{ 'Group' };
}

sub getSeparator{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getSeparator()" );
    #}

    return $this->{ 'Separator' };
}

# $V101 Begin
sub getGroupBy{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getGroupBy()" );
    #}

    return $this->{ 'GroupBy' };
}
# $V101 End

# $V102 Begin
sub getTagLineAsParagraph{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getTagLineAsParagraph()" );
    #}

    return $this->{ 'TagLineAsParagraph' };
}
# $V102 End

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
