#-------------------------------------------------------------------------------
# a2w/core/encoding/Translate.pm:
# Perl module to translate encoding of given string
#
#  Author  : Panneer, Maas Holding GmbH
#  Date    : 2013-10-11
#  Version : 1.0.0
#
#  $V100   2013-10-11    Initial Release
#
#-------------------------------------------------------------------------------
package a2w::core::encoding::Translate;

#---- Include packages
use a2w::TypeConstants;

use a2w::core::log::Logger;

#---- Declare constants
$TRUE  = $a2w::TypeConstants::TRUE;    # TRUE  boolean value
$FALSE = $a2w::TypeConstants::FALSE;   # FALSE boolean value

#---- Initialize global variables
#---- EBCDIC to ANSI translation array ----#
@arrEBCDIC2ANSI = (

#  _0    _1     _2     _3     _4     _5     _6    _7     _8     _9     _A     _B     _C    _D     _E     _F
0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,   # 0_
0x20, 0xB3, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,   # 1_
0x20, 0x20, 0x20, 0xB4, 0x20, 0x11, 0x1E, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,   # 2_
0x20, 0x20, 0x20, 0x20, 0x20, 0x10, 0x1F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,   # 3_
0x20, 0x20, 0xE2, 0x7B, 0xE0, 0xE1, 0xE3, 0xE5, 0xE7, 0xF1, 0xC4, 0x2E, 0x3C, 0x28, 0x2B, 0x21,   # 4_
0x26, 0xE9, 0xEA, 0xEB, 0xE8, 0xED, 0xEE, 0xEF, 0xEC, 0x20, 0xDC, 0x24, 0x2A, 0x29, 0x3B, 0xAC,   # 5_
0x2D, 0x2F, 0xC2, 0x5B, 0xC0, 0xC1, 0xC3, 0xC5, 0xC7, 0xD1, 0xF6, 0x2C, 0x25, 0x5F, 0x3E, 0x3F,   # 6_
0xF8, 0xC9, 0xCA, 0xCB, 0xC8, 0xCD, 0xCE, 0xCF, 0xCC, 0x20, 0x3A, 0x23, 0xA7, 0x27, 0x3D, 0x22,   # 7_
0xD8, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0xAB, 0xBB, 0x89, 0x2D, 0x00, 0x00,   # 8_
0xB0, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70, 0x71, 0x72, 0x97, 0x8C, 0xE6, 0x9F, 0xC6, 0x95,   # 9_
0x00, 0xDF, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0xA1, 0xBF, 0x9C, 0x00, 0x87, 0x84,   # A_
0xA2, 0xA3, 0xA5, 0x00, 0x00, 0x40, 0xB6, 0xBC, 0xBD, 0xBE, 0x00, 0x91, 0x92, 0x93, 0x94, 0x86,   # B_
0xE4, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x20, 0xF4, 0x7C, 0xF2, 0xF3, 0xF5,   # C_
0xFC, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x00, 0xFB, 0x7D, 0xF9, 0xFA, 0xFF,   # D_
0xD6, 0x20, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x00, 0xD4, 0x5C, 0xD2, 0xD3, 0xD5,   # E_
0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x00, 0xDB, 0x5D, 0xD9, 0xDA, 0x20    # F_

);

#---- ANSI to EBCDIC translation array ----#
@arrANSI2EBCDIC = (

#  _0    _1     _2     _3     _4     _5     _6    _7     _8     _9     _A     _B     _C    _D     _E     _F
0x00, 0x01, 0x02, 0x03, 0x37, 0x2D, 0x2E, 0x2F, 0x16, 0x05, 0x15, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,   # 0_
0x10, 0x11, 0x12, 0x13, 0x3C, 0x3D, 0x32, 0x26, 0x18, 0x19, 0x3F, 0x27, 0x1C, 0x1D, 0x1E, 0x1F,   # 1_
0x40, 0x5A, 0x7F, 0x7B, 0x5B, 0x6C, 0x50, 0x7D, 0x4D, 0x5D, 0x5C, 0x4E, 0x6B, 0x60, 0x4B, 0x61,   # 2_
0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0x7A, 0x5E, 0x4C, 0x7E, 0x6E, 0x6F,   # 3_
0x7C, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6,   # 4_
0xD7, 0xD8, 0xD9, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xAD, 0xE0, 0xBD, 0x5F, 0x6D,   # 5_
0x79, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96,   # 6_
0x97, 0x98, 0x99, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xC0, 0x4F, 0xD0, 0xA1, 0x07,   # 7_
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,   # 8_
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,   # 9_
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,   # A_
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,   # B_
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,   # C_
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,   # D_
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,   # E_
0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF    # F_

);

#-------------------------------------------------------------------------------
# Translates EBCDIC to ANSI
#
# Parameters:
# 1. Array length
# 2. Array of characters
#
# Returns
# Translated array
#
#-------------------------------------------------------------------------------
sub ebcdic2ANSI{
    #---- Get logger
    $theLogger  = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLogger->isRegistered( __PACKAGE__ );

    #---- Fetch parameters
    # 1. Array length
    # 2. Array (reference) of characters
    #
    my $iLengthPar = shift;
    my $arefDataPar = shift;
    my @arrDataPar = @{ $arefDataPar };

    if ( $bLogTmp ){
        $theLogger->logFunctionName( __PACKAGE__, "ebcdic2ANSI( " . $iLengthPar . " )" );
    }

    for ( $i = 0; $i < $iLengthPar; $i++ ){
        @arrDataPar[ $i ] = @arrEBCDIC2ANSI[ @arrDataPar[ $i ] ];
    }

    return @arrDataPar;
}

#-------------------------------------------------------------------------------
# Translates ANSI to EBCDIC
#
# Parameters:
# 1. Array length
# 2. Array of characters
#
# Returns
# Translated array
#
#-------------------------------------------------------------------------------
sub ansi2EBCDIC{
    #---- Get logger
    $theLogger  = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLogger->isRegistered( __PACKAGE__ );

    #---- Fetch parameters
    # 1. Array length
    # 2. Array (reference) of characters
    #
    my $iLengthPar = shift;
    my $arefDataPar = shift;
    my @arrDataPar = @{ $arefDataPar };

    if ( $bLogTmp ){
        $theLogger->logFunctionName( __PACKAGE__, "ansi2EBCDIC( " . $iLengthPar . " )" );
    }

    for ( $i = 0; $i < $iLengthPar; $i++ ){
        @arrDataPar[ $i ] = @arrANSI2EBCDIC[ @arrDataPar[ $i ] ];
    }

    return @arrDataPar;
}

#-------------------------------------------------------------------------------
# Don't remove the following lines !!!
#-------------------------------------------------------------------------------
1;
__END__

