#-------------------------------------------------------------------------------
#  a2w/hn/FOConstants.pm:
#  FOP transformation constants module
#
#  Author  : Fa. OXSEED
#  Date    : 2013-03-05
#  Version : 1.0.5
#
#  $V100   2012-06-01    Initial Release
#
#  $V101   2012-07-23    HNPROJECT-462, Extended with output base path constant
#                        whose value will be used to make relative output path
#                        as absolute.
#
#  $V102   2012-07-26    HNPROJECT-416, Extended to handle "x" and "y" position attributes
#                        when "xpt" and "ypt" attributes where missing for annotations
#
#  $V103   2012-11-06    NiLS3 bug #0857, Set static stamp lower (+ 6 points)
#
#  $V104   2012-11-28    Fixed minor bug in evaluating page left margin for AFP outputs
#
#  $V105   2013-03-05    Modified font cache creation for PDF and AFP outputs
#
#  $V106   2014-01-23    Modified file extension of tif resource file, that is copied to AFP resource path,
#                        as ".tif" as expected by A2W Kernel
#
#-------------------------------------------------------------------------------

package a2w::hn::FOConstants;

#-------------------------------------------------------------------------------
# Constants
#-------------------------------------------------------------------------------
# Root path
#
$ROOT_PATH="";

#---- Begin Constants as defined in XML2PDFconfig.xml and Tiff2Foconfig.xml ----#
#---- Page width and height (in points)
$PAGE_WIDTH  = 595.0;
$PAGE_HEIGHT = 842.0;

#---- End Constants as defined in XML2PDFconfig.xml and Tiff2Foconfig.xml ----#

#---- Begin Constants as defined in XML2PDFconfig.xml ----#
#---- Base paths ----#
# TIFF attachments base path
#
$TIFF_BASE_PATH = "f:/test/customertest/HN/ots/rtr/H2WDms/tiff/";

# Annotation base path
#
$ANNOTATION_BASE_PATH = "f:/test/customertest/HN/ots/rtr/H2WDms/annotation/";

# Info images base path
#
$INFO_IMAGES_BASE_PATH = "f:/test/customertest/HN/ots/rtr/H2WDms/infoimages/";

# $V101 Begin
# Output base path
#
$OUTPUT_BASE_PATH = "f:/test/customertest/HN/ots/rtr/";
# $V101 End

# Static stamp text attributes
#
# Name
# $V105 Begin
#$STATIC_STAMP_TEXT_FONT_NAME = "Times New Roman";
$STATIC_STAMP_TEXT_FONT_NAME = "Times-Roman";

# Weight
#$STATIC_STAMP_TEXT_FONT_WEIGHT = "bold";
$STATIC_STAMP_TEXT_FONT_WEIGHT = "regular";
# $V105 End

# Size
$STATIC_STAMP_TEXT_FONT_SIZE = 8.0;

# Color (Black)
$STATIC_STAMP_TEXT_COLOR = 0x000000;

# Position (in points)
$STATIC_STAMP_TEXT_XPOS = 269.0;
# $V103
$STATIC_STAMP_TEXT_YPOS = 17.0;

# Static stamp text for page where contents are not blocked by any annotations
#
# NOTE: Prepend '\n' for a newline requirement on presentation of text
#
$STATIC_STAMP_TEXT_NORMAL = "Nachdruck aus dem elektronischen Archiv. Nachdruck und Original stimmen berein."
                            . "\nHALLESCHE  Krankenversicherung auf Gegenseitigkeit  70166 Stuttgart"
                            ;

# Static stamp text for page where contents are blocked by any annotations
#
# NOTE: Prepend '\n' for a newline requirement on presentation of text
#
$STATIC_STAMP_TEXT_BLOCKED = "Nachdruck aus dem Archiv. Nachdruck und Original stimmen berein (Name und Adresse des"
                             . "\nGutachters wurden geschwrzt). HALLESCHE Krankenversicherung auf Gegenseitigkeit 70166"
                             . "\nStuttgart"
                             ;

# Dynamic stamp text attributes
#
# Name
# $V105 Begin
#$DYNAMIC_STAMP_TEXT_FONT_NAME = "Times New Roman";
$DYNAMIC_STAMP_TEXT_FONT_NAME = "Times-Roman";
# $V105 End

# Weight
$DYNAMIC_STAMP_TEXT_FONT_WEIGHT = "bold";

# Size
$DYNAMIC_STAMP_TEXT_FONT_SIZE = 8.0;

# Bordered Stamp Size
$DYNAMIC_BORDERED_STAMP_TEXT_FONT_SIZE = 16.0;

# Color (Black)
$DYNAMIC_STAMP_TEXT_COLOR = 0x000000;

# Highlight attributes
#

# Fill color (Black)
$BLOCK_FILL_COLOR = 0x000000;

# Line color (Black)
$BORDER_LINE_COLOR = 0x000000;

# Line width (in points)
$BORDER_LINE_WIDTH = 0.3;

# Underline width (in points)
$UNDERLINE_LINE_WIDTH = 1.0;

# Special characters map table
#
# Stamp text will have special characters escaped by '#' character before and after a hex value
# as given below
#
# <L x="58.2pt" y="30.0pt" ytop="18.3pt" txt="Spl Char #a7#"/>
#
# here, "#a7#" is the special character and process must appropriately replace it with actual character
# based on the encoding
#
# Map table syntax:
# "<special character>" as key => Text encoding based on code point value
#
%SPECIAL_CHAR_MAP = (
    # copy
      '169'  => ''
    # trade
    , '8482' => ''
    # deg
    , '00b0' => ''
    # gt
    , '62' => '>'
    # sup2
    , '00b2' => ''
    # frac14
    , '00bc' => ''
    # quot
    , '34' => '\''
    # frac12
    , '00bd' => ''
    # euro
    , '20ac' => ''
    # Omega
    , '937' => ' '
    # aumlaute
    , 'e4' => ''
    # oumlaute
    , 'f6' => ''
    # uumlaute
    , 'fc' => ''
    # ss
    , 'df' => ''
    # Aumlaute
    , 'c4' => ''
    # Oumlaute
    , 'd6' => ''
    # Uumlaute 
    , 'dc' => ''
    # sectionsign
    , 'a7' => ''
    # doublequot
    , '22' => '"'
    # ambersand
    , '26' => '&'
    # upper 2
    , 'b2' => ''
    # upper 3
    , 'b3' => ''
    # mu (greek)
    , 'b5' => ''
    # number sign
    , '23' => '#'
    # A gravis
    , 'c0' => ''
    # A akut
    , 'c1' => ''
    # A circumflex
    , 'c2' => ''
    # E gravis
    , 'c8' => ''
    # E akut
    , 'c9' => ''
    # E circumflex
    , 'ca' => ''
    # a gravis
    , 'e0' => ''
    # a akut
    , 'e1' => ''
    # a circumflex
    , 'e2' => ''
    # e gravis
    , 'e8' => ''
    # e akut
    , 'e9' => ''
    # e circumflex
    , 'ea' => ''
    # akut
    , 'b4' => ''
);

#---- End Constants as defined in XML2PDFconfig.xml ----#

#---- Begin Constants as defined in Tiff2Foconfig.xml ----#
#---- Image left margin (15 mm)
#
# Left margin in points = ( 15mm / 25.4 inch factor ) * 72
#
# $ V104 Begin
#$IMAGE_LEFT_MARGIN = ( ( 15.0 * 25.4 ) / 72 );
$IMAGE_LEFT_MARGIN = ( ( 15.0 / 25.4 ) * 72.0 );

#---- Not applicable document type id "225 (Pendelattest)
#
$DOC_TYPE_ID = 225;
# $ V104 End

#---- End Constants as defined in Tiff2Foconfig.xml ----#

#---- Begin Processing Constants as defined in LetterAttachment.xsl ----#
#---- Annotation filename extension
$ANNOT_FILENAME_EXT = ".xml";

#---- TIFF filename prefix
$TIFF_FILENAME_PREFIX = "P2T";

#---- TIFF filename extension
$TIFF_FILENAME_EXT = ".tiff";

# $V106 Begin
#---- A2W TIFF filename extension
$A2W_TIFF_FILENAME_EXT = ".tif";
# $V106 End

#---- End Processing Constants as defined in LetterAttachment.xsl ----#

# $V102 Begin
#---- Annotation resolution
#
# Resolution of annotation, units at which the annotation attribute's values are given
# when they are specified in points
#
$ANNOTATION_RESOLUTION = 240.0;
# $V102 End

#-------------------------------------------------------------------------------
# Don't remove the following lines !!!
#-------------------------------------------------------------------------------
1;
__END__
