#-------------------------------------------------------------------------------
#  Perl Processing Module to dump spools
#
#  Author  : Fa. Maas
#
#  $V100   2008-07-03	Initial Release
#  $V101   2008-07-29   a. Modified module name as "a2w::process::dump"
#  $V102   2019-02-08   Migrated logging to Scripting Facility framework standard
#
#-------------------------------------------------------------------------------
# $V101 Begin
#package a2w::dumpprocess::dump;
package a2w::process::dump;
# $V101 End

use a2w::Config;
use a2w::Document;
use a2w::Font;
use a2w::Index;
use a2w::Kernel;
use a2w::Line;
use a2w::MediumMap;
use a2w::NOP;
use a2w::Overlay;
use a2w::Page;
use a2w::PSEG;
use a2w::Text;

use a2w::ConfigConstants; # V113 Change
use a2w::core::log::Logger; # V113 Change

#-----------------------------------------------------------------------
# Layout Type: none (used to dump all the text objects)
#-----------------------------------------------------------------------
# Initialize once per process
#-----------------------------------------------------------------------
sub initialize{

    #---- Get Parameters of initialize
    #
    # 1. AFP2web ini (a2w::Config)
    # 2. AFP2web kernel (a2w::Kernel)
    # 3. Process spool (a2w::request::ProcessSpool)
    # 4. Start time (time)
    $a2wConfigPar = shift;
    $a2wKernelPar = shift;
    $reqProcessSpoolPar = shift;
    $tStartTimePar = shift;

	#---- Define boolean values
	$TRUE  = 1;	# TRUE  boolean value
	$FALSE = 0;	# FALSE boolean value

    # V102 Begin
    #---- Get logger
    my $sLogLevelTmp = $a2wConfigPar->getAttribute( $a2w::ConfigConstants::LOGGINGLEVEL );

    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );
    if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "initialize()" ); }

    $sIndexFilePath    = $a2wConfigPar->getAttribute( $a2w::ConfigConstants::INDEXPATH );
    $sOutputFilePath   = $a2wConfigPar->getAttribute( $a2w::ConfigConstants::OUTPUTFILEPATH );

    #---- Request Id
    $sRequestId = $reqProcessSpoolPar->getRequestId();

    #---- Time stamp
    # (sec,min,hour,mday,mon,year,wday,yday,isdst)
    my @StartTimeTmp = localtime( $tStartTimePar );
    $sTimeStamp = sprintf( "%04d%02d%02d_%02d%02d%02d",
                           ( @StartTimeTmp[ 5 ] + 1900 ),
                           ( @StartTimeTmp[ 4 ] + 1 ),
                           @StartTimeTmp[ 3 ],
                           @StartTimeTmp[ 2 ],
                           @StartTimeTmp[ 1 ],
                           @StartTimeTmp[ 0 ]
                         );

    if ( $bLog == $TRUE ){ $theLogger->logMessage( "RequestId=" . $sRequestId . ", TimeStamp=" . $sTimeStamp ); }
    # V102 End

    #---- Reset/Create Current Index List
    @IndexList = ();

	#---- Page Id
	$PageId = 0;

	#-------------------------------------------------------------------
	#	Setting AutoSplit to true means that document splitting will
	#	done based on the standard AFP index details. In this case the 
	#	return value 2 of the afp2web() function is ignored.
	#
	#	Setting AutoSplit to false means that document splitting will
	#	be defined by the afp2web() function.
	#-------------------------------------------------------------------
	$a2wConfigPar->setAttribute( $a2w::ConfigConstants::AUTOSPLIT, "on" ); # V102 Change

	return 0;
}

#-----------------------------------------------------------------------
# InitializeDoc for each document
#-----------------------------------------------------------------------
sub initializeDoc{

	#---- Get Parameter of initializeDoc(Par:mhtDocument*)
	($a2wDocumentPar) = @_;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "initializeDoc( " . $a2wDocumentPar->getId() . " )" ); } # V102 Change

	#---- Page Id
	$PageId = 0;
	
    #---- Add Document Indexes to Index List
	addDocumentIndexes();

	return 0;
}

#-----------------------------------------------------------------------
# InitializePage for each page
#-----------------------------------------------------------------------
sub initializePage{

	#---- Get Parameter of initializePage(Par:mhtPage*)
	($a2wPagePar) = @_;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "initializePage()" ); } # V102 Change

	return 0;
}

#-----------------------------------------------------------------------
# Main entry method
# Return values:
#  	  < 0:	error
# 		0:	append page to Current Document
# 		1:	skip page
# 		2:	first page / new document
#-----------------------------------------------------------------------
sub afp2web{

	$APPEND = 0; # append page to Current Document
	$SKIP = 1; # skip page
	$NEWDOC = 2; # new document

	$svRetTmp = $APPEND; # default: append page

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "afp2web()" ); } # V102 Change

    #---- Add Page Indexes to Index List
	addPageIndexes();

	return $svRetTmp;
}

#-----------------------------------------------------------------------
# FinalizePage for each page
#-----------------------------------------------------------------------
sub finalizePage{

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "finalizePage()" ); } # V102 Change
	return 0;
}

#-----------------------------------------------------------------------
# FinalizeDoc for each document
#-----------------------------------------------------------------------
sub finalizeDoc{

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "finalizeDoc()" ); } # V102 Change

	#---- Build Index Filename   
    my $svSimpleFilenameTmp = $a2wDocumentPar->getSimpleFilename();	# get document simple filename
    if ( $svSimpleFilenameTmp ne "" ){
        
        my $IndexFilenameTmp = $sIndexFilePath . $svSimpleFilenameTmp . ".idx"; # build Index Filename

        if ( $bLog == $TRUE ){ $theLogger->logMessage( "Writing Index File ==> $IndexFilenameTmp" ); } # V102 Change

        #---- Write Indexes
        my $docIndexCountTmp = @IndexList;

        if ( $bLog == $TRUE ){
            $theLogger->logMessage( "Printing Index List" ); # V102 Change
            for(my $IndexPtrTmp = 0; $IndexPtrTmp < $docIndexCountTmp; $IndexPtrTmp++){
			    $theLogger->logMessage( "Index: $IndexPtrTmp ==> @IndexList[$IndexPtrTmp]" ); # V102 Change
            }
        }

        #---- Open Index file
        my $svFileOpenSuccessTmp = open( fIndexFile, ">$IndexFilenameTmp" );

        if ( $svFileOpenSuccessTmp ){

            #---- Write Document Id, Type, Name, PageCount and Size
            print fIndexFile (	  "DocId="		. $a2wDocumentPar->getId() .
								", DocType="	. $svDocType .
								", DocName="	. $svOutputFilePath . $a2wDocumentPar->getOutputFilename() .
								", PageCount="	. $a2wDocumentPar->getPageCount() . 
								", Size="		. $a2wDocumentPar->getSize() . "\n");

            #---- Write Indexes
            for(my $IndexPtrTmp = 0; $IndexPtrTmp < $docIndexCountTmp; $IndexPtrTmp++){
                print fIndexFile ("@IndexList[$IndexPtrTmp]\n");
            }
            print fIndexFile ("\n");
            close( fIndexFile );
        }
		else{
			return(-999, "Unable to open index file $IndexFilenameTmp (rc=$svFileOpenSuccessTmp), leaving...");
		}

        #---- Reset Current Index List
        @IndexList = ();
    }
	else{
		return(-998, "Invalid Simple Filename for Document " . $a2wDocumentPar->getOutputFilename() . ", leaving...");
	}
    return 0;
}

#-----------------------------------------------------------------------
# Finalize once per process
#-----------------------------------------------------------------------
sub finalize{

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "finalize()" ); } # V102 Change
	return 0;
}

#-----------------------------------------------------------------------
# Add Document Indexes to list
#-----------------------------------------------------------------------
sub addDocumentIndexes{

    if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "addDocumentIndexes()" ); } # V102 Change

    #---- Define temp variables
    my $IndexPtrTmp = @IndexList;

    #---- Fetch first Document Index
    my $a2wIndexTmp = $a2wDocumentPar->getFirstIndex();

    #---- Add PageGroup Name
    if ( $a2wIndexTmp != 0 ){

        #---- Add PageGroup Name to Index List
        @IndexList[$IndexPtrTmp++] = "PageGroup=" . $a2wIndexTmp->getIndexedObjectName();
	}

    #---- Loop thru Indexes
    while ( $a2wIndexTmp != 0 ){

        #---- Add Index Record to Index List
        @IndexList[$IndexPtrTmp++] = $a2wIndexTmp->getName() . "=" . $a2wIndexTmp->getValue();

        #---- Fetch next Document Index
        $a2wIndexTmp = $a2wDocumentPar->getNextIndex();
    }
}

#-----------------------------------------------------------------------
# Add Page Indexes to list
#-----------------------------------------------------------------------
sub addPageIndexes{

    if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "addPageIndexes()" ); } # V102 Change

    #---- Define temp variables
    my $IndexPtrTmp = @IndexList;

	#---- Add Page Id to Index List
	@IndexList[$IndexPtrTmp++] = "Page=" . $a2wPagePar->getName();

	#---- Fetch first Page Index
	my $a2wIndexTmp = $a2wPagePar->getFirstIndex();

	#---- Loop thru Indexes
	while ( $a2wIndexTmp != 0 ){

		#---- Add Index Record to Index List
		@IndexList[$IndexPtrTmp++] = $a2wIndexTmp->getName() . "=" . $a2wIndexTmp->getValue();

		#---- Fetch next Page Index
		$a2wIndexTmp = $a2wPagePar->getNextIndex();
	}
}
#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__

