#-------------------------------------------------------------------------------
#  a2w::request::ProcessSpool:
#  Module for ProcessSpool request
#
#  Author  : Fa. Maas
#
#  $V100  2008-07-29  Initial release
#
#  $V101  2008-11-24  Extended to return "TransactionSourceID" element
#
#  $V102  2019-02-08  Migrated all functionalities to oxs-afp server/AFP2web Server 1.5.x
#
#-------------------------------------------------------------------------------
package a2w::request::ProcessSpool;

# V102 Begin
use a2w::core::log::Logger;

#-------------------------------------------------------------------------------
# Constructor
#-------------------------------------------------------------------------------
sub new{

    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    #---- Define boolean values
    $TRUE  = 1;    # TRUE  boolean value
    $FALSE = 0;    # FALSE boolean value

    my $this = {
        'processSpool' => undef    # Reference to top level XML elements 
    };

    bless( $this, $class );

    #---- Fetch process spool object
    $this->{ 'processSpool' } = shift;

    #---- Get logger
    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "new()" ); }

    return $this;
}

#-------------------------------------------------------------------------------
# Destructor
#-------------------------------------------------------------------------------
sub DESTROY{

    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "DESTROY()" ); }
}

#-------------------------------------------------------------------------------
# Mutator(s)
#-------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
# Accessor(s)
#-------------------------------------------------------------------------------

#-----------------------------------------------------------------------
# Get Request Id
#-----------------------------------------------------------------------
sub getRequestId{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getRequestId()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get Request Id
    my $sRequestIdTmp = $this->{'processSpool'}{'RequestId'};

    #---- Print Request Id
	if ( $bLog == $TRUE ){ $theLogger->logMessage( $sRequestIdTmp ); }

    #--- Return Request Id 
    return $sRequestIdTmp;
}

#-----------------------------------------------------------------------
# Get document data
#-----------------------------------------------------------------------
sub getDocumentData{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getDocumentData()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get document data
    my $hrefDDTmp = $this->{'processSpool'}{'DocumentData'};

    #---- Print document data
	if ( $bLog == $TRUE ){ $theLogger->logHashMessage( $hrefDDTmp ); }

    #--- Return document data
    return $hrefDDTmp;
}

#-----------------------------------------------------------------------
# Get store process
#-----------------------------------------------------------------------
sub getStoreProcess{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getStoreProcess()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get store process
    my $hrefSPTmp = $this->{'processSpool'}{'storeProcessRequest'};

    #---- Print store process
	if ( $bLog == $TRUE ){ $theLogger->logHashMessage( $hrefSPTmp ); }

    #--- Return store process
    return $hrefSPTmp;
}

#-----------------------------------------------------------------------
# Get Work Basket Id
#-----------------------------------------------------------------------
sub getWorkBasketId{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getWorkBasketId()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get Work Basket Id
    my $sWorkBasketIdTmp =    $this->{'processSpool'}{'WorkBasketId'};

    #---- Print Work Basket Id
    if ( $bLog == $TRUE ){ $theLogger->logMessage( $sWorkBasketIdTmp ); }

    #--- Return Work Basket Id
    return $sWorkBasketIdTmp;
}

# $V101 Begin
#-----------------------------------------------------------------------
# Get Transaction Source ID
#-----------------------------------------------------------------------
sub getTransactionSourceID{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getTransactionSourceID()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get TransactionSourceID
    my $sTransactionSourceIDTmp = $this->{'processSpool'}{'TransactionSourceID'};

    #---- Print TransactionSourceID
    if ( $bLog == $TRUE ){ $theLogger->logMessage( $sTransactionSourceIDTmp ); }

    #--- Return TransactionSourceID
    return $sTransactionSourceIDTmp;
}
# $V101 End

#-----------------------------------------------------------------------
# Get Document Source XML Ref
#-----------------------------------------------------------------------
sub getDocumentSourceXMLRef{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getDocumentSourceXMLRef()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get Document Source XML Ref
    my $sDocumentSourceXMLRefTmp = $this->{'processSpool'}{'DocumentSourceXMLRef'};

    #---- Print Document Source XML Ref
    if ( $bLog == $TRUE ){ $theLogger->logMessage( $sDocumentSourceXMLRefTmp ); }

    #--- Return DocumentSourceXMLRef
    return $sDocumentSourceXMLRefTmp;
}

#-----------------------------------------------------------------------
# Get Document Source ID
#-----------------------------------------------------------------------
sub getDocumentSourceID{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getDocumentSourceID()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get Document Source ID
    my $sDocumentSourceIDTmp = $this->{'processSpool'}{'DocumentSourceID'};

    #---- Print Document Source ID
    if ( $bLog == $TRUE ){ $theLogger->logMessage( $sDocumentSourceIDTmp ); }

    #--- Return DocumentSourceXMLRef
    return $sDocumentSourceIDTmp;
}

#-----------------------------------------------------------------------
# Get Process Type Xml Ref
#-----------------------------------------------------------------------
sub getProcessTypeXmlRef{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getProcessTypeXmlRef()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get Process Type Xml Ref
    my $sProcessTypeXmlRefTmp = $this->{'processSpool'}{'ProcessTypeXmlRef'};

    #---- Print Process Type Xml Ref
    if ( $bLog == $TRUE ){ $theLogger->logMessage( $sProcessTypeXmlRefTmp ); }

    #--- Return Process Type Xml Ref
    return $sProcessTypeXmlRefTmp;
}


#-----------------------------------------------------------------------
# Get ProcessTypeID
#-----------------------------------------------------------------------
sub getProcessTypeID{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getProcessTypeID()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get ProcessTypeID
    my $sProcessTypeIDTmp = $this->{'processSpool'}{'ProcessTypeID'};

    #---- Print ProcessTypeID
    if ( $bLog == $TRUE ){ $theLogger->logMessage( $sProcessTypeIDTmp ); }

    #--- Return ProcessTypeID
    return $sProcessTypeIDTmp;
}

#-----------------------------------------------------------------------
# Get DocumentTypeXmlRef
#-----------------------------------------------------------------------
sub getDocumentTypeXmlRef{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getDocumentTypeXmlRef()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get DocumentTypeXmlRef
    my $sDocumentTypeXmlRefTmp = $this->{'processSpool'}{'DocumentTypeXmlRef'};

    #---- Print DocumentTypeXmlRef
    if ( $bLog == $TRUE ){ $theLogger->logMessage( $sDocumentTypeXmlRefTmp ); }

    #--- Return DocumentTypeXmlRef
    return $sDocumentTypeXmlRefTmp;
}

#-----------------------------------------------------------------------
# Get DocumentTypeID
#-----------------------------------------------------------------------
sub getDocumentTypeID{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getDocumentTypeID()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get DocumentTypeID
    my $sDocumentTypeIDTmp = $this->{'processSpool'}{'DocumentTypeID'};

    #---- Print DocumentTypeID
    if ( $bLog == $TRUE ){ $theLogger->logMessage( $sDocumentTypeIDTmp ); }

    #--- Return DocumentTypeID
    return $sDocumentTypeIDTmp;
}

#-----------------------------------------------------------------------
# Get Input file DocumentType
#-----------------------------------------------------------------------
sub getInputFileDocumentType{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getInputFileDocumentType()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get Input file DocumentType
    my $sInputFileDocTypeTmp = $this->{'processSpool'}{'DocumentType'};

    #---- Print Input file DocumentType
    if ( $bLog == $TRUE ){ $theLogger->logMessage( $sInputFileDocTypeTmp ); }

    #--- Return Input file DocumentType
    return $sInputFileDocTypeTmp;
}

#-----------------------------------------------------------------------
# Get index alias list
#-----------------------------------------------------------------------
sub getIndexAliasList{
    #---- Get Object instance
    my $this = shift;

	if ( $bLog == $TRUE ){ $theLogger->logFunctionName( __PACKAGE__, "getIndexAliasList()" ); }

    #--- Assert process spool object
    if ( $this->{ 'processSpool' } == undef ){ return undef; }

    #--- Get IndexAliasList
    my $IndexAliasListTmp = $this->{ 'processSpool' }{ 'IndexAliasList' };

    #---- Print index alias list
    if ( $bLog == $TRUE ){ $theLogger->logHashMessage( { 'IndexAliasList' => $IndexAliasListTmp } ); }

    #--- Return IndexAliasList 
    return $IndexAliasListTmp;
}
# V102 End

#-------------------------------------------------------------------------------
# Don't remove the following lines !!!
#-------------------------------------------------------------------------------
1;
__END__
