#-------------------------------------------------------------------------------
#  a2w::core::dm::ContentDef.pm:
#  Data Mining Framework Content Definition
#
#  Author  : AFP2web Team, Maas Holding GmbH
#
#  $V100   2014-05-08    Initial Release
#
#  $V101   2017-10-30    Extended with 'PrimaryColumns' attribute to determine multiline
#                        rows. i.e, when primary column cells are empty then row is considered
#                        as following line of current row
#
#-------------------------------------------------------------------------------
package a2w::core::dm::ContentDef;

#-----------------------------------------------------------------------
# Include required modules
#-----------------------------------------------------------------------
use a2w::TypeConstants;
use a2w::core::log::Logger;
use a2w::core::dm::Constants;
use a2w::core::dm::AddContent;

#-----------------------------------------------------------------------
# Constructor
#-----------------------------------------------------------------------
sub new{
    my $proto = shift;
    my $class = ref( $proto ) || $proto;

    my $this = {
          'Type'        => 0      # Type of content
        , 'AddContent'  => undef  # HASH of additional content
    };

    bless( $this, $class );

    #---- Define boolean values
    $TRUE  = $a2w::TypeConstants::TRUE;     # TRUE  boolean value
    $FALSE = $a2w::TypeConstants::FALSE;    # FALSE boolean value

    #---- Get logger
    our $theLogger = a2w::core::log::Logger->getSingleton();
    our $bLog = $theLogger->isRegistered( __PACKAGE__ );

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "new()" );
    #}

    return $this;
}

#-----------------------------------------------------------------------
# Destructor
#-----------------------------------------------------------------------
sub DESTROY{
    my $this = shift;
}

#-----------------------------------------------------------------------
# Mutators
#-----------------------------------------------------------------------
#...

#-----------------------------------------------------------------------
# Accessors
#-----------------------------------------------------------------------
sub getType{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getType()" );
    #}

    return $this->{ 'Type' };
}

sub getAddContent{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "getAddContent()" );
    #}

    #---- Get parameter
    #
    # 1. Additional Content
    #
    return $this->{ 'AddContent' };
}

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
sub createAndAddContent{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "createAndAddContent()" );
    #}

    #---- Get parameter
    #
    # 1. Additional content unique identifier
    # 2. Additional Content config reference
    #
    my $sIdPar   = shift;
    my $acRefPar = shift;
    if ( $sIdPar eq "" || $acRefPar == undef ){ return -1; }

    #---- Assert id already added or not
    if ( defined( $this->{ 'AddContent' }{ $sIdPar } ) != undef ){ return 0; }

    #---- Create additional content and add it ----#
    my $addContTmp = new a2w::core::dm::AddContent();

    #---- Fil in details
    $addContTmp->setInclude( $acRefPar->{ 'Include' } );
    $addContTmp->setContent( $acRefPar->{ 'Content' } );

    $this->{ 'AddContent' }{ $sIdPar } = $addContTmp;

    return 0;
}

# $V101 Begin
# Evaluate default values for content definition attributes
sub evaluateDefaults{
    my $this = shift;

    #if ( $bLog == $TRUE ){
    #    $theLogger->logFunctionName( __PACKAGE__, "evaluateDefaults()" );
    #}

    #---- Nothing is done here in base class, derived classes must implement as needed

    return 0;
}
# $V101 End

#-----------------------------------------------------------------------
# Don't remove the following lines !!!
#-----------------------------------------------------------------------
1;
__END__
