#-------------------------------------------------------------------------------
#  a2w/core/ext/Image.pm:
#  Extension module with additional processing functionalities
#
#  Author  : Fa. Maas
#
#  $V100   2014-06-26    Initial Release
#
#  $V101   2018-01-27    Extended with constants for page begin/end marking (AFP-456)
#
#-------------------------------------------------------------------------------

#
# NOTE:
# Though the filename is a2w/core/ext/Image.pm, in actual it is 'a2w::Image' module extension
#

package a2w::Image;

use a2w::Image;
use a2w::core::log::Logger;

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
#------------------------------------------------------------------------
# _getType
#
# Get type of object
#
# Returns
#   Object type
#
#------------------------------------------------------------------------
sub _getType{
    $this = shift;
    
    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_getType" );
    }

    return "image";
}

#------------------------------------------------------------------------
# _getAttribute
#
# Get value of given attribute
#
# Parameter
# 1. Attribute name
#
# Returns
#   Attribute value, if such attribute exists
#   undef otherwise
#
#------------------------------------------------------------------------
sub _getAttribute{
    $this = shift;
    
    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_getAttribute" );
    }

    #---- Get Parameter
    # 1. Attribute name
    # 2. POM object wrapper (optional)
    #
    my $sAttrNamePar = lc( shift );
    my $pomObjectPar = undef;
    if ( @_ > 0 ){
        $pomObjectPar = shift;
    }

    #---- Searches POM object first and then kernel object ----#
    if ( $pomObjectPar != undef ){
        #---- Attribute name to id mapping
        my $hrefObjAttrMapTmp = {
              'xpos'  => $a2w::core::dm::Constants::AT_XPOS
            , 'ypos'  => $a2w::core::dm::Constants::AT_YPOS
            , 'angle' => $a2w::core::dm::Constants::AT_ANGLE
            , 'pagefirst' => $a2w::core::dm::Constants::AT_PAGEFIRST # $V101 Change
            , 'pagelast' => $a2w::core::dm::Constants::AT_PAGELAST   # $V101 Change
        };
        if ( $hrefObjAttrMapTmp->{ $sAttrNamePar } != undef ){
            return $pomObjectPar->{ $hrefObjAttrMapTmp->{ $sAttrNamePar } };
        }
        my $hrefImgAttrMapTmp = {
              'width'      => $a2w::core::dm::Constants::OI_IMAGE_WIDTH
            , 'height'     => $a2w::core::dm::Constants::OI_IMAGE_HEIGHT
            , 'name'       => $a2w::core::dm::Constants::OI_IMAGE_NAME
            , 'resolution' => $a2w::core::dm::Constants::OI_IMAGE_RESOLUTION
        };
        if ( $hrefImgAttrMapTmp->{ $sAttrNamePar } != undef ){
            return $pomObjectPar->{ $a2w::core::dm::Constants::AT_OBJINFO }{ $hrefImgAttrMapTmp->{ $sAttrNamePar } };
        }
    }

    #---- Attribute name to accessor method mapping
    my $hrefMethodMapTmp = {
          'xpos'               => 'getXPos'
        , 'ypos'               => 'getYPos'
        , 'angle'              => 'getAngle'
        , 'name'               => 'getName'
        , 'data'               => 'getData'
        , 'datalen'            => 'getDataLength'
        , 'compression'        => 'getCompression'
        , 'bitsperpixel'       => 'getBitsPerPixel'
        , 'samplesperpixel'    => 'getSamplesPerPixel'
        , 'width'              => 'getWidth'
        , 'height'             => 'getHeight'
        , 'presentationwidth'  => 'getPresentationWidth'
        , 'presentationheight' => 'getPresentationHeight'
        , 'uniquecolorscount'  => 'getUniqueColorsCount'
    };
    my $sMethodNameTmp = $hrefMethodMapTmp->{ $sAttrNamePar };
    if ( $sMethodNameTmp eq "" ){
        #---- Name to method mapping undefined, return undef
        return undef;
    }

    return $this->$sMethodNameTmp();
}

1;
__END__
