#-------------------------------------------------------------------------------
#  cartagenote.pm:
#
#  Block definition module for cartage notes
#
#  Author    : Fa. Maas (AFP2web Team)
#  Copyright : (C) 2018-2019 by Maas Holding GmbH
#
#  V101    2019-12-18    OXS-10109: Extended to support multiple "Bordero" blocks
#  V100    2018-08-31    Initial Release
#
#-------------------------------------------------------------------------------
package customers::wackler::cartagenote;

#---- Define parser rules ----#
@ParserRules = (
    {
		# Text@(11040,8312)>Sdg.-Nr.<
		'Id' => 'shipment_start',
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'TEXT',
				'CONDITION' => 'ATTR_XPOS GE 11030'
			},
			'COND2' => {
				'OBJ_TYPE'  => 'TEXT',
				'CONDITION' => 'ATTR_XPOS LE 11050'
			},
			'COND3' => {
				'OBJ_TYPE'  => 'TEXT',
				'CONDITION' => 'ATTR_TEXT EQ qr/^Sdg\.\-Nr\.$/'
			}
		}
	},
    {
		# Text@(10800,22974)>Bordero<
		'Id' => 'bordero_start',
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'TEXT',
				'CONDITION' => 'ATTR_XPOS GE 10790'
			},
			'COND2' => {
				'OBJ_TYPE'  => 'TEXT',
				'CONDITION' => 'ATTR_XPOS LE 10810'
			},
			'COND3' => {
				'OBJ_TYPE'  => 'TEXT',
				'CONDITION' => 'ATTR_TEXT EQ qr/^Bordero$/'
			}
		}
	},
    {
		# Text@(4080, 2752)>Anzahl:<
		'Id' => 'footer_start',
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'TEXT',
				'CONDITION' => 'ATTR_XPOS GE 4070'
			},
			'COND2' => {
				'OBJ_TYPE'  => 'TEXT',
				'CONDITION' => 'ATTR_XPOS LE 4090'
			},
			'COND3' => {
				'OBJ_TYPE'  => 'TEXT',
				'CONDITION' => 'ATTR_TEXT EQ qr/^Anzahl\:$/'
			}
		}
	},
    {
		# First object of page
		'Id' => 'page_start',
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'ANY',
				'CONDITION' => 'ATTR_PAGEFIRST EQ 1'
			}
		}
	},
    {
		# Last object of page
		'Id' => 'page_end',
		'Constraints' => {
			'COND1' => {
				'OBJ_TYPE'  => 'ANY',
				'CONDITION' => 'ATTR_PAGELAST EQ 1'
			}
		}
	}
);

#---- Define blocks ----#
my $iBlockId = 1;
%Blocks = (
	'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id' => 'header', # Cartage Note (CN) Page Header (1st Page)
		'StartAnchor' => {
            # start anchor: Line, Position: X position = 450, Y Position = 0, Length = 2, Width = 2
			'Constraints' => {
				'COND1' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_XPOS EQ 0'
				}, 
				'COND2' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_WIDTH EQ 2'
				}, 
				'COND3' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_LENGTH EQ 2'
				},
                'Skip' => 1
			}
		},
		'EndAnchor' => {
            # end anchor: Line, Position: X position = 23050, Length = 2, Width = 2
			'Constraints' => {
				'COND1' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_XPOS EQ 23050'
				}, 
				'COND2' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_WIDTH EQ 2'
				}, 
				'COND3' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_LENGTH EQ 2'
				},
                'Skip' => 1
			}
		},
		'StartX' => 0,
		'Width' => 22200,
		'ContentDef' => { 'Type' => 'Raw' }
	},
	'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id' => 'shipment',
		'StartAnchor' => {
            # start anchor: Line, Position: X position = 450, Length = 4, Width = 4
			'Constraints' => {
				'COND1' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_XPOS EQ 450'
				}, 
				'COND2' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_WIDTH EQ 4'
				}, 
				'COND3' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_LENGTH EQ 4'
				},
                'Skip' => 1
			} 
		},
		'EndAnchor' => {
            # end anchor: Line, Position: X position = 23050, Length = 4, Width = 4
			'Constraints' => {
				'COND1' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_XPOS EQ 23050'
				}, 
				'COND2' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_WIDTH EQ 4'
				}, 
				'COND3' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_LENGTH EQ 4'
				},
                'Skip' => 1
			}
		},
		'Width' => 22560,
		'Quantifier' => '+',
		'ContentDef' => { 'Type' => 'Raw' }
	},
	'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id' => 'bordero',
		'StartAnchor' => {
            # start anchor: Line, Position: X position = 450, Length = 6, Width = 6
			'Constraints' => {
				'COND1' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_XPOS EQ 450'
				}, 
				'COND2' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_WIDTH EQ 6'
				}, 
				'COND3' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_LENGTH EQ 6'
				},
                'Skip' => 1
			} 
		},
		'EndAnchor' => {
            # end anchor: Line, Position: X position = 23050, Length = 6, Width = 6
			'Constraints' => {
				'COND1' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_XPOS EQ 23050'
				}, 
				'COND2' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_WIDTH EQ 6'
				}, 
				'COND3' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_LENGTH EQ 6'
				},
                'Skip' => 1
			}
		},
		'Width' => 22560,
		# V101 Change: Allow multiple bordero blocks to be detected
		'Quantifier' => '+',
		'ContentDef' => { 'Type' => 'Raw' }
	},
	'BLK' . sprintf( "%03d", $iBlockId++ ) => {
		'Id' => 'footer',
		'StartAnchor' => {
            # start anchor: Line, Position: X position = 450, Length = 8, Width = 8
			'Constraints' => {
				'COND1' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_XPOS EQ 450'
				}, 
				'COND2' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_WIDTH EQ 8'
				}, 
				'COND3' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_LENGTH EQ 8'
				},
                'Skip' => 1
			} 
		},
		'EndAnchor' => {
            # end anchor: Line, Position: X position = 23050, Length = 8, Width = 8
			'Constraints' => {
				'COND1' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_XPOS EQ 23050'
				}, 
				'COND2' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_WIDTH EQ 8'
				}, 
				'COND3' => {
					'OBJ_TYPE'  => 'LINE',
					'CONDITION' => 'ATTR_LENGTH EQ 8'
				},
                'Skip' => 1
			}
		},
		'Width' => 22560,
		'ContentDef' => { 'Type' => 'Raw' }
	}
);
1;
__END__