#-------------------------------------------------------------------------------
#  a2w/core/ext/Text.pm:
#  Extension module with additional processing functionalities
#
#  Author  : Fa. Maas
#
#  $V100   2014-06-26    Initial Release
#
#  $V101   2018-01-27    Extended with constants for page begin/end marking (AFP-456)
#
#-------------------------------------------------------------------------------

#
# NOTE:
# Though the filename is a2w/core/ext/Text.pm, in actual it is 'a2w::Text' module extension
#

package a2w::Text;

use a2w::Text;
use a2w::core::log::Logger;

#-----------------------------------------------------------------------
# Workers
#-----------------------------------------------------------------------
#------------------------------------------------------------------------
# _getType
#
# Get type of object
#
# Returns
#   Object type
#
#------------------------------------------------------------------------
sub _getType{
    $this = shift;
    
    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_getType" );
    }

    return "text";
}

#------------------------------------------------------------------------
# _getAttribute
#
# Get value of given attribute
#
# Parameter
# 1. Attribute name
#
# Returns
#   Attribute value, if such attribute exists
#   undef otherwise
#
#------------------------------------------------------------------------
sub _getAttribute{
    $this = shift;
    
    #---- Get logger
    $theLoggerLocal = a2w::core::log::Logger->getSingleton();
    my $bLogTmp = $theLoggerLocal->isRegistered( __PACKAGE__ );

    if ( $bLogTmp ){
        $theLoggerLocal->logFunctionName( __PACKAGE__, "_getAttribute" );
    }

    #---- Get Parameter
    # 1. Attribute name
    # 2. POM object wrapper (optional)
    #
    my $sAttrNamePar = lc( shift );
    my $pomObjectPar = undef;
    if ( @_ > 0 ){
        $pomObjectPar = shift;
    }

    #---- Searches POM object first and then kernel object ----#
    if ( $pomObjectPar != undef ){
        #---- Attribute name to id mapping
        my $hrefObjAttrMapTmp = {
              'xpos'  => $a2w::core::dm::Constants::AT_XPOS
            , 'ypos'  => $a2w::core::dm::Constants::AT_YPOS
            , 'angle' => $a2w::core::dm::Constants::AT_ANGLE
            , 'color' => $a2w::core::dm::Constants::AT_COLOR
            , 'pagefirst' => $a2w::core::dm::Constants::AT_PAGEFIRST # $V101 Change
            , 'pagelast' => $a2w::core::dm::Constants::AT_PAGELAST   # $V101 Change
        };
        if ( $hrefObjAttrMapTmp->{ $sAttrNamePar } != undef ){
            return $pomObjectPar->{ $hrefObjAttrMapTmp->{ $sAttrNamePar } };
        }
        my $hrefTxtAttrMapTmp = {
              'text'    => $a2w::core::dm::Constants::OI_TEXT_VALUE
            , 'textlen' => $a2w::core::dm::Constants::OI_TEXT_LENGTH
        };
        if ( $hrefTxtAttrMapTmp->{ $sAttrNamePar } != undef ){
            return $pomObjectPar->{ $a2w::core::dm::Constants::AT_OBJINFO }{ $hrefTxtAttrMapTmp->{ $sAttrNamePar } };
        }
    }

    #---- Attribute name to accessor method mapping
    my $hrefMethodMapTmp = {
          'xpos'           => 'getXPos'
        , 'ypos'           => 'getYPos'
        , 'text'           => 'getText'
        , 'ebcdictext'     => 'getEBCDICText'
        , 'textlen'        => 'getTextLen'
        , 'unicodetext'    => 'getUnicodeText'
        , 'unicodetextlen' => 'getUnicodeTextLen'
        , 'angle'          => 'getAngle'
        , 'color'          => 'getColor'
        , 'underline'      => 'isUnderline'
        , 'overstrike'     => 'isOverstrike'
    };
    my $sMethodNameTmp = $hrefMethodMapTmp->{ $sAttrNamePar };
    if ( $sMethodNameTmp eq "" ){
        #---- Name to method mapping undefined, return undef
        return undef;
    }

    return $this->$sMethodNameTmp();
}

1;
__END__
