/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig;

import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.xml.crypto.spi.SignatureEngine;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureEngineDSA
implements SignatureEngine {
    private Signature signature;
    private String uri;

    public SignatureEngineDSA(String u, Provider provider) throws NoSuchAlgorithmException {
        String alg = "SHA2withDSA";
        if (u.endsWith("sha1")) {
            alg = "SHA1withDSA";
        } else if (u.endsWith("256")) {
            alg = "SHA2withDSA";
        } else {
            throw new NoSuchAlgorithmException(u);
        }
        this.signature = provider == null ? Signature.getInstance(alg) : Signature.getInstance(alg, provider);
        this.uri = u;
    }

    public void setParameter(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec != null) {
            throw new InvalidAlgorithmParameterException("This algorithm supports  no AlgorithmParameterSpec.");
        }
    }

    public String getURI() {
        return this.uri;
    }

    public void initSign(Key key) throws InvalidKeyException {
        this.signature.initSign((PrivateKey)key);
    }

    public void initVerify(Key key) throws InvalidKeyException {
        this.signature.initVerify((PublicKey)key);
    }

    public void update(byte[] data) throws SignatureException {
        this.signature.update(data);
    }

    public void update(byte[] data, int off, int len) throws SignatureException {
        this.signature.update(data, off, len);
    }

    public byte[] sign() throws SignatureException {
        return SignatureEngineDSA.decodeRSfromASN1(this.signature.sign());
    }

    public boolean verify(byte[] signature) throws SignatureException {
        return this.signature.verify(SignatureEngineDSA.encodeRSinASN1(signature));
    }

    private static byte[] encodeRSinASN1(byte[] rs) throws SignatureException {
        if (rs.length != 40 && rs.length != 64) {
            throw new SignatureException("Invalid DSA signature value size: " + rs.length);
        }
        if (rs.length == 40) {
            int s_index = rs.length / 2;
            int rlen = rs[0] < 0 ? 21 : 20;
            int slen = rs[s_index] < 0 ? 21 : 20;
            byte[] result = new byte[rlen + slen + 6];
            result[0] = 48;
            result[1] = (byte)(rlen + slen + 4);
            result[2] = 2;
            result[3] = (byte)rlen;
            if (rs[0] < 0) {
                result[4] = 0;
                System.arraycopy(rs, 0, result, 5, 20);
            } else {
                System.arraycopy(rs, 0, result, 4, 20);
            }
            result[4 + rlen] = 2;
            result[5 + rlen] = (byte)slen;
            if (rs[s_index] < 0) {
                result[6 + rlen] = 0;
                System.arraycopy(rs, s_index, result, 7 + rlen, rs.length - s_index);
            } else {
                System.arraycopy(rs, s_index, result, 6 + rlen, rs.length - s_index);
            }
            return result;
        }
        int s_index = rs.length / 2;
        int rlen = rs[0] < 0 ? 33 : 32;
        int slen = rs[s_index] < 0 ? 33 : 32;
        byte[] result = new byte[rlen + slen + 6];
        result[0] = 48;
        result[1] = (byte)(rlen + slen + 4);
        result[2] = 2;
        result[3] = (byte)rlen;
        if (rs[0] < 0) {
            result[4] = 0;
            System.arraycopy(rs, 0, result, 5, 32);
        } else {
            System.arraycopy(rs, 0, result, 4, 32);
        }
        result[4 + rlen] = 2;
        result[5 + rlen] = (byte)slen;
        if (rs[s_index] < 0) {
            result[6 + rlen] = 0;
            System.arraycopy(rs, s_index, result, 7 + rlen, rs.length - s_index);
        } else {
            System.arraycopy(rs, s_index, result, 6 + rlen, rs.length - s_index);
        }
        return result;
    }

    private static byte[] decodeRSfromASN1(byte[] asn) throws SignatureException {
        try {
            int gap;
            DerInputStream in = new DerInputStream(asn);
            DerValue[] integers = in.getSequence(2);
            byte[] rPrime = integers[0].getInteger().toByteArray();
            int rlength = rPrime.length;
            byte[] sPrime = integers[1].getInteger().toByteArray();
            int slength = sPrime.length;
            if (rlength < 25) {
                int gap2;
                byte[] result = new byte[40];
                if (rlength < 20) {
                    for (gap2 = 0; gap2 < 20 - rlength; ++gap2) {
                        result[gap2] = 0;
                    }
                    System.arraycopy(rPrime, 0, result, 20 - rlength, rlength);
                } else {
                    System.arraycopy(rPrime, rlength - 20, result, 0, 20);
                }
                if (slength < 20) {
                    for (gap2 = 0; gap2 < 20 - slength; ++gap2) {
                        result[20 + gap2] = 0;
                    }
                    System.arraycopy(sPrime, 0, result, 40 - slength, slength);
                } else {
                    System.arraycopy(sPrime, slength - 20, result, 20, 20);
                }
                return result;
            }
            byte[] result = new byte[64];
            if (rlength < 32) {
                for (gap = 0; gap < 32 - rlength; ++gap) {
                    result[gap] = 0;
                }
                System.arraycopy(rPrime, 0, result, 32 - rlength, rlength);
            } else {
                System.arraycopy(rPrime, rlength - 32, result, 0, 32);
            }
            if (slength < 32) {
                for (gap = 0; gap < 32 - slength; ++gap) {
                    result[32 + gap] = 0;
                }
                System.arraycopy(sPrime, 0, result, 64 - slength, slength);
            } else {
                System.arraycopy(sPrime, slength - 32, result, 32, 32);
            }
            return result;
        }
        catch (IOException e) {
            throw new SignatureException("invalid encoding for signature :" + e);
        }
    }
}

