/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig;

import com.ibm.xml.crypto.spi.SignatureEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureEngineRSA
implements SignatureEngine {
    private Signature signature;
    private String uri;

    public SignatureEngineRSA(String u, Provider provider) throws NoSuchAlgorithmException {
        String alg = "SHA2withRSA";
        if (u.endsWith("sha1")) {
            alg = "SHA1withRSA";
        } else if (u.endsWith("256")) {
            alg = "SHA2withRSA";
        } else if (u.endsWith("384")) {
            alg = "SHA384withRSA";
        } else if (u.endsWith("512")) {
            alg = "SHA512withRSA";
        }
        this.signature = provider == null ? Signature.getInstance(alg) : Signature.getInstance(alg, provider);
        this.uri = u;
    }

    public void setParameter(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec != null) {
            throw new InvalidAlgorithmParameterException("This algorithm supports  no AlgorithmParameterSpec.");
        }
    }

    public String getURI() {
        return this.uri;
    }

    public void initSign(Key key) throws InvalidKeyException {
        this.signature.initSign((PrivateKey)key);
    }

    public void initVerify(Key key) throws InvalidKeyException {
        this.signature.initVerify((PublicKey)key);
    }

    public void update(byte[] data) throws SignatureException {
        this.signature.update(data);
    }

    public void update(byte[] data, int off, int len) throws SignatureException {
        this.signature.update(data, off, len);
    }

    public byte[] sign() throws SignatureException {
        return this.signature.sign();
    }

    public boolean verify(byte[] signature) throws SignatureException {
        return this.signature.verify(signature);
    }
}

