/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtil {
    private DOMUtil() {
    }

    public static Node getPreviousSibling2(Node node) {
        Node ret = node.getPreviousSibling();
        if (ret == null) {
            Node parent = node.getParentNode();
            if (parent == null) {
                return null;
            }
            if (parent.getNodeType() == 5) {
                ret = DOMUtil.getPreviousSibling2(parent);
            }
        } else {
            while (ret.getNodeType() == 5) {
                Node last = ret.getLastChild();
                if (last == null) {
                    ret = DOMUtil.getPreviousSibling2(ret);
                    break;
                }
                ret = last;
            }
        }
        return ret;
    }

    public static Node getNextSibling2(Node node) {
        Node ret = node.getNextSibling();
        if (ret == null) {
            Node parent = node.getParentNode();
            if (parent == null) {
                return null;
            }
            if (parent.getNodeType() == 5) {
                ret = DOMUtil.getNextSibling2(parent);
            }
        } else {
            while (ret.getNodeType() == 5) {
                Node first = ret.getFirstChild();
                if (first == null) {
                    ret = DOMUtil.getNextSibling2(ret);
                    break;
                }
                ret = first;
            }
        }
        return ret;
    }

    public static Node getFirstChild2(Node node) {
        Node ret = node.getFirstChild();
        while (ret != null && ret.getNodeType() == 5) {
            Node first = ret.getFirstChild();
            if (first == null) {
                ret = DOMUtil.getNextSibling2(ret);
                break;
            }
            ret = first;
        }
        return ret;
    }

    public static Node getLastChild2(Node node) {
        Node ret = node.getLastChild();
        while (ret != null && ret.getNodeType() == 5) {
            Node last = ret.getLastChild();
            if (last == null) {
                ret = DOMUtil.getPreviousSibling2(ret);
                break;
            }
            ret = last;
        }
        return ret;
    }

    public static Element getFirstChildElement(Node parent) {
        Node child = DOMUtil.getFirstChild2(parent);
        while (child != null && child.getNodeType() != 1) {
            child = DOMUtil.getNextSibling2(child);
        }
        return (Element)child;
    }

    public static Element getNextElement(Node me) {
        Node next = me;
        while ((next = DOMUtil.getNextSibling2(next)) != null && next.getNodeType() != 1) {
        }
        return (Element)next;
    }

    public static final void removeAllChildren(Node node) {
        while (node.hasChildNodes()) {
            node.removeChild(node.getFirstChild());
        }
    }
}

