/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.crypto.provider.ECNamedCurve;
import com.ibm.xml.crypto.dsig.Constants;
import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.FactoryImpl;
import com.ibm.xml.crypto.dsig.dom.KeyInfoFactoryImpl;
import com.ibm.xml.crypto.dsig.dom.ReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.RetrievalMethodImpl;
import com.ibm.xml.crypto.dsig.dom.SignedInfoImpl;
import com.ibm.xml.crypto.dsig.dom.XMLSignatureImpl;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import com.ibm.xml.crypto.util.Base64;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.LinkedList;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Unmarshalling
implements Constants {
    static final boolean VERBOSE = true;
    static final boolean CHECK_WHITESPACES = true;
    public static final String XML_SPACES = " \r\n\t";
    static final String P192_O = "1.2.840.10045.3.1.1";
    private static final String P192 = "secp192r1";
    static final String P256_O = "1.2.840.10045.3.1.7";
    private static final String P256 = "secp256r1";
    static final String P384_O = "1.3.132.0.34";
    private static final String P384 = "secp384r1";
    static final String P521_O = "1.3.132.0.35";
    private static final String P521 = "secp521r1";
    private DOMValidateContext context;
    private XMLSignatureFactory factory;
    private KeyInfoFactory kifactory;

    static XMLSignature unmarshal(XMLSignatureFactory factory, XMLValidateContext context) throws MarshalException {
        DOMValidateContext dvcontext = (DOMValidateContext)context;
        Node targetNode = dvcontext.getNode();
        if (targetNode.getNodeType() == 9) {
            targetNode = ((Document)targetNode).getDocumentElement();
        }
        if (targetNode.getNodeType() != 1 || !"http://www.w3.org/2000/09/xmldsig#".equals(targetNode.getNamespaceURI()) || !"Signature".equals(targetNode.getLocalName())) {
            throw new MarshalException("The specified node is not <Signature> element.");
        }
        Unmarshalling ucontext = new Unmarshalling(dvcontext, factory);
        return ucontext.unmarshalSignature(targetNode);
    }

    static XMLSignature unmarshal(XMLSignatureFactory factory, XMLStructure sig) throws MarshalException {
        DOMStructure ds = (DOMStructure)sig;
        Unmarshalling ucontext = new Unmarshalling(null, factory);
        return ucontext.unmarshalSignature(ds.getNode());
    }

    static KeyInfo unmarshalKeyInfo(XMLSignatureFactory factory, XMLStructure ki) throws MarshalException {
        DOMStructure ds = (DOMStructure)ki;
        Unmarshalling ucontext = new Unmarshalling(null, factory);
        return ucontext.unmarshalKeyInfo(ds.getNode());
    }

    Unmarshalling(DOMValidateContext c, XMLSignatureFactory f) {
        this.context = c;
        this.factory = f;
        this.kifactory = null;
    }

    private KeyInfoFactory getKeyInfoFactory() throws MarshalException {
        if (this.kifactory == null) {
            try {
                this.kifactory = this.factory.getKeyInfoFactory();
            }
            catch (NoSuchMechanismException xse) {
                throw new MarshalException(xse);
            }
            ((KeyInfoFactoryImpl)this.kifactory).setAlgorithmFactory(this.getAlgorithmFactory());
        }
        return this.kifactory;
    }

    private AlgorithmFactory getAlgorithmFactory() {
        return ((FactoryImpl)this.factory).getAlgorithmFactory();
    }

    private final String getIdAttribute(Node node, String attrName) {
        String id = Unmarshalling.getAttributeValue(node, attrName);
        if (id != null && this.context != null) {
            this.context.setIdAttributeNS((Element)node, null, attrName);
        }
        return id;
    }

    /*
     * Unable to fully structure code
     */
    XMLSignature unmarshalSignature(Node node) throws MarshalException {
        signedInfo = null;
        svId = null;
        signatureValue = null;
        svNode = null;
        keyInfo = null;
        isKeyInfoChecked = false;
        objects = null;
        signatureId = this.getIdAttribute(node, "Id");
        child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            block12: {
                block14: {
                    block13: {
                        if (Unmarshalling.isIgnorableNode(child)) break block12;
                        if (child.getNodeType() != 1) {
                            throw new MarshalException("An element is expected: " + child.getNodeName());
                        }
                        if (!"http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI())) {
                            throw new MarshalException("Unexpected element: " + child.getNodeName());
                        }
                        local = child.getLocalName();
                        if (signedInfo != null) break block13;
                        if (!"SignedInfo".equals(local)) {
                            throw new MarshalException("<SignedInfo> is expected: " + child.getNodeName());
                        }
                        signedInfo = this.unmarshalSignedInfo(child);
                        break block12;
                    }
                    if (signatureValue != null) break block14;
                    if (!"SignatureValue".equals(local)) {
                        throw new MarshalException("<SignatureValue> is expected: " + child.getNodeName());
                    }
                    svNode = child;
                    svId = this.getIdAttribute(child, "Id");
                    if (child.hasChildNodes()) {
                        signatureValue = Unmarshalling.unmarshalBase64Element(child);
                    }
                    break block12;
                }
                if (isKeyInfoChecked) ** GOTO lbl-1000
                isKeyInfoChecked = true;
                if ("KeyInfo".equals(local)) {
                    keyInfo = this.unmarshalKeyInfo(child);
                } else lbl-1000:
                // 2 sources

                {
                    if (!"Object".equals(local)) {
                        throw new MarshalException("<Object> is expected: " + child.getNodeName());
                    }
                    if (objects == null) {
                        objects = new LinkedList<XMLObject>();
                    }
                    objects.add(this.unmarshalObject(child));
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        if (signedInfo == null) {
            throw new MarshalException("The <Signature> has no <SignedInfo>.");
        }
        ret = (XMLSignatureImpl)this.factory.newXMLSignature(signedInfo, keyInfo, objects, signatureId, svId);
        if (signatureValue != null) {
            ret.setSignatureValue(signatureValue);
        }
        ret.setNode(node);
        ret.setSignatureValueNode(svNode);
        return ret;
    }

    SignedInfo unmarshalSignedInfo(Node node) throws MarshalException {
        CanonicalizationMethod c14nMethod = null;
        SignatureMethod signatureMethod = null;
        LinkedList<Reference> references = new LinkedList<Reference>();
        String id = null;
        id = this.getIdAttribute(node, "Id");
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI())) {
                    throw new MarshalException("Unexpected element: " + child.getNodeName());
                }
                String local = child.getLocalName();
                if (c14nMethod == null) {
                    if (!"CanonicalizationMethod".equals(local)) {
                        throw new MarshalException("<CanonicalizationMethod> is expected: " + child.getNodeName());
                    }
                    c14nMethod = this.unmarshalC14nMethod(child);
                } else if (signatureMethod == null) {
                    if (!"SignatureMethod".equals(local)) {
                        throw new MarshalException("<SignatureMethod> is expected: " + child.getNodeName());
                    }
                    signatureMethod = this.unmarshalSignatureMethod(child);
                } else {
                    if (!"Reference".equals(local)) {
                        throw new MarshalException("<Reference> is expected: " + child.getNodeName());
                    }
                    references.add(this.unmarshalReference(child));
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        if (c14nMethod == null) {
            throw new MarshalException("The <SignedInfo> has no <CanonicalizationMethod>.");
        }
        if (signatureMethod == null) {
            throw new MarshalException("The <SignedInfo> has no <SignatureMethod>.");
        }
        if (references.size() == 0) {
            throw new MarshalException("The <SignedInfo> has no <Reference>.");
        }
        SignedInfo signedInfo = this.factory.newSignedInfo(c14nMethod, signatureMethod, references, id);
        ((SignedInfoImpl)signedInfo).setNode(node);
        return signedInfo;
    }

    CanonicalizationMethod unmarshalC14nMethod(Node node) throws MarshalException {
        Object spec = null;
        String algorithm = Unmarshalling.getAttributeValue(node, "Algorithm");
        if (algorithm == null) {
            throw new MarshalException("The <CanonicalizationMethod> has no Algorithm attribute.");
        }
        try {
            return this.factory.newCanonicalizationMethod(algorithm, new DOMStructure(node));
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
    }

    SignatureMethod unmarshalSignatureMethod(Node node) throws MarshalException {
        String algorithm = Unmarshalling.getAttributeValue(node, "Algorithm");
        if (algorithm == null) {
            throw new MarshalException("The <SignatureMethod> has no Algorithm attribute.");
        }
        try {
            SignatureMethodParameterSpec spec = (SignatureMethodParameterSpec)this.getAlgorithmFactory().unmarshalParameter(algorithm, (Element)node);
            return this.factory.newSignatureMethod(algorithm, spec);
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
    }

    Reference unmarshalReference(Node node) throws MarshalException {
        DigestMethod digestMethod = null;
        List transforms = null;
        byte[] digestValue = null;
        Node dvNode = null;
        String uri = Unmarshalling.getAttributeValue(node, "URI");
        String type = Unmarshalling.getAttributeValue(node, "Type");
        String id = this.getIdAttribute(node, "Id");
        int state = 0;
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI())) {
                    throw new MarshalException("Unexpected element: " + child.getNodeName());
                }
                String local = child.getLocalName();
                switch (state) {
                    case 0: {
                        if ("Transforms".equals(local)) {
                            transforms = this.unmarshalTransforms(child);
                            state = 1;
                            break;
                        }
                        if ("DigestMethod".equals(local)) {
                            digestMethod = this.unmarshalDigestMethod(child);
                            state = 2;
                            break;
                        }
                        throw new MarshalException("Transforms or DigestMethod is expected: " + child.getNodeName());
                    }
                    case 1: {
                        if ("DigestMethod".equals(local)) {
                            digestMethod = this.unmarshalDigestMethod(child);
                            state = 2;
                            break;
                        }
                        throw new MarshalException("DigestMethod is expected: " + child.getNodeName());
                    }
                    case 2: {
                        if ("DigestValue".equals(local)) {
                            dvNode = child;
                            if (child.hasChildNodes()) {
                                digestValue = Unmarshalling.unmarshalBase64Element(child);
                            }
                            state = 3;
                            break;
                        }
                        throw new MarshalException("DigestValue is expected: " + child.getNodeName());
                    }
                    case 3: {
                        throw new MarshalException("Unexpected element: " + child.getNodeName());
                    }
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        if (state != 3) {
            throw new MarshalException("Invalid Reference elemnt.");
        }
        ReferenceImpl reference = (ReferenceImpl)this.factory.newReference(uri, digestMethod, transforms, type, id);
        if (digestValue != null) {
            reference.setDigestValue(digestValue);
        }
        reference.setHere(((Element)node).getAttributeNode("URI"));
        reference.setDigestValueNode(dvNode);
        return reference;
    }

    List unmarshalTransforms(Node node) throws MarshalException {
        LinkedList<Transform> transforms = null;
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI()) || !"Transform".equals(child.getLocalName())) {
                    throw new MarshalException("Unexpected element: " + child.getNodeName());
                }
                Transform tr = this.unmarshalTransform(child);
                if (transforms == null) {
                    transforms = new LinkedList<Transform>();
                }
                transforms.add(tr);
            }
            child = DOMUtil.getNextSibling2(child);
        }
        if (transforms == null) {
            throw new MarshalException("<Transforms> without <Transform>.");
        }
        return transforms;
    }

    Transform unmarshalTransform(Node node) throws MarshalException {
        Transform tr;
        String algorithm = Unmarshalling.getAttributeValue(node, "Algorithm");
        if (algorithm == null) {
            throw new MarshalException("A Transform has no Algorithm= attribute.");
        }
        try {
            tr = this.factory.newTransform(algorithm, new DOMStructure(node));
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
        ((TransformBase)tr).setNode(node);
        return tr;
    }

    DigestMethod unmarshalDigestMethod(Node node) throws MarshalException {
        String algorithm = Unmarshalling.getAttributeValue(node, "Algorithm");
        if (algorithm == null) {
            throw new MarshalException("The <DigestMethod> has no Algorithm attribute.");
        }
        try {
            DigestMethodParameterSpec spec = (DigestMethodParameterSpec)this.getAlgorithmFactory().unmarshalParameter(algorithm, (Element)node);
            return this.factory.newDigestMethod(algorithm, spec);
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
    }

    KeyInfo unmarshalKeyInfo(Node node) throws MarshalException {
        LinkedList<DOMStructure> content = null;
        KeyInfoFactory kifactory = this.getKeyInfoFactory();
        String id = this.getIdAttribute(node, "Id");
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            XMLStructure item;
            if (child.getNodeType() != 1) {
                item = new DOMStructure(child);
            } else {
                String ns = child.getNamespaceURI();
                String local = child.getLocalName();
                item = "http://www.w3.org/2000/09/xmldsig#".equals(ns) && "KeyName".equals(local) ? this.unmarshalKeyName(child) : ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "KeyValue".equals(local) ? this.unmarshalKeyValue(child) : ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "RetrievalMethod".equals(local) ? this.unmarshalRetrievalMethod(child) : ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "X509Data".equals(local) ? this.unmarshalX509Data(child) : ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "PGPData".equals(local) ? this.unmarshalPGPData(child) : new DOMStructure(child)))));
            }
            if (content == null) {
                content = new LinkedList<DOMStructure>();
            }
            content.add((DOMStructure)item);
            child = DOMUtil.getNextSibling2(child);
        }
        return kifactory.newKeyInfo(content, id);
    }

    KeyName unmarshalKeyName(Node node) throws MarshalException {
        return this.getKeyInfoFactory().newKeyName(Unmarshalling.getStringValue(node));
    }

    KeyValue unmarshalKeyValue(Node node) throws MarshalException {
        PublicKey key = null;
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                if (key != null) {
                    throw new MarshalException("Unsupported element: " + child.getNodeName());
                }
                String ns = child.getNamespaceURI();
                String local = child.getLocalName();
                if ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "DSAKeyValue".equals(local)) {
                    key = this.unmarshalDSAKeyValue(child);
                } else if ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "RSAKeyValue".equals(local)) {
                    key = this.unmarshalRSAKeyValue(child);
                } else if ("http://www.w3.org/2001/04/xmldsig-more#".equals(ns) && "ECDSAKeyValue".equals(local)) {
                    key = this.unmarshalECDSAKeyValue(child);
                } else {
                    throw new MarshalException("Unsupported element: " + child.getNodeName());
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        try {
            return this.getKeyInfoFactory().newKeyValue(key);
        }
        catch (KeyException ke) {
            throw new MarshalException(ke);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PublicKey unmarshalECDSAKeyValue(Node node) throws MarshalException {
        PublicKey key = null;
        Object x = null;
        Object y = null;
        String curve = null;
        TwoBigInts results = null;
        int state = 0;
        Node child = DOMUtil.getFirstChild2(node);
        block6: while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                String ns = child.getNamespaceURI();
                String local = child.getLocalName();
                if (!"http://www.w3.org/2001/04/xmldsig-more#".equals(ns)) {
                    throw new MarshalException("An element in http://www.w3.org/2001/04/xmldsig-more# is expected: " + child.getNodeName());
                }
                switch (state) {
                    case 0: {
                        if (!"DomainParameters".equals(local)) {
                            throw new MarshalException("Unexpected element: " + local);
                        }
                        state = 1;
                        curve = Unmarshalling.urnToCurveName(this.unmarshalECCurve(child));
                        break;
                    }
                    case 1: {
                        if (!"PublicKey".equals(local)) {
                            throw new MarshalException("Unexpected element: " + local);
                        }
                        state = 2;
                        results = this.unmarshalECPublicKey(child);
                        break block6;
                    }
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        if (state != 2) {
            throw new MarshalException("Invalid ECKeyValue");
        }
        if (results == null) {
            throw new MarshalException("Internal Error: could not read X and Y");
        }
        try {
            ECNamedCurve nc = new ECNamedCurve(curve);
            return this.getAlgorithmFactory().generatePublic(new ECPublicKeySpec(new ECPoint(results.getX(), results.getY()), nc.getECParameterSpec()));
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
    }

    String unmarshalECCurve(Node node) throws MarshalException {
        String urn = null;
        String URN_OID = "urn:oid:";
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                String ns = child.getNamespaceURI();
                String local = child.getLocalName();
                if (!"http://www.w3.org/2001/04/xmldsig-more#".equals(ns)) {
                    throw new MarshalException("An element in http://www.w3.org/2001/04/xmldsig-more# is expected: " + child.getNodeName());
                }
                if (!"NamedCurve".equals(local)) {
                    throw new MarshalException("Unexpected element: " + local);
                }
                urn = Unmarshalling.getAttributeValue(child, "URN");
                if (urn != null) {
                    int index = urn.indexOf("urn:oid:");
                    if (index == -1) {
                        throw new MarshalException("Unexpected attribute value: " + urn);
                    }
                    urn = urn.substring(index + "urn:oid:".length());
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return urn;
    }

    TwoBigInts unmarshalECPublicKey(Node node) throws MarshalException {
        BigInteger y = null;
        BigInteger x = null;
        int state = 0;
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                String ns = child.getNamespaceURI();
                String local = child.getLocalName();
                if (!"http://www.w3.org/2001/04/xmldsig-more#".equals(ns)) {
                    throw new MarshalException("An element in http://www.w3.org/2001/04/xmldsig-more# is expected: " + child.getNodeName());
                }
                switch (state) {
                    case 0: {
                        if (!"X".equals(local)) {
                            throw new MarshalException("Unexpected element: " + local);
                        }
                        state = 1;
                        x = Unmarshalling.unmarshalDecimalBigInt(child, "Value");
                        break;
                    }
                    case 1: {
                        if (!"Y".equals(local)) {
                            throw new MarshalException("Unexpected element: " + local);
                        }
                        state = 2;
                        y = Unmarshalling.unmarshalDecimalBigInt(child, "Value");
                        break;
                    }
                    default: {
                        throw new MarshalException("Unexpected element: " + local);
                    }
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return new TwoBigInts(x, y);
    }

    PublicKey unmarshalDSAKeyValue(Node node) throws MarshalException {
        BigInteger p = null;
        BigInteger q = null;
        BigInteger g = null;
        BigInteger y = null;
        int state = 0;
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                String ns = child.getNamespaceURI();
                String local = child.getLocalName();
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(ns)) {
                    throw new MarshalException("An element in http://www.w3.org/2000/09/xmldsig# is expected: " + child.getNodeName());
                }
                switch (state) {
                    case 0: {
                        if ("P".equals(local)) {
                            p = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 1;
                            break;
                        }
                        if ("G".equals(local)) {
                            g = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 3;
                            break;
                        }
                        if ("Y".equals(local)) {
                            y = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 4;
                            break;
                        }
                        throw new MarshalException("Unexpected element: " + child.getNodeName());
                    }
                    case 1: {
                        if ("Q".equals(local)) {
                            q = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 2;
                            break;
                        }
                        throw new MarshalException("Unexpected element: " + child.getNodeName());
                    }
                    case 2: {
                        if ("G".equals(local)) {
                            g = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 3;
                            break;
                        }
                        if ("Y".equals(local)) {
                            y = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 4;
                            break;
                        }
                        throw new MarshalException("Unexpected element: " + child.getNodeName());
                    }
                    case 3: {
                        if ("Y".equals(local)) {
                            y = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 4;
                            break;
                        }
                        throw new MarshalException("Unexpected element: " + child.getNodeName());
                    }
                    case 4: {
                        BigInteger seed;
                        if ("J".equals(local)) {
                            BigInteger j = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 5;
                            break;
                        }
                        if ("Seed".equals(local)) {
                            seed = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 6;
                            break;
                        }
                        throw new MarshalException("Unexpected element: " + child.getNodeName());
                    }
                    case 5: {
                        BigInteger seed;
                        if ("Seed".equals(local)) {
                            seed = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 6;
                            break;
                        }
                        throw new MarshalException("Unexpected element: " + child.getNodeName());
                    }
                    case 6: {
                        if ("PgenCounter".equals(local)) {
                            BigInteger pgen = Unmarshalling.unmarshalCryptoBinary(child);
                            state = 7;
                            break;
                        }
                        throw new MarshalException("Unexpected element: " + child.getNodeName());
                    }
                    case 7: {
                        throw new MarshalException("Unexpected element: " + child.getNodeName());
                    }
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        if (state != 4 && state != 5 && state != 7) {
            throw new MarshalException("Invalid DSAKeyValue.");
        }
        if (y == null) {
            throw new MarshalException("Internal Error: Y is null.");
        }
        try {
            return this.getAlgorithmFactory().generatePublic(new DSAPublicKeySpec(y, p, q, g));
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
    }

    PublicKey unmarshalRSAKeyValue(Node node) throws MarshalException {
        BigInteger modulus = null;
        BigInteger exponent = null;
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                String ns = child.getNamespaceURI();
                String local = child.getLocalName();
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(ns)) {
                    throw new MarshalException("An element in http://www.w3.org/2000/09/xmldsig# is expected: " + child.getNodeName());
                }
                if (modulus == null) {
                    if (!"Modulus".equals(local)) {
                        throw new MarshalException("<Modulus> is expected: " + child.getNodeName());
                    }
                    modulus = Unmarshalling.unmarshalCryptoBinary(child);
                } else if (exponent == null) {
                    if (!"Exponent".equals(local)) {
                        throw new MarshalException("<Exponent> is expected: " + child.getNodeName());
                    }
                    exponent = Unmarshalling.unmarshalCryptoBinary(child);
                } else {
                    throw new MarshalException("Unexpected element: " + child.getNodeName());
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        if (modulus == null || exponent == null) {
            throw new MarshalException("Invalid RSAKeyValue.");
        }
        try {
            return this.getAlgorithmFactory().generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RetrievalMethod unmarshalRetrievalMethod(Node node) throws MarshalException {
        List transforms = null;
        String uri = Unmarshalling.getAttributeValue(node, "URI");
        String type = Unmarshalling.getAttributeValue(node, "Type");
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI())) {
                    throw new MarshalException("Unexpected element: " + child.getNodeName());
                }
                String local = child.getLocalName();
                if (transforms != null) throw new MarshalException("Unexpected element: " + child.getNodeName());
                if (!"Transforms".equals(local)) throw new MarshalException("Transforms is expected: " + child.getNodeName());
                transforms = this.unmarshalTransforms(child);
            }
            child = DOMUtil.getNextSibling2(child);
        }
        RetrievalMethod rm = this.getKeyInfoFactory().newRetrievalMethod(uri, type, transforms);
        ((RetrievalMethodImpl)rm).setHere(((Element)node).getAttributeNode("URI"));
        return rm;
    }

    XMLStructure unmarshalX509Data(Node node) throws MarshalException {
        LinkedList<Object> content = new LinkedList<Object>();
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                ByteArrayInputStream is;
                byte[] bin;
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                String ns = child.getNamespaceURI();
                String local = child.getLocalName();
                if ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "X509IssuerSerial".equals(local)) {
                    content.add(this.unmarshalX509IssuerSerial(child));
                } else if ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "X509SKI".equals(local)) {
                    content.add(Unmarshalling.unmarshalBase64Element(child));
                } else if ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "X509SubjectName".equals(local)) {
                    content.add(Unmarshalling.getStringValue(child).trim());
                } else if ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "X509Certificate".equals(local)) {
                    bin = Unmarshalling.unmarshalBase64Element(child);
                    try {
                        is = new ByteArrayInputStream(bin);
                        content.add(this.getAlgorithmFactory().generateCertificate(is));
                    }
                    catch (Exception ex) {
                        throw new MarshalException(ex);
                    }
                } else if ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "X509CRL".equals(local)) {
                    bin = Unmarshalling.unmarshalBase64Element(child);
                    try {
                        is = new ByteArrayInputStream(bin);
                        content.add(this.getAlgorithmFactory().generateCRL(is));
                    }
                    catch (Exception ex) {
                        throw new MarshalException(ex);
                    }
                } else {
                    content.add(new DOMStructure(child));
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return this.getKeyInfoFactory().newX509Data(content);
    }

    XMLStructure unmarshalX509IssuerSerial(Node node) throws MarshalException {
        String issuer = null;
        BigInteger serial = null;
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                String ns = child.getNamespaceURI();
                String local = child.getLocalName();
                if (issuer == null) {
                    if (!"http://www.w3.org/2000/09/xmldsig#".equals(ns) || !"X509IssuerName".equals(local)) {
                        throw new MarshalException("<X509IssuerName> is expected: " + child.getNodeName());
                    }
                    issuer = Unmarshalling.getStringValue(child).trim();
                } else if (serial == null) {
                    if (!"http://www.w3.org/2000/09/xmldsig#".equals(ns) || !"X509SerialNumber".equals(local)) {
                        throw new MarshalException("<X509SerialNumber> is expected: " + child.getNodeName());
                    }
                    serial = new BigInteger(Unmarshalling.getStringValue(child));
                } else {
                    throw new MarshalException("No element is expected: " + child.getNodeName());
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return this.getKeyInfoFactory().newX509IssuerSerial(issuer, serial);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PGPData unmarshalPGPData(Node node) throws MarshalException {
        byte[] keyid = null;
        byte[] keypacket = null;
        LinkedList<DOMStructure> content = null;
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                String ns = child.getNamespaceURI();
                String local = child.getLocalName();
                if ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "PGPKeyID".equals(local)) {
                    if (keyid != null) throw new MarshalException("<PGPKeyID> is unexpected.");
                    keyid = Unmarshalling.unmarshalBase64Element(child);
                } else if ("http://www.w3.org/2000/09/xmldsig#".equals(ns) && "PGPKeyPacket".equals(local)) {
                    if (keypacket != null) throw new MarshalException("<PGPKeyPacket> is unexpected.");
                    keypacket = Unmarshalling.unmarshalBase64Element(child);
                } else {
                    if ("http://www.w3.org/2000/09/xmldsig#".equals(ns)) {
                        throw new MarshalException("Unexpected element: " + child.getNodeName());
                    }
                    if (content == null) {
                        content = new LinkedList<DOMStructure>();
                    }
                    content.add(new DOMStructure(child));
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return this.getKeyInfoFactory().newPGPData(keyid, keypacket, content);
    }

    XMLObject unmarshalObject(Node node) throws MarshalException {
        LinkedList<XMLStructure> content = null;
        String mimeType = Unmarshalling.getAttributeValue(node, "MimeType");
        String encoding = Unmarshalling.getAttributeValue(node, "Encoding");
        String id = this.getIdAttribute(node, "Id");
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            XMLStructure st = child.getNodeType() == 1 ? this.unmarshalAny(child) : new DOMStructure(child);
            if (content == null) {
                content = new LinkedList<XMLStructure>();
            }
            content.add(st);
            child = DOMUtil.getNextSibling2(child);
        }
        return this.factory.newXMLObject(content, id, mimeType, encoding);
    }

    XMLStructure unmarshalAny(Node node) throws MarshalException {
        String ns = node.getNamespaceURI();
        String local = node.getLocalName();
        KeyInfoFactory kifactory = this.getKeyInfoFactory();
        if (!"http://www.w3.org/2000/09/xmldsig#".equals(ns)) {
            return new DOMStructure(node);
        }
        if ("CanonicalizationMethod".equals(local)) {
            return this.unmarshalC14nMethod(node);
        }
        if ("DigestMethod".equals(local)) {
            return this.unmarshalDigestMethod(node);
        }
        if ("Manifest".equals(local)) {
            return this.unmarshalManifest(node);
        }
        if ("Reference".equals(local)) {
            return this.unmarshalReference(node);
        }
        if ("SignatureMethod".equals(local)) {
            return this.unmarshalSignatureMethod(node);
        }
        if ("SignatureProperties".equals(local)) {
            return this.unmarshalSignatureProperties(node);
        }
        if ("SignatureProperty".equals(local)) {
            return this.unmarshalSignatureProperty(node);
        }
        if ("SignedInfo".equals(local)) {
            return this.unmarshalSignedInfo(node);
        }
        if ("Transform".equals(local)) {
            return this.unmarshalTransform(node);
        }
        if ("Object".equals(local)) {
            return this.unmarshalObject(node);
        }
        if ("Signature".equals(local)) {
            return this.unmarshalSignature(node);
        }
        if ("KeyInfo".equals(local)) {
            return this.unmarshalKeyInfo(node);
        }
        if ("KeyName".equals(local)) {
            return this.unmarshalKeyName(node);
        }
        if ("KeyValue".equals(local)) {
            return this.unmarshalKeyValue(node);
        }
        if ("PGPData".equals(local)) {
            return this.unmarshalPGPData(node);
        }
        if ("RetrievalMethod".equals(local)) {
            return this.unmarshalRetrievalMethod(node);
        }
        if ("X509Data".equals(local)) {
            return this.unmarshalX509Data(node);
        }
        if ("X509IssuerSerial".equals(local)) {
            return this.unmarshalX509IssuerSerial(node);
        }
        return new DOMStructure(node);
    }

    Manifest unmarshalManifest(Node node) throws MarshalException {
        String id = null;
        LinkedList<Reference> references = new LinkedList<Reference>();
        id = this.getIdAttribute(node, "Id");
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI()) || !"Reference".equals(child.getLocalName())) {
                    throw new MarshalException("<Reference> is expected: " + child.getNodeName());
                }
                references.add(this.unmarshalReference(child));
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return this.factory.newManifest(references, id);
    }

    SignatureProperties unmarshalSignatureProperties(Node node) throws MarshalException {
        String id = null;
        LinkedList<SignatureProperty> props = new LinkedList<SignatureProperty>();
        id = this.getIdAttribute(node, "Id");
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                if (child.getNodeType() != 1) {
                    throw new MarshalException("An element is expected: " + child.getNodeName());
                }
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI()) || !"SignatureProperty".equals(child.getLocalName())) {
                    throw new MarshalException("<SignatureProperty> is expected: " + child.getNodeName());
                }
                props.add(this.unmarshalSignatureProperty(child));
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return this.factory.newSignatureProperties(props, id);
    }

    SignatureProperty unmarshalSignatureProperty(Node node) throws MarshalException {
        LinkedList<DOMStructure> content = new LinkedList<DOMStructure>();
        String id = this.getIdAttribute(node, "Id");
        String target = Unmarshalling.getAttributeValue(node, "Target");
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (child.getNodeType() == 1 && "http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI())) {
                throw new MarshalException("SignatureProperty has a non-##other element: " + child.getNodeName());
            }
            content.add(new DOMStructure(child));
            child = DOMUtil.getNextSibling2(child);
        }
        return this.factory.newSignatureProperty(content, target, id);
    }

    public static String getStringValue(Node node) throws MarshalException {
        StringBuffer buffer = null;
        String first = null;
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (child.getNodeType() != 8 && child.getNodeType() != 7) {
                if (child.getNodeType() != 3 && child.getNodeType() != 4) {
                    throw new MarshalException("Text is expected: " + child.getNodeName());
                }
                if (first == null) {
                    first = child.getNodeValue();
                } else {
                    String next = child.getNodeValue();
                    if (buffer == null) {
                        buffer = new StringBuffer(first.length() + next.length());
                        buffer.append(first);
                    }
                    buffer.append(next);
                }
            }
            child = DOMUtil.getNextSibling2(child);
        }
        if (buffer != null) {
            return new String(buffer);
        }
        if (first != null) {
            return first;
        }
        return "";
    }

    static byte[] unmarshalBase64Element(Node node) throws MarshalException {
        return Unmarshalling.unmarshalBase64Value(node, null);
    }

    static byte[] unmarshalBase64Value(Node node, String attrName) throws MarshalException {
        String b64;
        String string = b64 = attrName == null ? Unmarshalling.getStringValue(node) : Unmarshalling.getAttributeValue(node, attrName);
        if (b64 == null || b64.length() <= 0) {
            String msg = attrName == null ? "The content of the element " + node.getNodeName() + " is empty." : "No attribute named " + attrName + " on node " + node.getNodeName();
            throw new MarshalException(msg);
        }
        return Base64.decode(b64);
    }

    static BigInteger unmarshalCryptoBinary(Node node) throws MarshalException {
        return new BigInteger(1, Unmarshalling.unmarshalBase64Element(node));
    }

    static BigInteger unmarshalCryptoBinary(Node node, String attrName) throws MarshalException {
        return new BigInteger(1, Unmarshalling.unmarshalBase64Value(node, attrName));
    }

    static BigInteger unmarshalDecimalBigInt(Node node, String attrName) throws MarshalException {
        String s;
        String string = s = attrName == null ? Unmarshalling.getStringValue(node) : Unmarshalling.getAttributeValue(node, attrName);
        if (s == null || s.length() <= 0) {
            String msg = attrName == null ? "The content of the element " + node.getNodeName() + " is empty." : "No attribute named " + attrName + " on node " + node.getNodeName();
            throw new MarshalException(msg);
        }
        return new BigInteger(s);
    }

    public static boolean isIgnorableNode(Node child) throws MarshalException {
        if (child.getNodeType() == 8 || child.getNodeType() == 7) {
            return true;
        }
        if (child.getNodeType() == 3 || child.getNodeType() == 4) {
            if (Unmarshalling.isWhitespaceNode(child)) {
                return true;
            }
            throw new MarshalException("Non-whistespace character is not allowed.");
        }
        return false;
    }

    public static boolean isIgnorableNode2(Node child) {
        if (child.getNodeType() == 8 || child.getNodeType() == 7) {
            return true;
        }
        return (child.getNodeType() == 3 || child.getNodeType() == 4) && Unmarshalling.isWhitespaceNode(child);
    }

    static boolean isWhitespaceNode(Node node) {
        String str = node.getNodeValue();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch > ' ') {
                return false;
            }
            if (XML_SPACES.indexOf(ch) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean confirmEmpty(Node node) throws MarshalException {
        Node child = DOMUtil.getFirstChild2(node);
        while (child != null) {
            if (!Unmarshalling.isIgnorableNode(child)) {
                return false;
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return true;
    }

    public static String getAttributeValue(Node node, String attr) {
        Attr a = ((Element)node).getAttributeNode(attr);
        if (a == null) {
            String ns = null;
            NamedNodeMap attrMap = node.getAttributes();
            int numAttr = attrMap.getLength();
            for (int i = 0; i < numAttr; ++i) {
                Node childNode = attrMap.item(i);
                String name = childNode.getNodeName();
                if (!name.startsWith("xmlns:")) continue;
                ns = name.split("xmlns:")[1];
                String nsAttr = attr;
                if (null == ns || null == (a = ((Element)node).getAttributeNode(nsAttr = ns + ":" + nsAttr))) continue;
                return a.getNodeValue();
            }
            if (null == a) {
                return null;
            }
        }
        return a.getNodeValue();
    }

    private static String urnToCurveName(String urn) throws MarshalException {
        String curve = null;
        if (P192_O.equals(urn)) {
            curve = P192;
        } else if (P256_O.equals(urn)) {
            curve = P256;
        } else if (P384_O.equals(urn)) {
            curve = P384;
        } else if (P521_O.equals(urn)) {
            curve = P521;
        } else {
            throw new MarshalException("Unknown curve: " + urn);
        }
        return curve;
    }

    private static class TwoBigInts {
        private BigInteger x;
        private BigInteger y;

        private TwoBigInts(BigInteger x, BigInteger y) {
            this.x = x;
            this.y = y;
        }

        BigInteger getX() {
            return this.x;
        }

        BigInteger getY() {
            return this.y;
        }
    }
}

