/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.ECPrivateKey;
import com.ibm.crypto.fips.provider.ECPublicKey;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.SelfTest;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECKeyFactory
extends KeyFactorySpi
implements AlgorithmStatus {
    private static final String[] z;

    @Override
    public boolean isFipsApproved() {
        return true;
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PrivateKey a(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                return new ECPrivateKey(byArray);
            }
            if (keySpec instanceof ECPrivateKeySpec) {
                ECParameterSpec eCParameterSpec = ((ECPrivateKeySpec)keySpec).getParams();
                BigInteger bigInteger = ((ECPrivateKeySpec)keySpec).getS();
                return new ECPrivateKey(bigInteger, eCParameterSpec);
            }
            throw new InvalidKeySpecException(z[0]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.b(keySpec);
        }
        throw new FIPSRuntimeException();
    }

    protected PublicKey b(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof X509EncodedKeySpec) {
                byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
                return new ECPublicKey(byArray);
            }
            if (keySpec instanceof ECPublicKeySpec) {
                ECParameterSpec eCParameterSpec = ((ECPublicKeySpec)keySpec).getParams();
                ECPoint eCPoint = ((ECPublicKeySpec)keySpec).getW();
                return new ECPublicKey(eCPoint, eCParameterSpec);
            }
            throw new InvalidKeySpecException(z[0]);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(invalidKeyException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeySpecException(invalidParameterSpecException.getMessage());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(key, clazz);
        }
        throw new FIPSRuntimeException();
    }

    protected KeySpec a(Key key, Class clazz) throws InvalidKeySpecException {
        throw new UnsupportedOperationException(z[1]);
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (SelfTest.isFipsRunnable()) {
            return this.a(key);
        }
        throw new FIPSRuntimeException();
    }

    protected Key a(Key key) throws InvalidKeyException {
        throw new UnsupportedOperationException(z[2]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "*X5\u0016.\u000fY4\u0017;\u001b\u0016-\u0006'_E6\u0006=\u0016P/\u0000?\u000b_)\r";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 127;
                                break;
                            }
                            case 1: {
                                n9 = 54;
                                break;
                            }
                            case 2: {
                                n9 = 70;
                                break;
                            }
                            case 3: {
                                n9 = 99;
                                break;
                            }
                            default: {
                                n9 = 94;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u001aX!\n0\u001aq#\u0017\u0015\u001aO\u0015\u0013;\u001c\u0016/\u0010~\nX5\u0016.\u000fY4\u0017;\u001b\u0016 \f,_s\u0005(;\u0006p'\u0000*\u0010D?";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u001aX!\n0\u001ab4\u00020\fZ'\u0017;4S?C7\f\u00163\r-\nF6\f,\u000bS\"C8\u0010Df&\u001d4S?%?\u001cB)\u0011'";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

