/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.ECParameters;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;

public final class ECPublicKey
extends X509Key
implements java.security.interfaces.ECPublicKey,
ECKey,
Serializable {
    static final long serialVersionUID = -6195576206652962694L;
    private ECPoint w;
    private ECParameterSpec params;
    private static final String z;

    public ECPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public ECPublicKey(ECPoint eCPoint, ECParameterSpec eCParameterSpec) throws InvalidKeyException, InvalidParameterSpecException {
        this.w = eCPoint;
        this.params = eCParameterSpec;
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.a(eCParameterSpec));
        this.key = ECParameters.encodePoint(eCPoint, eCParameterSpec.getCurve());
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            AlgorithmParameters algorithmParameters = this.algid.getAlgParameters();
            this.params = algorithmParameters.getParameterSpec(ECParameterSpec.class);
            this.w = ECParameters.decodePoint(this.key, this.params.getCurve());
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(z, iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException(z, invalidParameterSpecException);
        }
    }

    @Override
    public ECPoint getW() {
        return this.w;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    public void zeroize() {
        this.w = new ECPoint(BigInteger.ZERO, BigInteger.ZERO);
        this.params = null;
    }

    protected void finalize() {
        this.zeroize();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "7\u0012^bd\u0017\u0018\bFK^\u0017Mz".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 126;
                            break;
                        }
                        case 1: {
                            n7 = 124;
                            break;
                        }
                        case 2: {
                            n7 = 40;
                            break;
                        }
                        case 3: {
                            n7 = 3;
                            break;
                        }
                        default: {
                            n7 = 8;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        z = new String(cArray).intern();
    }
}

