/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.amino.map;

import com.ibm.rmi.util.JVMVersionCheck;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentWeakHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    final int segmentMask;
    final int segmentShift;
    final WeakHashMap<K, V>[] segments;
    transient Set<K> keySet;

    private static int hash(Object object) {
        if (object == null) {
            return 0;
        }
        int n = object.hashCode();
        n ^= n << 7;
        n ^= n >>> 3;
        n ^= n << 27;
        n ^= n >>> 15;
        return n;
    }

    private final WeakHashMap<K, V> segmentFor(int n) {
        return this.segments[n >>> this.segmentShift & this.segmentMask];
    }

    public ConcurrentWeakHashMap(int n, float f, int n2) {
        int n3;
        int n4;
        int n5;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n);
        }
        if (f >= 1.0f || f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        if (n2 <= 1) {
            throw new IllegalArgumentException("Illegal concurrencyLevel: " + n2);
        }
        if (n2 > 65536) {
            n2 = 65536;
        }
        int n6 = 0;
        for (n5 = 1; n5 < n2; n5 <<= 1) {
            ++n6;
        }
        this.segmentShift = 32 - n6;
        this.segmentMask = n5 - 1;
        this.segments = new WeakHashMap[n5];
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if ((n4 = n / n5) * n5 < n) {
            ++n4;
        }
        for (n3 = 1; n3 < n4; n3 <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new WeakHashMap(n3, f);
        }
    }

    public ConcurrentWeakHashMap(int n) {
        this(n, 0.75f, 16);
    }

    public ConcurrentWeakHashMap() {
        this(32, 0.75f, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        WeakHashMap<K, V> weakHashMap;
        int n = ConcurrentWeakHashMap.hash(k);
        WeakHashMap<K, V> weakHashMap2 = weakHashMap = this.segmentFor(n);
        synchronized (weakHashMap2) {
            return weakHashMap.put(k, v);
        }
    }

    @Override
    public V get(Object object) {
        int n = ConcurrentWeakHashMap.hash(object);
        WeakHashMap<K, V> weakHashMap = this.segmentFor(n);
        if (JVMVersionCheck.isIBMJ9VM) {
            return weakHashMap.get(object);
        }
        return this.synchronizedGet(weakHashMap, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V synchronizedGet(WeakHashMap<K, V> weakHashMap, Object object) {
        WeakHashMap<K, V> weakHashMap2 = weakHashMap;
        synchronized (weakHashMap2) {
            return weakHashMap.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object object) {
        WeakHashMap<K, V> weakHashMap;
        int n = ConcurrentWeakHashMap.hash(object);
        WeakHashMap<K, V> weakHashMap2 = weakHashMap = this.segmentFor(n);
        synchronized (weakHashMap2) {
            return weakHashMap.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object, Object object2) {
        WeakHashMap<K, V> weakHashMap;
        int n = ConcurrentWeakHashMap.hash(object);
        WeakHashMap<K, V> weakHashMap2 = weakHashMap = this.segmentFor(n);
        synchronized (weakHashMap2) {
            if (weakHashMap.containsKey(object) && weakHashMap.get(object).equals(object2)) {
                weakHashMap.remove(object);
                return true;
            }
        }
        return false;
    }

    @Override
    public int size() {
        int n = 0;
        for (int i = 0; i < this.segments.length; ++i) {
            n += this.segments[i].size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object object) {
        WeakHashMap<K, V> weakHashMap;
        int n = ConcurrentWeakHashMap.hash(object);
        WeakHashMap<K, V> weakHashMap2 = weakHashMap = this.segmentFor(n);
        synchronized (weakHashMap2) {
            return weakHashMap.containsKey(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        for (int i = 0; i < this.segments.length; ++i) {
            WeakHashMap<K, V> weakHashMap;
            WeakHashMap<K, V> weakHashMap2 = weakHashMap = this.segments[i];
            synchronized (weakHashMap2) {
                weakHashMap.clear();
                continue;
            }
        }
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new HashIterator();
                }

                @Override
                public int size() {
                    return ConcurrentWeakHashMap.this.size();
                }

                @Override
                public boolean contains(Object object) {
                    return ConcurrentWeakHashMap.this.containsKey(object);
                }

                @Override
                public boolean remove(Object object) {
                    return ConcurrentWeakHashMap.this.remove(object) != null;
                }

                @Override
                public void clear() {
                    ConcurrentWeakHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K k, V v) {
        WeakHashMap<K, V> weakHashMap;
        int n = ConcurrentWeakHashMap.hash(k);
        WeakHashMap<K, V> weakHashMap2 = weakHashMap = this.segmentFor(n);
        synchronized (weakHashMap2) {
            if (!weakHashMap.containsKey(k)) {
                return weakHashMap.put(k, v);
            }
            return weakHashMap.get(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K k, V v, V v2) {
        WeakHashMap<K, V> weakHashMap;
        int n = ConcurrentWeakHashMap.hash(k);
        WeakHashMap<K, V> weakHashMap2 = weakHashMap = this.segmentFor(n);
        synchronized (weakHashMap2) {
            if (weakHashMap.containsKey(k) && weakHashMap.get(k).equals(v)) {
                weakHashMap.put(k, v2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K k, V v) {
        WeakHashMap<K, V> weakHashMap;
        int n = ConcurrentWeakHashMap.hash(k);
        WeakHashMap<K, V> weakHashMap2 = weakHashMap = this.segmentFor(n);
        synchronized (weakHashMap2) {
            if (weakHashMap.containsKey(k)) {
                return weakHashMap.put(k, v);
            }
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return null;
    }

    class HashIterator
    implements Iterator<K> {
        int currSegmentIndex = 0;
        Iterator<K> internal_iter;

        HashIterator() {
            this.internal_iter = ConcurrentWeakHashMap.this.segments[0].keySet().iterator();
        }

        final boolean advance() {
            ++this.currSegmentIndex;
            if (this.currSegmentIndex < ConcurrentWeakHashMap.this.segments.length) {
                this.internal_iter = ConcurrentWeakHashMap.this.segments[this.currSegmentIndex].keySet().iterator();
                return true;
            }
            return false;
        }

        @Override
        public boolean hasNext() {
            if (this.currSegmentIndex >= ConcurrentWeakHashMap.this.segments.length) {
                return false;
            }
            boolean bl = this.internal_iter.hasNext();
            while (!bl && this.advance()) {
                bl = this.internal_iter.hasNext();
            }
            return bl;
        }

        @Override
        public K next() {
            try {
                return this.internal_iter.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                if (this.advance()) {
                    return this.internal_iter.next();
                }
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            ConcurrentWeakHashMap.this.remove(this.next());
        }
    }
}

