/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.DefaultPropertyManager;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.util.SourcedProperties;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class BuiltinPropertyManager
extends DefaultPropertyManager {
    private static final String CLASS = BuiltinPropertyManager.class.getName();
    private static final String[] JavaIDLPropertyNames = new String[]{"com.ibm.CORBA.BootstrapHost", "com.ibm.CORBA.BootstrapPort", "com.ibm.CORBA.InitialReferencesURL", "com.ibm.CORBA.ListenerPort", "com.ibm.CORBA.LocalHost", "org.omg.CORBA.ORBInitialHost", "org.omg.CORBA.ORBInitialPort", "org.omg.CORBA.ORBInitialServices", "com.sun.CORBA.ORBServerPort", "com.sun.CORBA.ORBServerHost", "com.ibm.CORBA.TransportMode", "com.ibm.CORBA.AcceptTimeout", "com.ibm.CORBA.EnableServerKeepAlive", "com.ibm.CORBA.ConnectTimeout", "com.ibm.CORBA.Debug", "com.ibm.CORBA.Debug.Output", "com.ibm.CORBA.CommTrace", "com.ibm.CORBA.CommTraceSplit", "com.ibm.CORBA.HidePropertyValues", "com.ibm.CORBA.CodebaseURLEnabled", "com.ibm.CORBA.RasManager", "com.ibm.CORBA.Debug.Component", "com.ibm.CORBA.ORBCharEncoding", "com.ibm.CORBA.ORBWCharDefault", "com.ibm.CORBA.BufferSize", "com.ibm.CORBA.SendingContextRunTimeSupported", "com.ibm.CORBA.FragmentSize", "com.ibm.CORBA.LargeDataBufferSize", "com.ibm.CORBA.requestRetriesCount", "com.ibm.CORBA.requestRetriesDelay", "com.ibm.CORBA.RequestTimeout", "com.ibm.CORBA.LocateRequestTimeout", "com.ibm.CORBA.FragmentTimeout", "com.ibm.CORBA.GIOPAddressingDisposition", "com.ibm.CORBA.enableClientCallbacks", "com.ibm.CORBA.enableLocateRequest", "com.ibm.CORBA.MaxBufferPoolSize", "com.ibm.CORBA.MaxGIOPMinor", "com.ibm.CORBA.MaxLargeDataBufferPoolSize", "com.ibm.CORBA.ConnectionMultiplicity", "com.ibm.CORBA.MaxOpenConnections", "com.ibm.CORBA.MinOpenConnections", "com.ibm.CORBA.NoLocalInterceptors", "com.ibm.CORBA.ShortExceptionDetails", "com.ibm.CORBA.ServerSocketQueueDepth", "com.ibm.CORBA.DynamicStubs", "com.ibm.CORBA.SendConnectionContexts", "com.ibm.CORBA.SINOClient", "com.ibm.CORBA.ThreadPool.MinimumSize", "com.ibm.CORBA.ThreadPool.MaximumSize", "com.ibm.CORBA.ThreadPool.InactivityTimeout", "com.ibm.CORBA.ThreadPool.IsGrowable", "com.ibm.CORBA.AllowUserInterrupt", "com.ibm.CORBA.UseAlternativeRepIDEncoding", "com.ibm.CORBA.UseHarmonyClassLibrary", "com.ibm.CORBA.UseSchemaIDR", "com.ibm.CORBA.SocketWriteTimeout", "com.ibm.CORBA.AlwaysUseOMG4796", "com.ibm.CORBA.DisableOMG3681", "com.ibm.CORBA.UseOMG4591", "com.ibm.CORBA.UseOMG5689", "com.ibm.CORBA.sendCodeSetContext", "org.omg.CORBA.ORBId", "org.omg.CORBA.ORBListenEndpoints", "org.omg.CORBA.ORBNoProprietaryActivation", "org.omg.CORBA.ORBServerId", "com.ibm.CORBA.ServerId"};
    private static final String[] JavaIDLURLPropertyNames = new String[]{"com.ibm.CORBA.InitialReferencesURL"};
    private static final Set OVERRIDABLE_PROPERTIES = new HashSet<String>(Arrays.asList("com.ibm.CORBA.EnableServerKeepAlive"));
    private List hiddenProperties = new ArrayList();
    final IntParser intParser = new IntParser();

    BuiltinPropertyManager(final ORB oRB) {
        Properties properties = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return oRB.readProperties(BuiltinPropertyManager.this, BuiltinPropertyManager.this.getPropertyNames(), BuiltinPropertyManager.this.getAppletURLPropertyNames());
            }
        });
        this.setInitialProperties(properties);
    }

    @Override
    public String[] getPropertyNames() {
        return JavaIDLPropertyNames;
    }

    @Override
    public String[] getAppletURLPropertyNames() {
        return JavaIDLURLPropertyNames;
    }

    Properties getProperties() {
        return this.props;
    }

    @Override
    protected boolean isOverridable(String string) {
        return OVERRIDABLE_PROPERTIES.contains(string);
    }

    final void addHiddenProperty(String string) {
        this.hiddenProperties.add(string);
    }

    final void traceProperty(String string, String string2, String string3, String string4, String string5) {
        this.traceProperty(string, string2, string3, string4, string5, null);
    }

    final void traceProperty(String string, String string2, String string3) {
        this.traceProperty(string, null, string2, null, string3, "default value");
    }

    final void traceProperty(String string, String string2, String string3, String string4) {
        this.traceProperty(string, null, string2, string3, string4, null);
    }

    final void traceProperty(String string, String string2, String string3, String string4, String string5, String string6) {
        if (Trc.enabled()) {
            this.doTraceProperty(string, string2, string3, string4, string5, string6, false);
        }
    }

    final void tracePropertyError(String string, String string2, String string3, String string4, String string5, String string6) {
        this.doTraceProperty(string, string2, string3, string4, string5, string6, true);
    }

    private void doTraceProperty(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        assert (string != null);
        assert (string3 != null);
        if (this.hiddenProperties != null && this.hiddenProperties.contains(string)) {
            if (string2 == null) {
                string3 = "******";
            } else if (string3.equals(string2)) {
                string3 = "****** (values are equal)";
                string2 = "******";
            } else {
                string3 = "****** (values differ)";
                string2 = "******";
            }
        }
        if (bl || Trc.enabled()) {
            String string7;
            String string8 = string2 == null ? "" : "Requested value='" + string2 + "', ";
            String string9 = "Active value='" + string3 + "'";
            String string10 = string6 == null ? "" : " (" + string6 + ")";
            String string11 = string7 = string4 == null ? "" : ", Source: " + string4;
            if (bl) {
                Trc.ffdc("ERROR: " + string + ": " + string8 + string9 + string10 + string7, "ORB", "Property");
            } else if (Trc.enabled()) {
                Trc.info(Trc.FINE, string, ": ", string8 + string9 + string10 + string7, "ORB", "Property");
            }
        }
    }

    void traceProperties(SourcedProperties sourcedProperties) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> iterator = sourcedProperties.entrySet().iterator();
        stringBuffer.append("{");
        int n = sourcedProperties.size() - 1;
        for (int i = 0; i <= n; ++i) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            if (this.hiddenProperties != null && this.hiddenProperties.contains(string)) {
                stringBuffer.append(string + "=" + "************");
            } else {
                stringBuffer.append(string + "=" + entry.getValue());
            }
            stringBuffer.append(" - Source: " + sourcedProperties.getSource(string));
            if (i >= n) continue;
            stringBuffer.append(",\n");
        }
        stringBuffer.append("}");
        if (Trc.enabled()) {
            Trc.info(Trc.FINE, stringBuffer.toString(), CLASS, "traceProperties:427");
        }
        stringBuffer.toString();
    }

    static void setSourcedProperty(Properties properties, String string, String string2, String string3) {
        if (properties instanceof SourcedProperties) {
            SourcedProperties sourcedProperties = (SourcedProperties)properties;
            sourcedProperties.setProperty(string, string2, string3);
        } else {
            properties.setProperty(string, string2);
        }
    }

    static String getLatestSource(Properties properties) {
        if (properties instanceof SourcedProperties) {
            return ((SourcedProperties)properties).getLatestSource();
        }
        return "[unknown]";
    }

    class IntParser {
        private final BuiltinPropertyManager bpm;

        IntParser() {
            this.bpm = BuiltinPropertyManager.this;
        }

        public boolean divides(int n, int n2) {
            return n2 == this.largestMultipleAtMost(n2, n);
        }

        public int largestMultipleAtMost(int n, int n2) {
            return n2 * (n / n2);
        }

        public int smallestMultipleAtLeast(int n, int n2) {
            return n2 * ((n + (n2 - 1)) / n2);
        }

        public int valueOf(SourcedProperties sourcedProperties, String string, int n, String string2) {
            return this.boundedMultipleValueOf(sourcedProperties, string, 0, Integer.MAX_VALUE, n, 1, string2, false);
        }

        public int valueOf(SourcedProperties sourcedProperties, String string, int n, String string2, String string3) {
            return this.boundedMultipleValueOf(sourcedProperties, string, 0, Integer.MAX_VALUE, n, 1, string2, string3, false);
        }

        public int multipleValueOf(SourcedProperties sourcedProperties, String string, int n, int n2, String string2, boolean bl) {
            return this.boundedMultipleValueOf(sourcedProperties, string, 0, Integer.MAX_VALUE, n, n2, string2, bl);
        }

        public int multipleValueOf(SourcedProperties sourcedProperties, String string, int n, int n2, String string2, String string3, boolean bl) {
            return this.boundedMultipleValueOf(sourcedProperties, string, 0, Integer.MAX_VALUE, n, n2, string2, string3, bl);
        }

        public int boundedValueOf(SourcedProperties sourcedProperties, String string, int n, int n2, int n3, String string2, boolean bl) {
            return this.boundedMultipleValueOf(sourcedProperties, string, n, n2, n3, 1, string2, bl);
        }

        public int boundedValueOf(SourcedProperties sourcedProperties, String string, int n, int n2, int n3, String string2, String string3, boolean bl) {
            return this.boundedMultipleValueOf(sourcedProperties, string, n, n2, n3, 1, string2, string3, bl);
        }

        public int boundedMultipleValueOf(SourcedProperties sourcedProperties, String string, int n, int n2, int n3, int n4, String string2, boolean bl) {
            return this.boundedMultipleValueOf(sourcedProperties, string, n, n2, n3, n4, "", string2, bl);
        }

        public int boundedMultipleValueOf(SourcedProperties sourcedProperties, String string, int n, int n2, int n3, int n4, String string2, String string3, boolean bl) {
            n = this.smallestMultipleAtLeast(n, n4);
            n2 = this.largestMultipleAtMost(n2, n4);
            n3 = Math.min(n2, Math.max(n, this.largestMultipleAtMost(n3, n4)));
            String string4 = sourcedProperties.getProperty(string);
            String string5 = sourcedProperties.getSource(string);
            int n5 = n3;
            if (string4 != null && string4.length() > 0) {
                try {
                    int n6 = Integer.parseInt(string4);
                    n5 = this.largestMultipleAtMost(n6, n4);
                    String string6 = null;
                    if (n5 < n) {
                        n5 = bl ? n3 : n;
                        string6 = bl ? "less than minimum - set to default value" : "increased to min permitted value";
                    } else if (n5 > n2) {
                        n5 = bl ? n3 : n2;
                        string6 = bl ? "exceeded maximum - set to default value" : "reduced to max permitted value";
                    } else if (n6 != n5) {
                        string6 = "rounded down to multiple of " + n4;
                    }
                    String string7 = Integer.toString(n5) + string2;
                    this.bpm.traceProperty(string, string4, string7, string5, string3, string6);
                }
                catch (NumberFormatException numberFormatException) {
                    BuiltinPropertyManager.this.tracePropertyError(string, string4, Integer.toString(n3), string5, "parseIntProperty:733", "this property requires an int value");
                }
            } else {
                this.bpm.traceProperty(string, Integer.toString(n5), string3);
            }
            return n5;
        }
    }
}

