/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.DynamicStub;
import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jvm.packed.PackedObject;
import com.ibm.rmi.corba.DisconnectedDelegate;
import com.ibm.rmi.corba.TypeCodeImpl;
import com.ibm.rmi.iiop.DataValueWriter;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ValueHandlerPool;
import com.ibm.rmi.io.ValueUtility;
import com.ibm.rmi.util.IdentityHashtable;
import com.ibm.rmi.util.PackedObjectSupportCheck;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.RepositoryId;
import com.ibm.rmi.util.Utility;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DataOutputStream;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

public abstract class CDRWriter
extends DataValueWriter {
    private static final String CLASS = CDRWriter.class.getName();
    protected boolean startNewChunk;
    protected boolean writingChunkMarker;
    IdentityHashtable valueCache = null;
    Hashtable repositoryIdCache = null;
    private static final long serialVersionUID = 0L;

    public CDRWriter(org.omg.CORBA.ORB oRB, boolean bl, int n, EncoderOutputStream encoderOutputStream) {
        super(oRB, bl, n, encoderOutputStream);
    }

    public CDRWriter(EncoderOutputStream encoderOutputStream) {
        super(encoderOutputStream);
    }

    public CDRWriter(EncoderOutputStream encoderOutputStream, EncoderOutputStream encoderOutputStream2) {
        this(encoderOutputStream.orb(), encoderOutputStream.littleEndian(), 0, encoderOutputStream2);
        this.typeMap = encoderOutputStream.getTypeMap();
        encoderOutputStream.alignAndReserve(4, 4);
        this.initialOffset = encoderOutputStream.get_offset(true) + 4;
        this.setGIOPVersion(encoderOutputStream.getGIOPMajor(), encoderOutputStream.getGIOPMinor(), false);
    }

    public CDRWriter(org.omg.CORBA.ORB oRB, byte by, byte by2, EncoderOutputStream encoderOutputStream) {
        super(oRB, by, by2, encoderOutputStream);
    }

    public CDRWriter(org.omg.CORBA.ORB oRB, int n, int n2, EncoderOutputStream encoderOutputStream) {
        super(oRB, n, n2, encoderOutputStream);
    }

    @Override
    protected void checkPadding() {
        if (this.paddingPending) {
            this.paddingPending = false;
            this.align(8);
            this.encoderStream.recordBodyPosition();
        }
    }

    @Override
    protected abstract void pad(int var1);

    @Override
    protected abstract void align(int var1);

    @Override
    protected abstract int alignAndReserve(int var1, int var2);

    @Override
    protected final void completeFragment(int n) {
        if (this.inBlock && !this.startNewChunk && !this.writingChunkMarker) {
            this.end_block(n, true);
            this.encoderStream.sendFragment();
            this.startNewChunk = true;
        } else {
            this.encoderStream.sendFragment();
            if (this.writingChunkMarker) {
                this.align(4);
                this.rememberBlockSizePosition();
            }
        }
        this.clearEndFlagMarker();
    }

    @Override
    boolean getStartNewChunk() {
        return this.startNewChunk;
    }

    @Override
    void setStartNewChunk(boolean bl) {
        this.startNewChunk = bl;
    }

    @Override
    protected abstract void rememberBlockSizePosition();

    @Override
    protected abstract void forgetBlockSizePosition();

    @Override
    protected abstract void writeBlockSizeHere(int var1);

    @Override
    protected abstract void clearEndFlagMarker();

    @Override
    protected abstract void allocateBuffer();

    @Override
    protected final void checkChunkStart() {
        if (this.startNewChunk) {
            this.writingChunkMarker = true;
            this.startNewChunk = false;
            this.writeBlockSizeHere(0);
            this.writingChunkMarker = false;
            this.inBlock = true;
        }
    }

    public abstract void write_octet(byte var1);

    public void write_boolean(boolean bl) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(1, 1);
        this.writeBoolean(bl);
    }

    public void write_short(short s) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(2, 2);
        this.writeShort(s, this.littleEndian);
    }

    public void write_ushort(short s) {
        this.encoderStream.write_short(s);
    }

    public void write_longlong(long l) {
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(8, 8);
        this.writeLongLong(l, this.littleEndian);
    }

    public void write_ulonglong(long l) {
        this.encoderStream.write_longlong(l);
    }

    public void write_float(float f) {
        this.encoderStream.write_long(Float.floatToIntBits(f));
    }

    public void write_double(double d) {
        this.encoderStream.write_longlong(Double.doubleToLongBits(d));
    }

    @Override
    public void write_Principal(Principal principal) {
        this.encoderStream.write_long(principal.name().length);
        this.encoderStream.write_octet_array(principal.name(), 0, principal.name().length);
    }

    public void write_any(Any any) {
        if (any == null) {
            throw new BAD_PARAM("Null Param (5) - any", 1229124101, CompletionStatus.COMPLETED_MAYBE);
        }
        this.encoderStream.write_TypeCode(any.type());
        any.write_value((OutputStream)this.encoderStream);
    }

    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw new BAD_PARAM("Null Param (6) - TypeCode", 1229124102, CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl(this.orb, typeCode);
        typeCodeImpl.write_value(this.encoderStream);
    }

    @Override
    public void writeAnyOpt(java.lang.Object object) {
        int n;
        boolean bl = this.isOptimisedTCVersion();
        if (object instanceof String) {
            this.writeStringAnyOpt((String)object, bl);
            return;
        }
        if (object == null) {
            this.writeNullAnyOpt(bl);
            return;
        }
        java.lang.Object object2 = Utility.autoConnect(object, this.orb, false);
        TypeCodeImpl typeCodeImpl = (TypeCodeImpl)ValueUtility.getTypeCode(this.orb, object2, (PartnerVersion)this);
        if (bl) {
            n = this.getTypePosition(typeCodeImpl);
            if (n != -1) {
                this.writeIndirection(n);
            } else {
                typeCodeImpl.write_value(this.encoderStream);
            }
        } else {
            typeCodeImpl.write_value(this.encoderStream);
        }
        n = typeCodeImpl.kind().value();
        if (n == 29) {
            this.encoderStream.write_value((Serializable)object2);
        } else if (n == 30) {
            this.encoderStream.write_value((Serializable)object2);
        } else if (n == 14) {
            this.encoderStream.write_Object((Object)object2);
        } else if (n == 32) {
            this.encoderStream.write_abstract_interface(object2);
        } else {
            throw new BAD_PARAM("Unexpected type for any", 1229125805, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    public final java.lang.Object fast_writeAnyOpt(java.lang.Object object) {
        int n;
        boolean bl = this.isOptimisedTCVersion();
        if (object == null) {
            this.writeNullAnyOpt(bl);
            return object;
        }
        if (this.isCollocated && this.crossReferencePointer != -1) {
            this.encoderStream.write_long(-16);
            this.encoderStream.write_long(this.crossReferencePointer);
            this.crossReferencePointer = -1;
            this.isCollocated = false;
            return object;
        }
        if (object instanceof String) {
            this.writeStringAnyOpt((String)object, bl);
            return object;
        }
        java.lang.Object object2 = Utility.autoConnect(object, this.orb, false);
        TypeCodeImpl typeCodeImpl = (TypeCodeImpl)ValueUtility.getTypeCode(this.orb, object2, (PartnerVersion)this);
        if (bl) {
            n = this.getTypePosition(typeCodeImpl);
            if (n != -1) {
                this.writeIndirection(n);
            } else {
                typeCodeImpl.write_value(this.encoderStream);
            }
        } else {
            typeCodeImpl.write_value(this.encoderStream);
        }
        n = typeCodeImpl.kind().value();
        if (n == 29) {
            return this.fastWriteVal((Serializable)object2);
        }
        if (n == 30) {
            return this.fastWriteVal((Serializable)object2);
        }
        if (n == 14) {
            this.encoderStream.write_Object((Object)object2);
            return object2;
        }
        if (n == 32) {
            return this.fast_write_abstract_interface(object2);
        }
        throw new BAD_PARAM("Unexpected type for any", 1229125811, CompletionStatus.COMPLETED_NO);
    }

    private final void writeStringAnyOpt(String string, boolean bl) {
        if (this.firstStringTc == -1 || !bl) {
            this.firstStringTc = BOX_STRING_TC.writeValueOpt(this.encoderStream);
        } else {
            this.writeIndirection(this.firstStringTc);
        }
        this.encoderStream.write_value((Serializable)((java.lang.Object)string));
    }

    private final void writeNullAnyOpt(boolean bl) {
        if (this.firstNullTc == -1 || !bl) {
            if (this.useOldNullTC()) {
                this.firstNullTc = TypeCodeImpl.get_primitive_tc(TCKind.tk_value).writeValueOpt(this.encoderStream);
                this.encoderStream.write_value(null);
            } else {
                this.firstNullTc = ABSTRACT_INTERFACE_TC.writeValueOpt(this.encoderStream);
                this.encoderStream.write_abstract_interface(null);
            }
        } else {
            this.writeIndirection(this.firstNullTc);
            this.encoderStream.write_abstract_interface(null);
        }
    }

    @Override
    public final void writeIndirection(int n) {
        this.checkPadding();
        this.checkChunkStart();
        this.addIndirectionBytes = 4;
        this.alignAndReserve(4, 4);
        this.writeLong(-1, this.littleEndian);
        this.addIndirectionBytes = 0;
        this.alignAndReserve(4, 4);
        this.writeLong(n - this.get_offset(), this.littleEndian);
    }

    @Override
    public void write_abstract_interface(java.lang.Object object) {
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "write_abstract_interface:614");
        }
        if (this.fast_write_abstract_interface_as_Object(object)) {
            if (Trc.enabled(2)) {
                Trc.complete(Trc.FINEST, object == null ? null : object.getClass().getName(), CLASS, "write_abstract_interface:618");
            }
            return;
        }
        try {
            this.encoderStream.write_value((Serializable)object);
        }
        catch (ClassCastException classCastException) {
            Trc.ffdc(classCastException, CLASS, "write_abstract_interface:624");
            if (object instanceof Serializable) {
                throw classCastException;
            }
            Utility.throwNotSerializableForCorba(object.getClass().getName());
        }
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, object == null ? null : object.getClass().getName(), CLASS, "write_abstract_interface:635");
        }
    }

    private final boolean fast_write_abstract_interface_as_Object(java.lang.Object object) {
        if (object != null && object instanceof Object) {
            if (object instanceof DynamicStub) {
                object = ((DynamicStub)object).getStub();
            }
            ObjectImpl objectImpl = (ObjectImpl)object;
            try {
                Delegate delegate = objectImpl._get_delegate();
                if (!(delegate instanceof DisconnectedDelegate)) {
                    this.encoderStream.write_boolean(true);
                    this.encoderStream.write_Object((Object)objectImpl);
                    return true;
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                // empty catch block
            }
        }
        this.encoderStream.write_boolean(false);
        return false;
    }

    @Override
    public final java.lang.Object fast_write_abstract_interface(java.lang.Object object) {
        if (this.fast_write_abstract_interface_as_Object(object)) {
            return object;
        }
        return this.fastWriteVal((Serializable)object);
    }

    @Override
    public void write_value(Serializable serializable, Class clazz) {
        this.encoderStream.write_value(serializable);
    }

    @Override
    public final void write_value(Serializable serializable, String string) {
        boolean bl = false;
        java.lang.Object object = this.fastWriteVal(serializable, string);
        if (object != EncoderOutputStream.PENDING_WRITE) {
            return;
        }
        try {
            if (this.valueHandler == null) {
                bl = true;
                this.valueHandler = ValueHandlerPool.getValueHandler();
            }
            boolean bl2 = this.prevMustChunk;
            this.valueHandler.writeValue((OutputStream)this.encoderStream, (Serializable)this.currentObject, this.streamFormatVersion);
            this.postFastWriteVal(bl2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Trc.ffdc("Caught OOM: " + outOfMemoryError, CLASS, "write_value:706");
            throw new NO_MEMORY("Unable to write value : " + outOfMemoryError.getMessage(), 1229126020, CompletionStatus.COMPLETED_NO);
        }
        finally {
            if (bl) {
                ValueHandlerPool.returnValueHandler(this.valueHandler);
                this.valueHandler = null;
            }
        }
    }

    @Override
    public void write_value(Serializable serializable) {
        this.write_value(serializable, (String)null);
    }

    @Override
    public final void postFastWriteVal(boolean bl) {
        if (this.mustChunk) {
            this.end_block();
            this.writeEndTag(true);
        } else {
            this.writeEndTag(false);
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    @Override
    public final java.lang.Object fastWriteVal(Serializable serializable) {
        return this.fastWriteVal(serializable, null);
    }

    private final java.lang.Object fastWriteValInternal(Serializable serializable, String string) {
        if (serializable == null) {
            this.encoderStream.write_long(0);
            return serializable;
        }
        Integer n = null;
        if (this.valueCache != null && (n = (Integer)this.valueCache.get(serializable)) != null) {
            int n2 = n;
            this.writeIndirection(n2);
            return serializable;
        }
        if (this.isCollocated && this.crossReferencePointer != -1) {
            this.encoderStream.write_long(-16);
            this.encoderStream.write_long(this.crossReferencePointer);
            this.crossReferencePointer = -1;
            this.isCollocated = false;
            return serializable;
        }
        boolean bl = this.mustChunk;
        if (this.inBlock) {
            this.end_block();
        }
        if (serializable instanceof String) {
            this.writeString((String)((java.lang.Object)serializable));
        } else if (serializable instanceof Class) {
            if (string == null) {
                this.writeClass(RepositoryId.kClassDescValueRepID, (Class)serializable);
            } else {
                this.writeClass(string, (Class)serializable);
            }
        } else if (serializable instanceof ValueBase) {
            Class<?> clazz = serializable.getClass();
            this.writeValueBase((ValueBase)serializable, clazz);
        } else if (serializable instanceof IDLEntity) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else {
            return EncoderOutputStream.PENDING_WRITE;
        }
        this.postFastWriteVal(bl);
        return serializable;
    }

    public final java.lang.Object fastWriteVal(Serializable serializable, String string) {
        java.lang.Object object;
        java.lang.Object object2 = this.fastWriteValInternal(serializable = writeValueTransformer.transformValue(serializable, this.getPartnerMajor()), string);
        if (object2 != EncoderOutputStream.PENDING_WRITE) {
            return object2;
        }
        this.prevMustChunk = this.mustChunk;
        boolean bl = this.mustChunk;
        Class<?> clazz = serializable.getClass();
        if (PackedObjectSupportCheck.isPackedObject(clazz)) {
            boolean bl2 = PackedObject.isMixedPacked(clazz);
            int n = this.writeValueTag(false, false, clazz);
            this.updateIndirectionTable(n, serializable, serializable);
            if (bl2) {
                this.writeRepositoryId("MPO:2.0");
                this.write_wstring(clazz.getName());
            } else {
                this.writeRepositoryId("SPO:2.0");
            }
            this.currentObject = serializable;
            return EncoderOutputStream.PENDING_WRITE;
        }
        if (clazz.isArray()) {
            String string2 = RepositoryId.createSequenceRepID(clazz, this.getOldSUID(), this.getPartnerMajor(), this.getPartnerMinor());
            if (this.mustChunk) {
                int n = this.writeValueTag(true, false, clazz);
                this.updateIndirectionTable(n, serializable, serializable);
                this.writeRepositoryId(string2);
                this.start_block();
                --this.end_flag;
            } else {
                int n = this.writeValueTag(false, false, clazz);
                this.updateIndirectionTable(n, serializable, serializable);
                this.writeRepositoryId(string2);
                if (this.useOldNestingDepths()) {
                    --this.end_flag;
                }
            }
            this.currentObject = serializable;
            return EncoderOutputStream.PENDING_WRITE;
        }
        Serializable serializable2 = serializable;
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz, this.getPartnerMajor(), this.getPartnerMinor());
        serializable = objectStreamClass.writeReplace(serializable2);
        if (serializable != serializable2) {
            if (serializable == null) {
                this.encoderStream.write_long(0);
                return serializable;
            }
            object = clazz;
            clazz = serializable.getClass();
            if (clazz != object) {
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, object, clazz, CLASS, "fastWriteVal:889");
                }
                objectStreamClass = ObjectStreamClass.lookup(clazz, this.getPartnerMajor(), this.getPartnerMinor());
            }
            if ((object2 = this.fastWriteValInternal(serializable, string)) != EncoderOutputStream.PENDING_WRITE) {
                return object2;
            }
        }
        if (objectStreamClass.isCustomIDL()) {
            this.mustChunk = true;
        }
        object = RepositoryId.createForJavaType(clazz, this.getOldSUID(), this.getPartnerMajor(), this.getPartnerMinor());
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, clazz);
            this.updateIndirectionTable(n, serializable, serializable2);
            this.writeRepositoryId((String)object);
            --this.end_flag;
            this.start_block();
        } else {
            int n = this.writeValueTag(false, false, clazz);
            this.updateIndirectionTable(n, serializable, serializable2);
            this.writeRepositoryId((String)object);
            if (this.useOldNestingDepths()) {
                --this.end_flag;
            }
        }
        this.currentObject = serializable;
        return EncoderOutputStream.PENDING_WRITE;
    }

    @Override
    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        try {
            if (serializable == null) {
                this.encoderStream.write_long(0);
                return;
            }
            if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                int n = (Integer)this.valueCache.get(serializable);
                this.writeIndirection(n);
                return;
            }
            boolean bl = this.mustChunk;
            if (this.mustChunk) {
                if (this.inBlock) {
                    this.end_block();
                }
                int n = this.writeValueTag(true, false, serializable.getClass());
                this.writeRepositoryId(boxedValueHelper.get_id());
                this.updateIndirectionTable(n, serializable, serializable);
                this.start_block();
                --this.end_flag;
            } else {
                int n = this.writeValueTag(false, false, serializable.getClass());
                this.writeRepositoryId(boxedValueHelper.get_id());
                this.updateIndirectionTable(n, serializable, serializable);
                if (this.useOldNestingDepths()) {
                    --this.end_flag;
                }
            }
            boxedValueHelper.write_value((OutputStream)this.encoderStream, serializable);
            this.postFastWriteVal(bl);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Trc.ffdc("Caught OOM: " + outOfMemoryError, CLASS, "write_value(Serializable,BoxedValueHelper):964");
            throw new NO_MEMORY("Unable to write value : " + outOfMemoryError.getMessage(), 1229126021, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    public final void start_block() {
        this.checkPadding();
        this.align(4);
        this.rememberBlockSizePosition();
        this.startNewChunk = true;
        this.inBlock = true;
    }

    private final void end_block() {
        this.end_block(0, false);
    }

    private final void end_block(int n, boolean bl) {
        if (!this.inBlock) {
            return;
        }
        if (!bl) {
            this.inBlock = false;
            if (this.startNewChunk) {
                this.forgetBlockSizePosition();
                this.startNewChunk = false;
                return;
            }
        }
        this.startNewChunk = false;
        this.rewriteBlockSize(n, this.addIndirectionBytes);
        this.forgetBlockSizePosition();
    }

    protected abstract void rewriteBlockSize(int var1, int var2);

    public final void start_value(String string) {
        this.end_block();
        this.mustChunk = true;
        this.writeValueTag(true, false, null);
        this.writeRepositoryId(string);
        this.start_block();
        --this.end_flag;
    }

    public final void end_value() {
        this.end_block();
        this.writeEndTag(true);
        this.start_block();
    }

    public void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw new BAD_PARAM("Null Param (7) - boolean array", 1229124103, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(1, n2 - n3);
                for (int i = 0; i < n4; ++i) {
                    this.writeBoolean(blArray[n + n3]);
                    ++n3;
                }
            }
        }
    }

    public void write_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new BAD_PARAM("Null Param (10) - short_array", 1229124106, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(2, (n2 - n3) * 2);
                for (int i = 0; i < n4; ++i) {
                    this.writeShort(sArray[n + n3], this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    public void write_ushort_array(short[] sArray, int n, int n2) {
        this.encoderStream.write_short_array(sArray, n, n2);
    }

    public void write_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new BAD_PARAM("Null Param (11) - ushort_array", 1229124107, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(4, (n2 - n3) * 4);
                for (int i = 0; i < n4; ++i) {
                    this.writeLong(nArray[n + n3], this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    public void write_ulong_array(int[] nArray, int n, int n2) {
        this.encoderStream.write_long_array(nArray, n, n2);
    }

    public void write_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new BAD_PARAM("Null Param (12) - ulong_array", 1229124108, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.alignAndReserve(8, (n2 - n3) * 8);
                for (int i = 0; i < n4; ++i) {
                    this.writeLongLong(lArray[n + n3], this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    public void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.encoderStream.write_longlong_array(lArray, n, n2);
    }

    public void write_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new BAD_PARAM("Null Param (13) - ulonglong_array", 1229124109, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                n4 = this.alignAndReserve(4, (n2 - n3) * 4);
                for (int i = 0; i < n4; ++i) {
                    int n5 = Float.floatToIntBits(fArray[n + n3]);
                    this.writeLong(n5, this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    public void write_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new BAD_PARAM("Null Param (14) - double_array", 1229124110, CompletionStatus.COMPLETED_MAYBE);
        }
        if (n2 > 0) {
            this.checkPadding();
            this.checkChunkStart();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                n4 = this.alignAndReserve(8, (n2 - n3) * 8);
                for (int i = 0; i < n4; ++i) {
                    long l = Double.doubleToLongBits(dArray[n + n3]);
                    this.writeLongLong(l, this.littleEndian);
                    ++n3;
                }
            }
        }
    }

    @Override
    public final void write_string_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw new BAD_PARAM("Null Param (15) - string_array", 1229124111, CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i = 0; i < n2; ++i) {
            this.encoderStream.write_string(stringArray[i + n]);
        }
    }

    public final void write_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.encoderStream.write_any(anyArray[i + n]);
        }
    }

    @Override
    public final void reset() {
        boolean bl = this.resetBufferData();
        if (bl) {
            this.end_flag = 0;
        }
    }

    protected abstract boolean resetBufferData();

    private final void updateValueCache(int n, java.lang.Object object) {
        if (!(object instanceof StackTraceElement[]) && !(object instanceof StackTraceElement) || !PartnerVersionUtil.needOldThrowable(this.getPartnerMajor(), this.getPartnerMinor())) {
            this.valueCache.put(object, (java.lang.Object)n);
        }
    }

    private final void updateIndirectionTable(int n, java.lang.Object object, java.lang.Object object2) {
        if (this.valueCache == null) {
            this.valueCache = new IdentityHashtable();
        }
        this.updateValueCache(n, object);
        if (object2 != object) {
            this.updateValueCache(n, object2);
        }
        if (this.isCollocated) {
            this.setSerializedFieldsInfo(n, object);
        }
    }

    private final void writeRepositoryId(String string) {
        int n;
        boolean bl = this.interop.useAlternativeRepIDEncoding.inUse();
        if (bl) {
            string = RepositoryId.unescape(string);
        }
        if (this.repositoryIdCache != null && this.repositoryIdCache.containsKey(string)) {
            int n2 = (Integer)this.repositoryIdCache.get(string);
            this.writeIndirection(n2);
            return;
        }
        byte[] byArray = null;
        if (!bl) {
            byArray = RepositoryId.getByteArray(string);
            if (byArray == null) {
                n = string.length() + 1;
                byArray = new byte[n];
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] > '\u00ff') {
                        throw new INTERNAL("Tried to marshal a Repository ID containing characters that are not part of the ISO Latin-1 character set. Repository ID=" + string, 1229125061, CompletionStatus.COMPLETED_NO);
                    }
                    byArray[i] = (byte)cArray[i];
                }
                byArray[n - 1] = 0;
                RepositoryId.setByteArray(string, byArray);
            }
        } else {
            byArray = this.convertStringToTcsBytes(string);
        }
        n = byArray.length;
        this.checkPadding();
        this.checkChunkStart();
        this.alignAndReserve(4, 4 + n);
        this.writeLong(n, this.littleEndian);
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new Hashtable();
        }
        this.repositoryIdCache.put(string, this.get_offset() - 4);
        this.write_octet_array(byArray, 0, n, false);
    }

    protected abstract byte[] convertStringToTcsBytes(String var1);

    private final void write_codebase(String string, int n) {
        if (this.codebaseCache != null && this.codebaseCache.containsKey(string)) {
            int n2 = (Integer)this.codebaseCache.get(string);
            this.writeIndirection(n2);
        } else {
            this.encoderStream.write_string(string);
            if (this.codebaseCache == null) {
                this.codebaseCache = new Hashtable();
            }
            this.codebaseCache.put(string, n);
        }
    }

    private final int writeValueTag(boolean bl, boolean bl2, Class clazz) {
        int n = 0;
        int n2 = 0;
        String string = null;
        if (clazz != null && (!(this.orb instanceof ORB) || ((ORB)this.orb).getCodebaseURLEnabled())) {
            string = Util.getCodebase((Class)clazz);
        }
        if (bl && bl2) {
            if (string == null) {
                n2 = RepositoryId.kPreComputed_StandardRMIChunked_NoRep;
                this.encoderStream.write_long(n2);
                n = this.get_offset(true) - 4;
            } else {
                n2 = RepositoryId.kPreComputed_CodeBaseRMIChunked_NoRep;
                this.encoderStream.write_long(n2);
                n = this.get_offset(true) - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (bl && !bl2) {
            if (string == null) {
                n2 = RepositoryId.kPreComputed_StandardRMIChunked;
                this.encoderStream.write_long(n2);
                n = this.get_offset(true) - 4;
            } else {
                n2 = RepositoryId.kPreComputed_CodeBaseRMIChunked;
                this.encoderStream.write_long(n2);
                n = this.get_offset(true) - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (string == null) {
            n2 = RepositoryId.kPreComputed_StandardRMIUnchunked;
            this.encoderStream.write_long(n2);
            n = this.get_offset(true) - 4;
        } else {
            n2 = RepositoryId.kPreComputed_CodeBaseRMIUnchunked;
            this.encoderStream.write_long(n2);
            n = this.get_offset(true) - 4;
            this.write_codebase(string, this.get_offset());
        }
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "write value tag ", Trc.hex(n2), " index_hex ", Trc.hex(n), CLASS, "writeValueTag:1384");
        }
        return n;
    }

    private void writeIDLEntity(IDLEntity iDLEntity) {
        this.mustChunk = true;
        Class<?> clazz = iDLEntity.getClass();
        String string = RepositoryId.createForJavaType(clazz, false, this.getPartnerMajor(), this.getPartnerMinor());
        String string2 = Util.getCodebase(clazz);
        int n = this.writeValueTag(true, false, clazz);
        this.updateIndirectionTable(n, iDLEntity, iDLEntity);
        this.writeRepositoryId(string);
        --this.end_flag;
        this.start_block();
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string2, classLoader, clazz, classLoader);
            final Class[] classArray = new Class[]{OutputStream.class, clazz};
            Method method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws NoSuchMethodException {
                    return clazz2.getMethod("write", classArray);
                }
            });
            java.lang.Object[] objectArray = new java.lang.Object[]{this.encoderStream, iDLEntity};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trc.ffdc(classNotFoundException, CLASS, "writeIDLEntity:1431");
            MARSHAL mARSHAL = new MARSHAL("ClassNotFoundException: " + classNotFoundException.getMessage(), 1229125798, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)classNotFoundException);
            throw mARSHAL;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            Trc.ffdc(exception, CLASS, "writeIDLEntity:1439");
            MARSHAL mARSHAL = new MARSHAL("PrivilegedActionException:" + exception.getMessage(), 1229125799, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)exception);
            throw mARSHAL;
        }
        catch (IllegalAccessException illegalAccessException) {
            Trc.ffdc(illegalAccessException, CLASS, "writeIDLEntity:1446");
            MARSHAL mARSHAL = new MARSHAL("IllegalAccessException :" + illegalAccessException.getMessage(), 1229125800, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause((Throwable)illegalAccessException);
            throw mARSHAL;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof BAD_PARAM) {
                Trc.ffdc((Exception)throwable, CLASS, "writeIDLEntity:1455");
                throw (BAD_PARAM)throwable;
            }
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            if (throwable instanceof Exception) {
                Trc.ffdc((Exception)throwable, CLASS, "writeIDLEntity:1461");
            }
            Trc.ffdc(throwable + ":" + throwable.getMessage(), CLASS, "writeIDLEntity:1463");
            MARSHAL mARSHAL = new MARSHAL("InvocationTargetException:" + throwable.getMessage(), 1229125801, CompletionStatus.COMPLETED_NO);
            mARSHAL.initCause(throwable);
            throw mARSHAL;
        }
    }

    private void writeIDLValue(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._write((OutputStream)this.encoderStream);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).marshal((DataOutputStream)this.encoderStream);
        } else {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(serializable.getClass(), null, string);
            boxedValueHelper.write_value((OutputStream)this.encoderStream, serializable);
        }
    }

    protected abstract void writeEndTag(int var1);

    private void writeEndTag(boolean bl) {
        if (bl) {
            this.writeEndTag(this.end_flag);
            if (!this.useOldNestingDepths()) {
                ++this.end_flag;
            }
        }
        if (this.useOldNestingDepths()) {
            ++this.end_flag;
        }
    }

    private void writeClass(String string, Class clazz) {
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.writeRepositoryId(string);
            } else {
                this.writeRepositoryId(RepositoryId.kClassDescValueRepID);
            }
            this.start_block();
            --this.end_flag;
            Utility.writeClassValue(this.encoderStream, clazz);
        } else {
            int n = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n, clazz, clazz);
            if (string != null) {
                this.writeRepositoryId(string);
            } else {
                this.writeRepositoryId(RepositoryId.kClassDescValueRepID);
            }
            if (this.useOldNestingDepths()) {
                --this.end_flag;
            }
            Utility.writeClassValue(this.encoderStream, clazz);
        }
    }

    private void writeString(String string) {
        if (this.mustChunk) {
            int n = this.writeValueTag(true, false, null);
            this.updateIndirectionTable(n, string, string);
            this.writeRepositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
            this.start_block();
            --this.end_flag;
            this.encoderStream.write_wstring(string);
        } else {
            int n = this.writeValueTag(false, false, null);
            this.updateIndirectionTable(n, string, string);
            this.writeRepositoryId("IDL:omg.org/CORBA/WStringValue:1.0");
            if (this.useOldNestingDepths()) {
                --this.end_flag;
            }
            this.encoderStream.write_wstring(string);
        }
    }

    private void writeValueBase(ValueBase valueBase, Class clazz) {
        this.mustChunk = true;
        int n = this.writeValueTag(true, false, clazz);
        this.updateIndirectionTable(n, valueBase, valueBase);
        String string = valueBase._truncatable_ids()[0];
        this.writeRepositoryId(string);
        this.start_block();
        --this.end_flag;
        this.writeIDLValue((Serializable)valueBase, string);
    }

    public void write_Abstract(java.lang.Object object) {
        this.encoderStream.write_abstract_interface(object);
    }

    public void write_Value(Serializable serializable) {
        this.encoderStream.write_value(serializable);
    }

    @Override
    public void close() {
        this.typeMap = null;
        this.currentObject = null;
        if (this.valueCache != null) {
            this.valueCache.clear();
            this.valueCache = null;
        }
        if (this.valueHandler != null) {
            this.valueHandler.reset();
            this.valueHandler = null;
        }
        this.serializedFieldsInfo.clear();
        this.serializedFieldsInfo = null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(this.getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:1623");
        throw notSerializableException;
    }

    @Override
    public void writeSpecialPadding(int n) {
        for (int i = 0; i < n; ++i) {
            this.writeBoolean(false);
        }
    }
}

