/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.giop.GIOPWriteCompletedCallback;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.CORBA.iiop.ServiceContextList;
import com.ibm.CORBA.nio.Sink;
import com.ibm.CORBA.nio.StreamFactory;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.nio.ByteBufferUtils;
import com.ibm.jtc.orb.nio.EncoderInputHandler;
import com.ibm.jtc.orb.nio.EncoderOutputHandler;
import com.ibm.rmi.channel.giop.MessageWriter;
import com.ibm.rmi.iiop.GIOPVersionException;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;

public class GIOPMessageContextBase
extends OutputStream
implements GIOPMessageContext,
TCPWriteCompletedCallback,
GIOPWriteCompletedCallback,
Sink,
Externalizable {
    private static final String CLASS = GIOPMessageContextBase.class.getName();
    private static final WsByteBufferPoolManager bBPoolManager = WsByteBufferPoolManagerImpl.getRef();
    private GIOPWriteCompletedCallback appWriteCallback;
    private Message msg;
    private int msgSize;
    private WsByteBuffer[] headerBuffers;
    private int headerSize = 0;
    private WsByteBuffer[] bodyBuffers;
    private int bodySize = 0;
    private boolean completedBody = false;
    protected IOR initialIOR;
    protected IOR targetIOR;
    protected IOR currentIOR;
    protected ObjectKey targetObjectKey;
    protected ObjectKey initialObjectKey;
    protected ServiceContext[] serviceContexts;
    private GIOPMessageContextBase headerFragmentContext;
    private GIOPMessageContextBase bodyFragmentContext;
    private MessageWriter appWriteContext;
    private boolean appForceQueue;
    private int appTimeout;
    private boolean inputMode;
    private IIOPOutputStream exceptionResponse = null;
    private Object requestIdToken;

    public GIOPMessageContextBase(Message message, ByteBuffer byteBuffer) throws Exception {
        this.msg = message;
        this.requestIdToken = message.getRequestId();
        if (byteBuffer != null && byteBuffer.getSize() != 0) {
            byteBuffer.flushTo(this);
            byteBuffer.reset();
        }
        this.completedBody = true;
        this.inputMode = false;
    }

    public GIOPMessageContextBase(Message message, WsByteBuffer[] wsByteBufferArray, int n) {
        this.msg = message;
        this.requestIdToken = message.getRequestId();
        this.setMessageBody(wsByteBufferArray);
        this.inputMode = true;
    }

    protected WsByteBuffer fastWrap(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        WsByteBuffer wsByteBuffer = bBPoolManager.allocateDirect(n3);
        wsByteBuffer.put(byArray, n, n3);
        wsByteBuffer.position(0);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "WsByteBuffer created: msgBytes[].length=", Trc.str(byArray.length), ", start=", Trc.str(n), ", end=", Trc.str(n2), ", Result: ", wsByteBuffer, CLASS, "fastWrap:236");
        }
        return wsByteBuffer;
    }

    public GIOPMessageContextBase(Message message) {
        this.msg = message;
        this.completedBody = true;
    }

    public GIOPMessageContextBase(Message message, WsByteBuffer[] wsByteBufferArray) {
        this.msg = message;
        this.setMessageBody(wsByteBufferArray);
        this.completedBody = true;
    }

    public GIOPMessageContextBase() {
    }

    public static Message createMessage(EncoderInputHandler encoderInputHandler, WsByteBuffer[] wsByteBufferArray) throws GIOPVersionException {
        Message message = null;
        if (WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray) < 12) {
            throw new GIOPVersionException("0x" + ByteBufferUtils.bytesToHexString(wsByteBufferArray));
        }
        int n = encoderInputHandler.read_long();
        if (n != 1195986768 && n != 1347373383) {
            throw new GIOPVersionException("0x" + Integer.toHexString(n));
        }
        byte by = encoderInputHandler.read_octet();
        byte by2 = encoderInputHandler.read_octet();
        if (by != 1 || by == 1 && by2 > 2) {
            throw new GIOPVersionException(by + "." + by2);
        }
        byte by3 = encoderInputHandler.read_octet();
        boolean bl = (by3 & 1) == 1;
        encoderInputHandler.setEndian(bl);
        byte by4 = encoderInputHandler.read_octet();
        try {
            message = Message.createMessage(by, by2, by4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new INTERNAL("Bad GIOP request:" + by4, 1229125003, CompletionStatus.COMPLETED_NO);
        }
        int n2 = encoderInputHandler.read_long() + 12;
        message.initializeData(n, by3, by4, n2, 0);
        return message;
    }

    @Override
    public com.ibm.CORBA.iiop.Message getMessage() {
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "msg = ", this.msg, CLASS, "getMessage:373");
        }
        return this.msg;
    }

    public WsByteBuffer[] getMessageBody() {
        if (Trc.enabled(2)) {
            String string;
            String string2 = string = this.bodyBuffers == null ? "Body data is null" : "Body length = " + WsByteBufferUtils.lengthOf((WsByteBuffer[])this.bodyBuffers) + ", Body parts = " + this.bodyBuffers.length;
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, string, CLASS, "getMessageBody:390");
            }
        }
        return this.bodyBuffers;
    }

    private WsByteBuffer[] getMessageBodyOnly() {
        byte[] byArray = WsByteBufferUtils.asByteArray((WsByteBuffer[])this.bodyBuffers);
        WsByteBuffer wsByteBuffer = ByteBufferUtils.fastWrap(byArray, this.msg.getBodyOffset(), byArray.length, true);
        return new WsByteBuffer[]{wsByteBuffer};
    }

    @Override
    public void setMessageBody(WsByteBuffer[] wsByteBufferArray) {
        if (this.bodyBuffers != null) {
            throw new IllegalStateException(CLASS + "." + "setMessageBody" + " cannot be used: body data already exists");
        }
        this.bodySize = wsByteBufferArray == null ? 0 : WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray);
        this.bodyBuffers = wsByteBufferArray;
        this.completedBody = true;
        if (Trc.enabled(2)) {
            String string;
            String string2 = string = this.bodyBuffers == null ? "Body data cleared" : "Body length = " + this.bodySize + ", Body parts = " + this.bodyBuffers.length;
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, string, CLASS, "setMessageBody:427");
            }
        }
    }

    @Override
    public WsByteBuffer[] removeMessageBody() {
        WsByteBuffer[] wsByteBufferArray = this.getMessageBody();
        this.bodyBuffers = null;
        this.bodySize = 0;
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "Body data removed", CLASS, "removeMessageBody:448");
        }
        return wsByteBufferArray;
    }

    @Override
    public int getRequestId() {
        return this.msg.getRequestId();
    }

    @Override
    public int getType() {
        return this.msg.getType();
    }

    @Override
    public String getTypeName() {
        return this.msg.getTypeName();
    }

    @Override
    public boolean isRequest() {
        return false;
    }

    @Override
    public IOR getInitialIOR() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getInitialIOR not supported for Message Type " + this.msg.getTypeName());
    }

    @Override
    public IOR getTargetIOR() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getTargetIOR not supported for Message Type " + this.msg.getTypeName());
    }

    @Override
    public IOR getCurrentIOR() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getIOR not supported for Message Type " + this.msg.getTypeName());
    }

    @Override
    public void setCurrentIOR(IOR iOR) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setIOR not supported for Message Type " + this.msg.getTypeName());
    }

    @Override
    public ObjectKey getInitialObjectKeyObject() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getInitialObjectKeyObject not supported for Message Type " + this.msg.getTypeName());
    }

    @Override
    public ObjectKey getObjectKeyObject() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getObjectKeyObject not supported for Message Type " + this.msg.getTypeName());
    }

    @Override
    public void setObjectKeyObject(ObjectKey objectKey) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setObjectKeyObject not supported for Message Type " + this.msg.getTypeName());
    }

    public void releaseExceptionResponse() {
        this.exceptionResponse.releaseBuffer();
        Message message = (Message)this.exceptionResponse.getMessage();
        GIOPMessageContext gIOPMessageContext = message.getMessageContext();
        gIOPMessageContext.release();
    }

    @Override
    public synchronized void release() {
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "headerBuffers=", this.headerBuffers, " bodyBuffers=", this.bodyBuffers, " headerFragmentContext=", this.headerFragmentContext, " bodyFragmentContext=", this.bodyFragmentContext, CLASS, "release:617");
        }
        if (this.headerBuffers != null) {
            WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])this.headerBuffers);
            this.headerBuffers = null;
        }
        if (this.bodyBuffers != null) {
            WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])this.bodyBuffers);
            this.bodyBuffers = null;
        }
        if (this.headerFragmentContext != null) {
            this.headerFragmentContext.release();
            this.headerFragmentContext = null;
        }
        if (this.bodyFragmentContext != null) {
            this.bodyFragmentContext.release();
            this.bodyFragmentContext = null;
        }
        if (this.exceptionResponse != null) {
            this.releaseExceptionResponse();
            this.exceptionResponse = null;
        }
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        this.appWriteCallback.completeWrite(virtualConnection, this);
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        this.appWriteCallback.errorWrite(virtualConnection, this, iOException);
    }

    @Override
    public void write(int n) throws IOException {
        throw new INTERNAL("write method should not be called");
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "data size=" + byArray.length + " offset=" + n + " length=" + n2, CLASS, "write:710");
        }
        if (this.completedBody) {
            WsByteBuffer wsByteBuffer = ByteBufferUtils.fastWrap(byArray, n, n2, true);
            this.headerBuffers = this.headerBuffers == null ? new WsByteBuffer[]{wsByteBuffer} : WsByteBufferUtils.expandBufferArray((WsByteBuffer[])this.headerBuffers, (WsByteBuffer)wsByteBuffer);
        } else {
            WsByteBuffer wsByteBuffer = ByteBufferUtils.fastWrap(byArray, n, n2, true);
            this.bodyBuffers = this.bodyBuffers == null ? new WsByteBuffer[]{wsByteBuffer} : WsByteBufferUtils.expandBufferArray((WsByteBuffer[])this.bodyBuffers, (WsByteBuffer)wsByteBuffer);
            this.bodySize = WsByteBufferUtils.lengthOf((WsByteBuffer[])this.bodyBuffers);
        }
    }

    public long write(MessageWriter messageWriter, int n) throws IOException {
        long l = 0L;
        if (this.bodySize > 0) {
            if (!this.inputMode && this.msg.isFragmentToFollow() && this.msg.getType() != 7) {
                this.headerFragmentContext = new GIOPMessageContextBase(this.msg);
                l = this.headerFragmentContext.writeHeader(messageWriter, true, n);
                Message message = this.msg.createAssociatedMessage((byte)7);
                message.setFragmentToFollow(true);
                this.bodyFragmentContext = new GIOPMessageContextBase(message, this.bodyBuffers);
                l += this.bodyFragmentContext.writeHeaderWithBody(messageWriter, true, n);
            } else {
                if (this.inputMode) {
                    this.bodyBuffers = this.getMessageBodyOnly();
                    this.msg.setBodyOffset(0);
                    if (Trc.enabled(2)) {
                        Trc.info(Trc.FINEST, "write for Proxy Testing that should not be in production", CLASS, "write:788");
                    }
                }
                boolean bl = false;
                if (this.msg.getType() == 7) {
                    bl = true;
                }
                l = this.writeHeaderWithBody(messageWriter, bl, n);
            }
        } else {
            l = this.writeHeader(messageWriter, false, n);
        }
        return l;
    }

    protected long write(OutputStream outputStream, int n) throws IOException {
        long l = 0L;
        if (this.bodySize > 0) {
            boolean bl = false;
            if (this.msg.getType() == 7) {
                bl = true;
            }
            l = this.writeHeaderWithBody(outputStream, bl, n);
        } else {
            l = this.writeHeader(outputStream, false, n);
        }
        return l;
    }

    public VirtualConnection write(MessageWriter messageWriter, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl, int n) throws IOException {
        VirtualConnection virtualConnection = null;
        this.appWriteContext = messageWriter;
        this.appWriteCallback = gIOPWriteCompletedCallback;
        this.appForceQueue = bl;
        this.appTimeout = n;
        if (this.bodySize > 0) {
            if (!this.inputMode && this.msg.isFragmentToFollow() && this.msg.getType() != 7) {
                this.headerFragmentContext = new GIOPMessageContextBase(this.msg);
                Message message = this.msg.createAssociatedMessage((byte)7);
                message.setFragmentToFollow(true);
                this.bodyFragmentContext = new GIOPMessageContextBase(message, this.bodyBuffers);
                virtualConnection = this.headerFragmentContext.writeHeader(messageWriter, true, this, false, n);
                if (virtualConnection != null) {
                    this.completeWrite(virtualConnection, this.headerFragmentContext);
                }
            } else {
                if (this.inputMode) {
                    this.bodyBuffers = this.getMessageBodyOnly();
                    this.msg.setBodyOffset(0);
                    if (Trc.enabled(2)) {
                        Trc.info(Trc.FINEST, "write for Proxy Testing that should not be in production", CLASS, "write:902");
                    }
                }
                boolean bl2 = false;
                if (this.msg.getType() == 7) {
                    bl2 = true;
                }
                virtualConnection = this.writeHeaderWithBody(messageWriter, bl2, this.appWriteCallback, bl, n);
            }
        } else {
            virtualConnection = this.writeHeader(messageWriter, false, gIOPWriteCompletedCallback, bl, n);
        }
        return virtualConnection;
    }

    protected long writeHeaderWithBody(OutputStream outputStream, boolean bl, int n) throws IOException {
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "writeHeaderWithBody", CLASS, "writeHeaderWithBody:934");
        }
        long l = 0L;
        this.flushMessageHeaderWithBody(bl);
        WsByteBuffer[] wsByteBufferArray = WsByteBufferUtils.expandBufferArray((WsByteBuffer[])this.headerBuffers, (WsByteBuffer[])this.bodyBuffers);
        if (outputStream instanceof MessageWriter) {
            l = ((MessageWriter)outputStream).write(this.msg, wsByteBufferArray, this.msgSize, n);
        } else {
            outputStream.write(WsByteBufferUtils.asByteArray((WsByteBuffer[])wsByteBufferArray));
            l = this.headerSize + this.bodySize;
        }
        return l;
    }

    public VirtualConnection writeHeaderWithBody(MessageWriter messageWriter, boolean bl, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl2, int n) throws IOException {
        this.flushMessageHeaderWithBody(bl);
        WsByteBuffer[] wsByteBufferArray = WsByteBufferUtils.expandBufferArray((WsByteBuffer[])this.headerBuffers, (WsByteBuffer[])this.bodyBuffers);
        VirtualConnection virtualConnection = messageWriter.write(this.msg, wsByteBufferArray, this.msgSize, this, bl2, n);
        return virtualConnection;
    }

    protected long writeHeader(OutputStream outputStream, boolean bl, int n) throws IOException {
        long l = 0L;
        this.flushMessageHeader(bl);
        if (outputStream instanceof MessageWriter) {
            l = ((MessageWriter)outputStream).write(this.msg, this.headerBuffers, this.headerSize, n);
        } else {
            outputStream.write(WsByteBufferUtils.asByteArray((WsByteBuffer[])this.headerBuffers));
            l = this.headerSize;
        }
        return l;
    }

    public VirtualConnection writeHeader(MessageWriter messageWriter, boolean bl, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl2, int n) throws IOException {
        this.appWriteCallback = gIOPWriteCompletedCallback;
        this.flushMessageHeader(bl);
        VirtualConnection virtualConnection = messageWriter.write(this.msg, this.headerBuffers, this.headerSize, this, bl2, n);
        return virtualConnection;
    }

    private EncoderOutputHandler marshalMessageHeader(boolean bl, boolean bl2) {
        EncoderOutputHandler encoderOutputHandler = (EncoderOutputHandler)StreamFactory.createCDROutputHandler(null, this, this.msg.isLittleEndian());
        encoderOutputHandler.setGIOPVersion(this.msg.getGIOPMajor(), this.msg.getGIOPMinor(), false);
        this.msg.write(encoderOutputHandler);
        if (bl) {
            encoderOutputHandler.write_long(this.msg.requestId, false);
        }
        if (bl2) {
            encoderOutputHandler.checkPadding();
        }
        return encoderOutputHandler;
    }

    private void flushMessageHeader(boolean bl) throws IOException {
        EncoderOutputHandler encoderOutputHandler = this.marshalMessageHeader(false, bl);
        this.headerBuffers = encoderOutputHandler.getBufferHandler().getFlippedBuffers();
        this.headerSize = WsByteBufferUtils.lengthOf((WsByteBuffer[])this.headerBuffers);
        this.msg.setSize(this.headerSize);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "headerSize=", Trc.str(this.headerSize), " header bytes ", Trc.array(this.headerBuffers), " : ", Trc.hex(this.headerBuffers), CLASS, "flushMessageHeader:1063");
        }
    }

    private void flushMessageHeaderWithBody(boolean bl) throws IOException {
        EncoderOutputHandler encoderOutputHandler = this.marshalMessageHeader(bl, true);
        this.headerBuffers = encoderOutputHandler.getBufferHandler().getFlippedBuffers();
        this.headerSize = WsByteBufferUtils.lengthOf((WsByteBuffer[])this.headerBuffers);
        this.msgSize = this.headerSize + this.bodySize;
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "msgSize= ", Trc.str(this.msgSize), " headerSize=", Trc.str(this.headerSize), " bodySize=", Trc.str(this.bodySize), CLASS, "flushMessageHeaderWithBody:1084");
        }
        this.msg.setSize(this.msgSize);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "header bytes ", Trc.array(this.headerBuffers), " : ", Trc.hex(this.headerBuffers), CLASS, "flushMessageHeaderWithBody:1088");
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.msg);
        objectOutput.writeInt(this.bodySize);
        if (this.bodySize != 0) {
            objectOutput.writeObject(this.bodyBuffers);
        }
        Message.writeIOR(objectOutput, this.initialIOR);
        Message.writeIOR(objectOutput, this.targetIOR);
        Message.writeIOR(objectOutput, this.currentIOR);
        objectOutput.writeObject(this.initialObjectKey);
        objectOutput.writeObject(this.targetObjectKey);
        this.requestIdToken = this.msg.getRequestId();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.msg = (Message)objectInput.readObject();
        this.bodySize = objectInput.readInt();
        WsByteBuffer[] wsByteBufferArray = null;
        if (this.bodySize != 0) {
            wsByteBufferArray = (WsByteBuffer[])objectInput.readObject();
        }
        this.setMessageBody(wsByteBufferArray);
        this.initialIOR = Message.readIOR(objectInput);
        this.targetIOR = Message.readIOR(objectInput);
        this.currentIOR = Message.readIOR(objectInput);
        this.initialObjectKey = (ObjectKey)objectInput.readObject();
        this.targetObjectKey = (ObjectKey)objectInput.readObject();
    }

    @Override
    public void completeWrite(VirtualConnection virtualConnection, GIOPMessageContext gIOPMessageContext) {
        VirtualConnection virtualConnection2 = null;
        try {
            virtualConnection2 = this.bodyFragmentContext.writeHeaderWithBody(this.appWriteContext, true, this.appWriteCallback, this.appForceQueue, this.appTimeout);
            if (virtualConnection2 != null) {
                this.appWriteCallback.completeWrite(virtualConnection2, this);
            }
        }
        catch (IOException iOException) {
            this.appWriteCallback.errorWrite(virtualConnection2, this, iOException);
        }
    }

    @Override
    public void errorWrite(VirtualConnection virtualConnection, GIOPMessageContext gIOPMessageContext, IOException iOException) {
        this.appWriteCallback.errorWrite(virtualConnection, this, iOException);
    }

    @Override
    public ServiceContextList getServiceContexts() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getServiceContexts not supported for Message Type " + this.msg.getTypeName());
    }

    @Override
    public void setServiceContexts(ServiceContextList serviceContextList) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setServiceContexts not supported for Message Type " + this.msg.getTypeName());
    }

    public IIOPOutputStream getExceptionResponse() {
        return this.exceptionResponse;
    }

    public void setExceptionResponse(IIOPOutputStream iIOPOutputStream) {
        this.exceptionResponse = iIOPOutputStream;
    }

    @Override
    public Object getRequestIdToken() {
        return this.requestIdToken;
    }

    @Override
    public boolean isFragmentToFollow() {
        return this.msg.isFragmentToFollow();
    }

    @Override
    public boolean isResponseExpected() {
        return false;
    }

    @Override
    public WsByteBuffer[] getSendingContextBytes() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getSendingContextBytes not supported for Message Type " + this.msg.getTypeName());
    }

    public void setSendingContextBytes(WsByteBuffer[] wsByteBufferArray) {
    }

    @Override
    public void flush(WsByteBuffer[] wsByteBufferArray) {
        throw new MARSHAL("OutputStream fragmentation error: CFW Message header should not be fragmented", 1229125818, CompletionStatus.COMPLETED_NO);
    }

    @Override
    public WsByteBuffer getBuffer(int n) {
        return bBPoolManager.allocateDirect(n);
    }
}

