/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.IIOPReader;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.ras.Trace;
import com.ibm.rmi.ras.Utility;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.io.IOException;
import java.util.LinkedList;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.InputStream;

public class IIOPInputStream
extends EncoderInputStream
implements com.ibm.CORBA.iiop.IIOPInputStream,
IIOPReader {
    private static final String CLASS = IIOPInputStream.class.getName();
    private GIOPConnectionContext giopConnCtx = null;
    protected Connection conn = null;
    protected Message msg;
    boolean firstFragment = true;
    boolean dumpBuffer = true;
    boolean dumpMsgHeader = true;
    private int markOffset;
    private int markIndex;
    private boolean markFirstFragment;
    private long markBlockLength;
    private LinkedList bufsFromMark = null;
    private LinkedList resetBufs = null;
    private boolean useCFW = false;
    private LinkedList fragmentList;

    public IIOPInputStream() {
    }

    public IIOPInputStream(com.ibm.rmi.ORB oRB) {
        super((org.omg.CORBA.ORB)oRB, null, 0);
    }

    public IIOPInputStream(ORB oRB, Connection connection) {
        super((org.omg.CORBA.ORB)oRB, null, 0, connection);
        this.conn = connection;
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n, boolean bl, Message message) {
        super((org.omg.CORBA.ORB)oRB, byArray, n, bl);
        this.msg = message;
        this.setGIOPVersion(message.getGIOPMajor(), message.getGIOPMinor(), true);
        this.logCommTrace(byArray, n, 0);
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n, boolean bl) {
        super((org.omg.CORBA.ORB)oRB, byArray, n, bl);
        this.logCommTrace(byArray, n, 0);
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message, int n) throws IOException {
        this(connection.getORB(), connection);
        this.initMsgData(byArray, message, n);
        this.setUpHeader(message);
        if (connection != null) {
            this.fragmentList = this.conn.getFragmentsList(message.getRequestId());
        }
        this.logCommTrace(byArray, this.getSize(), n);
    }

    public WsByteBuffer[] readWholeHeader(Message message, WsByteBuffer[] wsByteBufferArray, TransportConnection transportConnection) {
        boolean bl;
        this.useCFW = true;
        this.initMsgData(wsByteBufferArray, message);
        this.setUpHeader(message);
        message.setBodyOffset(this.get_offset());
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "reqId=", Trc.str(message.getRequestId()), " buffer length=", Trc.str(wsByteBufferArray.length), " bodyOffset =", Trc.str(message.bodyOffset), CLASS, "readWholeHeader:191");
        }
        if (transportConnection != null && (bl = this.orb() instanceof ORB ? ((ORB)this.orb()).CommTraceIsEnabled() : Trc.enabled()) && transportConnection != null) {
            Trace.dump(Utility.getMessage("Trace.inComing"), this.dumpMsgHeader, this.dumpBuffer, WsByteBufferUtils.asByteArray((WsByteBuffer[])wsByteBufferArray), this.getSize(), this.getStreamOffset(), transportConnection);
        }
        return wsByteBufferArray;
    }

    public IIOPInputStream(Connection connection, WsByteBuffer[] wsByteBufferArray, Message message, int n) {
        this(connection.getORB(), connection);
        this.initMsgData(wsByteBufferArray, message);
        this.reset(n);
    }

    private void initMsgData(WsByteBuffer[] wsByteBufferArray, Message message) {
        byte[] byArray = WsByteBufferUtils.asByteArray((WsByteBuffer[])wsByteBufferArray);
        this.initMsgData(byArray, message, 0);
    }

    private void initMsgData(byte[] byArray, Message message, int n) {
        this.setByteBuffer(byArray);
        this.msg = message;
        this.setGIOPVersion(this.msg.getGIOPMajor(), this.msg.getGIOPMinor(), true);
        this.setLittleEndian(this.msg.isLittleEndian());
        this.setSize(this.msg.getSize() + n);
        this.setStart(n);
        this.setBufferIndex(n + 12);
    }

    private void setUpHeader(Message message) {
        int n = message.getType();
        byte by = this.getMode();
        this.setMode((byte)1);
        if (!(this.msg.preGIOP12() || n != 0 && n != 3 && n != 1 && n != 4 && n != 7)) {
            this.msg.setRequestId(this.read_long());
            if (this.useCFW) {
                this.msg.read((InputStream)this);
            } else if (!this.msg.isFragmentToFollow() && n != 7) {
                this.msg.read((InputStream)this);
            } else if (n != 7) {
                this.dumpMsgHeader = false;
            }
        } else {
            this.msg.read((InputStream)this);
        }
        this.setMode(by);
    }

    @Override
    public final Connection getConnection() {
        return this.conn;
    }

    @Override
    public final void setConnection(Connection connection) {
        this.conn = connection;
        this.setOrb((org.omg.CORBA.ORB)connection.getORB());
    }

    @Override
    public final com.ibm.CORBA.iiop.Message getMessage() {
        return this.msg;
    }

    @Override
    public boolean isFirstFragment() {
        return this.firstFragment;
    }

    public void setGIOPConnectionContext(GIOPConnectionContext gIOPConnectionContext) {
        this.giopConnCtx = gIOPConnectionContext;
    }

    public void setFragmentsList(LinkedList linkedList) {
        this.fragmentList = linkedList;
    }

    @Override
    public void getNextBuffer() {
        this.setStreamOffset(this.getStreamOffset() + (this.getBufferIndex() - this.getStart()));
        this.setStreamOffset(this.getStreamOffset() - 16);
        if (this.resetBufs != null) {
            SavedBuf savedBuf = (SavedBuf)this.resetBufs.removeFirst();
            if (this.resetBufs.size() == 0) {
                this.resetBufs = null;
            }
            this.processNextBuffer(savedBuf.buf, savedBuf.start, savedBuf.size, savedBuf.msg, false);
        } else if (null != this.giopConnCtx) {
            try {
                int n = this.msg.getRequestId();
                WsByteBuffer[] wsByteBufferArray = this.giopConnCtx.getNextFragment(n);
                byte[] byArray = WsByteBufferUtils.asByteArray((WsByteBuffer[])wsByteBufferArray);
                WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])wsByteBufferArray);
                this.processNextBuffer(byArray);
            }
            catch (TIMEOUT tIMEOUT) {
                Trc.warn("Timed out waiting for next fragment", CLASS, "getNextBuffer:350");
                throw tIMEOUT;
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "getNextBuffer:353");
                throw new INTERNAL(exception.toString(), 1229125060, CompletionStatus.COMPLETED_NO);
            }
        } else if (null != this.conn) {
            IIOPInputStream iIOPInputStream = this.conn.getNextFragment(this.msg.getRequestId(), this.fragmentList);
            this.processNextBuffer(iIOPInputStream);
        } else {
            Trc.ffdc("Client response without connection details", CLASS, "getNextBuffer:364");
            throw new INTERNAL("ClientResponse without connection details", 1229125052, CompletionStatus.COMPLETED_NO);
        }
    }

    private void processNextBuffer(byte[] byArray, int n, int n2, Message message, boolean bl) {
        if (bl && this.bufsFromMark != null) {
            SavedBuf savedBuf = new SavedBuf(byArray, n, n2, message);
            this.bufsFromMark.addLast(savedBuf);
        }
        this.firstFragment = false;
        this.setByteBuffer(byArray);
        this.setStart(n);
        this.setSize(n2);
        this.msg = message;
        this.setBufferIndex(n + 12 + 4);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "reqId", Trc.str(message.getRequestId()), "new frag offset_hex", Trc.hex(this.get_offset()), CLASS, "processNextBuffer:392");
        }
    }

    private void processNextBuffer(IIOPInputStream iIOPInputStream) {
        this.processNextBuffer(iIOPInputStream.getByteBuffer(), iIOPInputStream.getStart(), iIOPInputStream.getSize(), iIOPInputStream.msg, true);
    }

    private void processNextBuffer(SavedBuf savedBuf) {
        this.processNextBuffer(savedBuf.buf, savedBuf.start, savedBuf.size, savedBuf.msg, false);
    }

    private void processNextBuffer(byte[] byArray) {
        if (byArray == null) {
            Trc.ffdc("Null buffer for next fragment", CLASS, "processNextBuffer:413");
            throw new INTERNAL("Null buffer for next fragment", 1229125059, CompletionStatus.COMPLETED_NO);
        }
        this.processNextBuffer(byArray, 0, byArray.length, this.msg, true);
    }

    @Override
    public int mark() {
        this.markOffset = this.getStreamOffset();
        this.markIndex = this.getBufferIndex();
        this.markFirstFragment = this.firstFragment;
        this.markBlockLength = this.getBlockLength();
        SavedBuf savedBuf = new SavedBuf(this.getByteBuffer(), this.getStart(), this.getSize(), this.msg);
        if (this.bufsFromMark != null) {
            SavedBuf savedBuf2;
            while ((savedBuf2 = (SavedBuf)this.bufsFromMark.removeFirst()).buf != this.getByteBuffer() || savedBuf2.start != this.getStart()) {
            }
            if (savedBuf2.size != this.getSize() || !savedBuf2.msg.equals(this.msg)) {
                throw new MARSHAL("Stream mark error", 1229125871, CompletionStatus.COMPLETED_NO);
            }
        } else {
            this.bufsFromMark = this.resetBufs == null ? new LinkedList() : (LinkedList)this.resetBufs.clone();
        }
        this.bufsFromMark.addFirst(savedBuf);
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "New or updated mark buffer: ", "markOffset=", Trc.str(this.markOffset), ", markIndex=", Trc.str(this.markIndex), ", bufsFromMark.size()=", Trc.str(this.bufsFromMark.size()), CLASS, "mark:453");
        }
        return this.getBufferIndex();
    }

    @Override
    public void reset(int n) {
        if (n != this.markIndex) {
            throw new MARSHAL("resetIndex (" + n + ") is not equal to markIndex (" + this.markIndex + ")", 1229125823, CompletionStatus.COMPLETED_NO);
        }
        this.reset();
    }

    public void reset() {
        String string = "reset";
        if (this.bufsFromMark != null) {
            if (Trc.enabled(2)) {
                Trc.info(Trc.FINEST, "Resetting stream: ", "markOffset=", Trc.str(this.markOffset), ", markIndex=", Trc.str(this.markIndex), ", bufsFromMark.size()=", Trc.str(this.bufsFromMark.size()), CLASS, string + ":475");
            }
            this.setStreamOffset(this.markOffset);
            this.setBufferIndex(this.markIndex);
            this.firstFragment = this.markFirstFragment;
            this.setBlockLength(this.markBlockLength);
            this.resetBufs = this.bufsFromMark;
            this.bufsFromMark = null;
            SavedBuf savedBuf = (SavedBuf)this.resetBufs.removeFirst();
            this.setByteBuffer(savedBuf.buf);
            this.setStart(savedBuf.start);
            this.setSize(savedBuf.size);
            this.msg = savedBuf.msg;
            if (this.resetBufs.isEmpty()) {
                this.resetBufs = null;
            }
        } else {
            throw new MARSHAL("Stream reset error", 1229125823, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    protected void grow(int n, int n2) {
        throw new MARSHAL("Read beyond end of input stream", 1229125844, CompletionStatus.COMPLETED_MAYBE);
    }

    @Override
    public void logCommTrace() {
        this.dumpBuffer = false;
        this.dumpMsgHeader = true;
        this.logCommTrace(this.getByteBuffer(), this.getSize(), this.getStart());
    }

    private void logCommTrace(byte[] byArray, int n, int n2) {
        if (this.conn != null && ((ORB)this.orb()).CommTraceIsEnabled()) {
            TransportConnection transportConnection;
            try {
                transportConnection = this.conn.getTransportConnection();
            }
            catch (TRANSIENT tRANSIENT) {
                Trace.dump(Utility.getMessage("Trace.inComing"), this.dumpMsgHeader, this.dumpBuffer, byArray, n, n2, this.conn);
                return;
            }
            Trace.dump(Utility.getMessage("Trace.inComing"), this.dumpMsgHeader, this.dumpBuffer, byArray, n, n2, transportConnection);
        }
    }

    private static final class SavedBuf {
        private final int start;
        private final int size;
        private final Message msg;
        private final byte[] buf;

        private SavedBuf(byte[] byArray, int n, int n2, Message message) {
            this.buf = byArray;
            this.start = n;
            this.size = n2;
            this.msg = message;
        }
    }
}

