/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.giop.GIOPWriteCompletedCallback;
import com.ibm.CORBA.channel.orb.CallLink;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.orb.ORBClientCallLink;
import com.ibm.rmi.iiop.CancelRequestException;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.OutCallDesc;
import com.ibm.rmi.ras.Trace;
import com.ibm.rmi.ras.Utility;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.rmi.util.buffer.HollowByteBuffer;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.portable.InputStream;

public class IIOPOutputStream
extends EncoderOutputStream
implements com.ibm.CORBA.iiop.IIOPOutputStream {
    private static final String CLASS = IIOPOutputStream.class.getName();
    protected Connection conn;
    protected Message msg;
    boolean firstFragSent;
    boolean lastFragSent;
    boolean requestCancelled;
    int firstMsgType = -1;
    OutCallDesc call;
    private long socketWriteTimeout;

    public IIOPOutputStream(ORB oRB, Connection connection) {
        super((org.omg.CORBA.ORB)oRB, connection);
        this.setConnection(connection);
        this.socketWriteTimeout = oRB.getSocketWriteTimeout();
    }

    public IIOPOutputStream(ORB oRB, boolean bl) {
        super((org.omg.CORBA.ORB)oRB, bl);
        this.socketWriteTimeout = oRB.getSocketWriteTimeout();
    }

    public IIOPOutputStream(ORB oRB, Connection connection, byte by, byte by2) {
        super((org.omg.CORBA.ORB)oRB, connection);
        this.setGIOPVersion(by, by2, false);
        this.setConnection(connection);
        this.socketWriteTimeout = oRB.getSocketWriteTimeout();
    }

    public IIOPOutputStream(IIOPInputStream iIOPInputStream) {
        super(iIOPInputStream.orb(), iIOPInputStream.getConnection());
        this.setGIOPVersion(iIOPInputStream.getGIOPMajor(), iIOPInputStream.getGIOPMinor(), false);
        this.setConnection(iIOPInputStream.getConnection());
        this.socketWriteTimeout = ((ORB)iIOPInputStream.orb()).getSocketWriteTimeout();
    }

    @Override
    public final Connection getConnection() {
        return this.conn;
    }

    @Override
    public final void setConnection(Connection connection) {
        this.conn = connection;
        this.setConnectionInfo(connection);
    }

    @Override
    public final com.ibm.CORBA.iiop.Message getMessage() {
        return this.msg;
    }

    @Override
    public final void setMessage(com.ibm.CORBA.iiop.Message message) {
        this.msg = (Message)message;
    }

    public void lastFragSent() {
        this.lastFragSent = true;
    }

    public boolean isFirstFragSent() {
        return this.firstFragSent;
    }

    public void setCall(OutCallDesc outCallDesc) {
        this.call = outCallDesc;
    }

    public OutCallDesc getCall() {
        return this.call;
    }

    @Override
    protected void sendFragment() {
        block12: {
            this.setInitialOffset(this.getInitialOffset() + this.getByteBuffer().getWriteOffset());
            if (!((ORB)this.orb()).useChannelFramework()) {
                this.setInitialOffset(this.getInitialOffset() - 16);
            }
            this.msg.setFragmentToFollow(true);
            Connection connection = this.getConnection();
            if (connection == null) {
                INTERNAL iNTERNAL = new INTERNAL("ClientRequest without connection details", 1229125053, CompletionStatus.COMPLETED_NO);
                Trc.ffdc(iNTERNAL, CLASS, "sendFragment:214");
                throw iNTERNAL;
            }
            try {
                connection.sendFragment(this, this.msg.getRequestId(), this.msg.getType(), this.firstFragSent);
                if (!this.firstFragSent) {
                    this.firstMsgType = this.msg.getType();
                    this.firstFragSent = true;
                }
            }
            catch (Exception exception) {
                if (Trc.enabled()) {
                    Trc.warn(exception, CLASS, "sendFragment:230");
                }
                if (exception instanceof COMM_FAILURE && ((COMM_FAILURE)exception).minor == 1229124368) {
                    this.handleSendFragmentException((RuntimeException)exception, "sendFragment");
                } else if (exception instanceof NO_RESPONSE) {
                    this.handleSendFragmentException((RuntimeException)exception, "sendFragment");
                } else {
                    MARSHAL mARSHAL = new MARSHAL("Error sending fragment", 1229125820, CompletionStatus.COMPLETED_NO);
                    mARSHAL.initCause((Throwable)exception);
                    this.handleSendFragmentException((RuntimeException)((Object)mARSHAL), "sendFragment");
                }
                this.setByteBuffer(HollowByteBuffer.INSTANCE);
                if (!Trc.enabled(2)) break block12;
                Trc.info(Trc.FINEST, "reqId " + this.msg.getRequestId() + " buffer replaced by a hollow buffer." + " All data beyond this point will be " + " discarded.", CLASS, "sendFragment:247");
            }
        }
        this.msg = this.msg.createAssociatedMessage((byte)7);
        if (!((ORB)this.orb()).useChannelFramework()) {
            boolean bl = this.getStartNewChunk();
            this.setStartNewChunk(false);
            this.msg.write(this);
            this.setStartNewChunk(bl);
            this.write_long(this.msg.getRequestId(), false);
        }
        if (Trc.enabled(2)) {
            Trc.info(Trc.FINEST, "reqId " + this.msg.getRequestId() + " next fragment offset_hex " + Integer.toHexString(this.get_offset()), CLASS, "sendFragment:275");
        }
    }

    protected void cancelRequest() {
        block9: {
            Connection connection = this.getConnection();
            if (connection == null) {
                INTERNAL iNTERNAL = new INTERNAL("ClientRequest without connection details", 1229125054, CompletionStatus.COMPLETED_NO);
                Trc.ffdc(iNTERNAL, CLASS, "cancelRequest:289");
                return;
            }
            if (!this.firstFragSent || this.lastFragSent || this.requestCancelled) {
                if (((ORB)this.orb()).useChannelFramework()) {
                    connection.getGiopConnCtx().finishRequest(this.msg.getRequestId());
                }
                return;
            }
            if (this.firstMsgType != 0 && this.firstMsgType != 3) {
                if (((ORB)this.orb()).useChannelFramework()) {
                    connection.getGiopConnCtx().finishRequest(this.msg.getRequestId());
                }
                return;
            }
            this.getByteBuffer().reset();
            this.msg = this.msg.createAssociatedMessage((byte)2);
            if (!((ORB)this.orb()).useChannelFramework()) {
                boolean bl = this.getStartNewChunk();
                this.setStartNewChunk(false);
                this.msg.write(this);
                this.setStartNewChunk(bl);
            }
            try {
                connection.sendFragment(this, this.msg.getRequestId(), this.msg.getType(), this.firstFragSent);
                this.requestCancelled = true;
                if (((ORB)this.orb()).useChannelFramework()) {
                    connection.getGiopConnCtx().finishRequest(this.msg.getRequestId());
                }
            }
            catch (Exception exception) {
                if (!Trc.enabled()) break block9;
                Trc.warn(exception, CLASS, "cancelRequest:332");
            }
        }
    }

    public void cancelReply() {
        Connection connection = this.getConnection();
        if (connection == null) {
            INTERNAL iNTERNAL = new INTERNAL("ClientRequest without connection details", 1229125055, CompletionStatus.COMPLETED_NO);
            Trc.ffdc(iNTERNAL, CLASS, "cancelReply:346");
            throw iNTERNAL;
        }
        if (!this.firstFragSent || this.lastFragSent || this.requestCancelled) {
            return;
        }
        this.getByteBuffer().reset();
        this.msg = this.msg.createAssociatedMessage((byte)7);
        if (!((ORB)this.orb()).useChannelFramework()) {
            boolean bl = this.getStartNewChunk();
            this.setStartNewChunk(false);
            this.msg.write(this);
            this.write_long(this.msg.getRequestId());
            this.setStartNewChunk(bl);
        } else {
            this.write_long(this.msg.getRequestId());
        }
        try {
            this.getConnection().sendFragment(this, this.msg.getRequestId(), this.msg.getType(), this.firstFragSent);
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "cancelReply:382");
        }
        this.requestCancelled = true;
        throw new CancelRequestException();
    }

    public void writeTo(CallLink callLink, GIOPConnectionContext gIOPConnectionContext) throws IOException {
        GIOPMessageContext gIOPMessageContext = null;
        try {
            gIOPMessageContext = this.msg.flushToMessageContext(this.getByteBuffer());
            if (callLink instanceof ORBClientCallLink) {
                ((ORBClientCallLink)callLink).setRequestId(gIOPMessageContext.getRequestId());
            }
            gIOPConnectionContext.writeMessage(callLink, gIOPMessageContext, -1);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        finally {
            if (gIOPMessageContext != null) {
                gIOPMessageContext.release();
            }
        }
    }

    public VirtualConnection writeAsyncExceptionResponse(GIOPConnectionContext gIOPConnectionContext, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl, int n) throws IOException {
        VirtualConnection virtualConnection = null;
        try {
            GIOPMessageContext gIOPMessageContext = this.msg.flushToMessageContext(this.getByteBuffer());
            virtualConnection = gIOPConnectionContext.writeMessage(null, gIOPMessageContext, gIOPWriteCompletedCallback, bl, n);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        return virtualConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTo(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        try {
            this.msg.writeContext(outputStream, byteBuffer);
        }
        finally {
            this.msg.getMessageContext().release();
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        boolean bl;
        if (Trc.enabled(2)) {
            Trc.begin(Trc.FINEST, CLASS, "writeTo:477");
        }
        if (((ORB)this.orb()).useChannelFramework()) {
            this.writeTo(outputStream, this.getByteBuffer());
            if (Trc.enabled(2)) {
                Trc.complete(Trc.FINEST, CLASS, "writeTo:484");
            }
            return;
        }
        this.msg.setSize(this.getByteBuffer().getWriteOffset());
        if (this.conn != null && (bl = this.orb() instanceof ORB ? ((ORB)this.orb()).CommTraceIsEnabled() : Trc.enabled())) {
            boolean bl2 = true;
            int n = this.msg.getType();
            if (!(this.firstFragSent || this.msg.headerWritten() || n != 0 && n != 3 && n != 1 && n != 4 && n != 7)) {
                bl2 = false;
            }
            byte[] byArray = this.getBuffer();
            Trace.dump(Utility.getMessage("Trace.outGoing"), bl2, true, byArray, byArray.length, 0, this.conn.getTransportConnection());
        }
        if (this.socketWriteTimeout == 0L) {
            this.getByteBuffer().flushTo(outputStream);
        } else {
            this.getByteBuffer().flushTo(outputStream, this.conn);
        }
        if (Trc.enabled(2)) {
            Trc.complete(Trc.FINEST, CLASS, "writeTo:540");
        }
    }

    @Override
    public InputStream create_input_stream() {
        final byte[] byArray = this.getBuffer();
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new IIOPInputStream((ORB)IIOPOutputStream.this.orb(), byArray, byArray.length, IIOPOutputStream.this.littleEndian(), IIOPOutputStream.this.msg);
            }
        });
    }

    void handleSendFragmentException(RuntimeException runtimeException, String string) {
        if (Trc.enabled()) {
            Trc.warn("Exception While sending a Fragment " + runtimeException, CLASS, string + ":568");
        }
        throw runtimeException;
    }

    public static class SocketWriteTimeOutException
    extends IOException {
        public SocketWriteTimeOutException(String string) {
            super(string);
        }
    }
}

