/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.transport.ConnectionTableImpl;

public class SocketTimerThread
extends Thread {
    private static final String CLASS = SocketTimerThread.class.getName();
    ConnectionTableImpl conTab;
    private long socketWriteTimeoutInMillis = Long.MAX_VALUE;
    private boolean isShutdownPending = false;

    public SocketTimerThread(ConnectionTableImpl connectionTableImpl, long l) {
        this.conTab = connectionTableImpl;
        this.socketWriteTimeoutInMillis = l;
        this.setDaemon(true);
        this.setName("Socket Timer Thread");
    }

    @Override
    public void run() {
        String string = "run";
        while (!this.isShutdownPending) {
            try {
                Thread.sleep(this.socketWriteTimeoutInMillis);
                this.conTab.removeConnectionsStuckInWrite();
            }
            catch (InterruptedException interruptedException) {
                if (!this.isShutdownPending) continue;
                if (!Trc.enabled()) break;
                Trc.warn("SocketWriteTimer interrupted with shutdown pending", CLASS, string + ":64");
                break;
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, string + ":71");
            }
        }
    }

    public void setShutdownPending() {
        this.isShutdownPending = true;
    }
}

