/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.io.ReflectField;
import com.ibm.rmi.io.ReflectFieldFactoryStrategy;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class HarmonyReflectFieldFactory
extends ReflectFieldFactoryStrategy {
    static final ReflectFieldFactoryStrategy INSTANCE = new HarmonyReflectFieldFactory();

    private HarmonyReflectFieldFactory() {
    }

    @Override
    ReflectField createReflectField(Field field) {
        return new ReflectFieldImpl(field);
    }

    static boolean isAvailable() {
        return null != ReflectFieldImpl.setMethods;
    }

    private static final class ReflectFieldImpl
    implements ReflectField {
        private static final String CLASS = ReflectFieldImpl.class.getName();
        private static final int BOOLEAN = 0;
        private static final int BYTE = 1;
        private static final int CHARACTER = 2;
        private static final int DOUBLE = 3;
        private static final int FLOAT = 4;
        private static final int INTEGER = 5;
        private static final int LONG = 6;
        private static final int SHORT = 7;
        private static final int OBJECT = 8;
        private static final Method[] setMethods;
        private final Field field;
        private final String fieldName;
        private final String fieldType;
        private final Class declaringClass;

        private static String typeId(Class clazz) {
            String string = clazz.getName().replace('.', '/');
            if (clazz.isArray()) {
                return string;
            }
            return "L" + string + ";";
        }

        public ReflectFieldImpl(Field field) {
            this.field = field;
            this.fieldName = field.getName();
            this.fieldType = ReflectFieldImpl.typeId(field.getType());
            this.declaringClass = field.getDeclaringClass();
        }

        @Override
        public long getFieldOffset() {
            throw new UnsupportedOperationException("getFieldOffset is  not  supported  by " + this.getClass().getName() + " class");
        }

        @Override
        public Object get(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.get(object);
        }

        @Override
        public boolean getBoolean(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getBoolean(object);
        }

        @Override
        public byte getByte(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getByte(object);
        }

        @Override
        public char getChar(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getChar(object);
        }

        @Override
        public short getShort(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getShort(object);
        }

        @Override
        public int getInt(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getInt(object);
        }

        @Override
        public long getLong(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getLong(object);
        }

        @Override
        public float getFloat(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getFloat(object);
        }

        @Override
        public double getDouble(Object object) throws IllegalArgumentException, IllegalAccessException {
            return this.field.getDouble(object);
        }

        @Override
        public void set(Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
            try {
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, "Obj=", object.getClass().getName(), ", declaringClass=", this.declaringClass.getName(), ", fieldName=", this.fieldName, ", fieldType=", this.fieldType, ", value=", object2, CLASS, "set:170");
                }
                setMethods[8].invoke(null, object, this.declaringClass, this.fieldName, this.fieldType, object2);
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No such field");
                illegalArgumentException.initCause(invocationTargetException);
                Trc.ffdc(illegalArgumentException, CLASS, "set:177");
                throw illegalArgumentException;
            }
        }

        @Override
        public void setBoolean(Object object, boolean bl) throws IllegalArgumentException, IllegalAccessException {
            try {
                setMethods[0].invoke(null, object, object.getClass(), this.fieldName, bl);
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No such field");
                illegalArgumentException.initCause(invocationTargetException);
                Trc.ffdc(illegalArgumentException, CLASS, "setBoolean:192");
                throw illegalArgumentException;
            }
        }

        @Override
        public void setByte(Object object, byte by) throws IllegalArgumentException, IllegalAccessException {
            try {
                setMethods[1].invoke(null, object, object.getClass(), this.fieldName, by);
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No such field");
                illegalArgumentException.initCause(invocationTargetException);
                Trc.ffdc(illegalArgumentException, CLASS, "setByte:207");
                throw illegalArgumentException;
            }
        }

        @Override
        public void setChar(Object object, char c) throws IllegalArgumentException, IllegalAccessException {
            try {
                setMethods[2].invoke(null, object, object.getClass(), this.fieldName, Character.valueOf(c));
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No such field");
                illegalArgumentException.initCause(invocationTargetException);
                Trc.ffdc(illegalArgumentException, CLASS, "setChar:222");
                throw illegalArgumentException;
            }
        }

        @Override
        public void setDouble(Object object, double d) throws IllegalArgumentException, IllegalAccessException {
            try {
                setMethods[3].invoke(null, object, object.getClass(), this.fieldName, new Double(d));
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No such field");
                illegalArgumentException.initCause(invocationTargetException);
                Trc.ffdc(illegalArgumentException, CLASS, "setDouble:237");
                throw illegalArgumentException;
            }
        }

        @Override
        public void setFloat(Object object, float f) throws IllegalArgumentException, IllegalAccessException {
            try {
                setMethods[4].invoke(null, object, object.getClass(), this.fieldName, new Float(f));
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No such field");
                illegalArgumentException.initCause(invocationTargetException);
                Trc.ffdc(illegalArgumentException, CLASS, "setFloat:252");
                throw illegalArgumentException;
            }
        }

        @Override
        public void setInt(Object object, int n) throws IllegalArgumentException, IllegalAccessException {
            try {
                setMethods[5].invoke(null, object, object.getClass(), this.fieldName, n);
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No such field");
                illegalArgumentException.initCause(invocationTargetException);
                Trc.ffdc(illegalArgumentException, CLASS, "setBoolean:267");
                throw illegalArgumentException;
            }
        }

        @Override
        public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
            try {
                setMethods[6].invoke(null, object, object.getClass(), this.fieldName, l);
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No such field");
                illegalArgumentException.initCause(invocationTargetException);
                Trc.ffdc(illegalArgumentException, CLASS, "setLong:282");
                throw illegalArgumentException;
            }
        }

        @Override
        public void setShort(Object object, short s) throws IllegalArgumentException, IllegalAccessException {
            try {
                setMethods[7].invoke(null, object, object.getClass(), this.fieldName, s);
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No such field");
                illegalArgumentException.initCause(invocationTargetException);
                Trc.ffdc(illegalArgumentException, CLASS, "setShort:297");
                throw illegalArgumentException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            Method[] methodArray = null;
            try {
                methodArray = (Method[])AccessController.doPrivileged(new InitAction());
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (Trc.enabled(2)) {
                    Trc.info(Trc.FINEST, privilegedActionException, CLASS, "<clinit>:85");
                }
            }
            finally {
                setMethods = methodArray;
            }
        }

        private static final class InitAction
        implements PrivilegedExceptionAction {
            private InitAction() {
            }

            public Object run() throws Exception {
                Class<ObjectInputStream> clazz = ObjectInputStream.class;
                Class[] classArray = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE};
                Class[] classArray2 = new Class[]{Object.class, Class.class, String.class, String.class, Object.class};
                Class[] classArray3 = new Class[]{Object.class, Class.class, String.class, null};
                Method[] methodArray = new Method[classArray.length + 1];
                for (int i = 0; i < classArray.length; ++i) {
                    classArray3[3] = classArray[i];
                    methodArray[i] = clazz.getDeclaredMethod("setField", classArray3);
                    methodArray[i].setAccessible(true);
                }
                methodArray[8] = clazz.getDeclaredMethod("objSetField", classArray2);
                methodArray[8].setAccessible(true);
                return methodArray;
            }
        }
    }
}

