/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.poa;

import java.util.concurrent.atomic.AtomicInteger;

public final class RequestTracker {
    private AtomicInteger activeCount = new AtomicInteger(0);
    private AtomicInteger deactiveCount = new AtomicInteger(0);
    private final ActiveLock activeLock = new ActiveLock();
    private final DeactiveLock deactiveLock = new DeactiveLock();

    void beginRequest() {
        this.waitForDeactivation();
        this.activeCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForDeactivation() {
        if (this.deactiveCount.get() > 0) {
            DeactiveLock deactiveLock = this.deactiveLock;
            synchronized (deactiveLock) {
                while (this.deactiveCount.get() > 0) {
                    try {
                        this.deactiveLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endRequest() {
        if (this.activeCount.decrementAndGet() == 0) {
            ActiveLock activeLock = this.activeLock;
            synchronized (activeLock) {
                this.activeLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForRequests() {
        if (this.activeCount.get() > 0) {
            ActiveLock activeLock = this.activeLock;
            synchronized (activeLock) {
                while (this.activeCount.get() > 0) {
                    try {
                        this.activeLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean hasRequests() {
        return this.activeCount.get() != 0;
    }

    void beginDeactivation() {
        this.deactiveCount.incrementAndGet();
    }

    boolean inDeactivation() {
        return this.deactiveCount.get() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endDeactivation() {
        if (this.deactiveCount.decrementAndGet() == 0) {
            DeactiveLock deactiveLock = this.deactiveLock;
            synchronized (deactiveLock) {
                this.deactiveLock.notifyAll();
            }
        }
    }

    private class DeactiveLock {
        private DeactiveLock() {
        }
    }

    private class ActiveLock {
        private ActiveLock() {
        }
    }
}

