/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.transport;

import com.ibm.CORBA.iiop.Delegate;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ORBConnection;
import com.ibm.CORBA.iiop.ORBForTransports;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.ConnectionTable;
import com.ibm.CORBA.transport.TransportBase;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.CORBA.transport.TransportConnectionBase;
import com.ibm.rmi.transport.ConnectionKeyImpl;
import com.ibm.rmi.transport.ListenerThread;
import com.ibm.rmi.transport.TCPTransportConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;

public class TCPTransport
extends TransportBase {
    private ORB orb;
    private ConnectionTable connTable;
    private ORBForTransports tOrb;
    private Profile serverProfile = null;
    private int acceptTimeout = 0;
    private Set listeners;
    private static final String CLASS = TCPTransport.class.getName();

    @Override
    public void init(ORB oRB) {
        this.orb = oRB;
        this.connTable = ORB.createConnectionTable(oRB, this);
        this.tOrb = oRB.getORBForTransports();
        this.listeners = new HashSet(1);
        try {
            this.acceptTimeout = Integer.parseInt(oRB.getProperty("com.ibm.CORBA.AcceptTimeout"));
            if (this.acceptTimeout < 0 || this.acceptTimeout > 5000) {
                this.acceptTimeout = 5000;
            }
        }
        catch (Exception exception) {
            if (Trc.enabled(3)) {
                Trc.info(Trc.FINEST, exception.toString(), CLASS, "init:104");
            }
            this.acceptTimeout = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORBConnection getConnection(Profile profile, String string, Delegate delegate) {
        ORBConnection oRBConnection;
        String string2 = profile.getHost();
        int n = profile.getPort();
        String string3 = profile.getHostIPAddress();
        if (Trc.enabled(3)) {
            Trc.begin1(Trc.FINE, "host=" + string2 + ", IP=" + string3 + ", port=" + n + ", operation=" + string, CLASS, "getConnection:123");
        }
        ConnectionKeyImpl connectionKeyImpl = new ConnectionKeyImpl(string2, string3, n);
        Object object = this.connTable;
        synchronized (object) {
            oRBConnection = this.connTable.getConnection(connectionKeyImpl);
            if (oRBConnection != null) {
                if (Trc.enabled(3)) {
                    Trc.complete(Trc.FINE, oRBConnection, CLASS, "getConnection:134");
                }
                return oRBConnection;
            }
            oRBConnection = this.tOrb.createORBConnection();
            this.connTable.addConnection(connectionKeyImpl, oRBConnection);
        }
        object = new TCPTransportConnection(this.tOrb, this.connTable, connectionKeyImpl, oRBConnection, this.orb.getReaderPool(), profile);
        ((TransportConnectionBase)object).connect();
        this.connTable.checkConnectionTable();
        if (Trc.enabled(3)) {
            Trc.complete(Trc.FINE, oRBConnection, CLASS, "getConnection:161");
        }
        return oRBConnection;
    }

    @Override
    public void createListener(int n) {
        this.startListening(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startListening(int n) {
        ServerSocket serverSocket;
        if (Trc.enabled(3)) {
            Trc.begin1(Trc.FINEST, "port=" + n, CLASS, "startListening:180");
        }
        final ConnectionTable connectionTable = this.connTable;
        try {
            int n2 = this.orb.getSocketQueueDepth();
            serverSocket = n2 > 0 ? new ServerSocket(n, n2) : new ServerSocket(n);
            if (Trc.enabled(3)) {
                Trc.info(Trc.FINEST, "new socket=" + serverSocket, CLASS, "startListening:193");
            }
            final String string = "P=" + ORB.orbLoadTime + ":" + "O=" + this.orb.thisInstanceNumber + ":" + "port=" + serverSocket.getLocalPort();
            final boolean bl = this.orb.getServerKeepAlive();
            Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread thread = TCPTransport.this.createListenerThread(connectionTable, serverSocket, TCPTransport.this.acceptTimeout, bl, string);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            thread.start();
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(thread);
            }
            if (Trc.enabled(3)) {
                Trc.info(Trc.FINEST, "new listener=" + thread, CLASS, "startListening:217");
            }
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "startListening:220");
            INTERNAL iNTERNAL = new INTERNAL(exception.toString(), 1229124996, CompletionStatus.COMPLETED_NO);
            iNTERNAL.initCause((Throwable)exception);
            throw iNTERNAL;
        }
        return serverSocket.getLocalPort();
    }

    @Override
    public void destroyListener(int n) {
        Trc.warn((Exception)((Object)new NO_IMPLEMENT("No implementation provided here as the BaseORB never uses the orb.createListener(int port)for creating listeners")), CLASS, "destroyListener:250");
    }

    @Override
    public void initTransports() {
        int n = this.orb.getListenerPort();
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, "listenerPort = " + n, CLASS, "initTransports:260");
        }
        int n2 = this.startListening(n);
        if (this.serverProfile == null) {
            this.serverProfile = ORB.createProfile(this.orb, this.orb.getORBServerHost(), n2);
        }
    }

    @Override
    public Profile getIIOPProfile() {
        if (this.serverProfile == null) {
            this.serverProfile = ORB.createProfile(this.orb, this.orb.getORBServerHost(), this.orb.getListenerPort());
        }
        return this.serverProfile;
    }

    @Override
    public TransportConnection createTransportConnection(Socket socket, Thread thread) {
        return new TCPTransportConnection(this.connTable, socket, this.orb.getReaderPool(), this.tOrb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Set set = this.listeners;
        synchronized (set) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                ((ListenerThread)iterator.next()).setShutdownPending(true);
            }
        }
    }

    @Override
    public ConnectionTable getConnectionTable() {
        return this.connTable;
    }
}

