/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.certrequest.cmscertrequest;

import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.ByteSequenceXorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.FileHeader;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabase;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestDatabaseHashGenerator;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecord;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.RequestRecordHashGeneratorFactory;
import com.ibm.gsk.ikeyman.certrequest.cmscertrequest.VersionNumber;
import com.ibm.gsk.ikeyman.sequence.Sequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequence;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceFactory;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceIterator;
import com.ibm.security.cmskeystore.NonPrintableAsciiPBEKey;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.KeySpec;
import javax.crypto.Mac;
import javax.crypto.spec.PBEKeySpec;

final class RequestDatabaseHashGeneratorFactory {
    private RequestDatabaseHashGeneratorFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static RequestDatabaseHashGenerator newRequestDatabaseHashGenerator(FileHeader header) {
        if (header.getMajorVersionNumber().equals(VersionNumber.THREE)) {
            return new RequestDatabaseHashGeneratorV3Impl();
        }
        return new RequestDatabaseHashGeneratorV4Impl();
    }

    private static final class RequestDatabaseHashGeneratorV3Impl
    implements RequestDatabaseHashGenerator {
        private RequestDatabaseHashGeneratorV3Impl() {
        }

        public ByteSequence generateHash(RequestDatabase database, String password) throws NullPointerException, NoSuchAlgorithmException, IOException {
            if (database == null || password == null) {
                throw new NullPointerException();
            }
            FileHeader header = database.getHeader();
            Sequence<RequestRecord> records = database.getRecords();
            MessageDigest md = MessageDigest.getInstance("MD5");
            ByteSequenceIterator i = header.getMagicNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMajorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMinorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordExpirationTime().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileType().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFixedRecordLength().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getRecordsAllocated().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileLabel().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordHeaderHash().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            ByteSequence pwd = ByteSequenceFactory.newByteSequence(password.getBytes("UTF-8"));
            i = pwd.getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            ByteSequence digest = ByteSequenceFactory.newByteSequence(md.digest());
            for (RequestRecord record : records) {
                ByteSequence recordHash = RequestRecordHashGeneratorFactory.newRequestRecordHashGenerator().generateHash(record, password);
                digest = ByteSequenceXorFactory.newByteSequenceXor().xor(digest, recordHash);
            }
            return digest;
        }
    }

    private static final class RequestDatabaseHashGeneratorV4Impl
    implements RequestDatabaseHashGenerator {
        private RequestDatabaseHashGeneratorV4Impl() {
        }

        public ByteSequence generateHash(RequestDatabase database, String password) throws NullPointerException, NoSuchAlgorithmException, IOException {
            if (database == null || password == null) {
                throw new NullPointerException();
            }
            FileHeader header = database.getHeader();
            Sequence<RequestRecord> records = database.getRecords();
            Mac md = Mac.getInstance("HmacSHA1");
            try {
                md.init((Key)new NonPrintableAsciiPBEKey((KeySpec)new PBEKeySpec(password.toCharArray())));
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            ByteSequenceIterator i = header.getMagicNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMajorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getMinorVersionNumber().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordExpirationTime().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileType().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFixedRecordLength().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getRecordsAllocated().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getFileLabel().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            i = header.getPasswordHeaderHash().getIterator();
            while (i.hasNextByte()) {
                md.update(i.getNextByte());
            }
            for (RequestRecord record : records) {
                i = record.getIterator();
                while (i.hasNextByte()) {
                    md.update(i.getNextByte());
                }
            }
            ByteSequence digest = ByteSequenceFactory.newByteSequence(md.doFinal());
            return digest;
        }
    }
}

