/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.LabelMap;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.CertificateWriter;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.X509Version;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandParameters {
    private final Map<Constants.Parameter, Object> parameters;
    private final DatabaseDescriptorFactory.DatabaseDescriptor sourceDescriptor;
    private final DatabaseDescriptorFactory.DatabaseDescriptor targetDescriptor;

    CommandParameters(Map<Constants.Parameter, Object> parameters, DatabaseDescriptorFactory.DatabaseDescriptor sourceDescriptor, DatabaseDescriptorFactory.DatabaseDescriptor targetDescriptor) {
        this.parameters = parameters;
        this.sourceDescriptor = sourceDescriptor;
        this.targetDescriptor = targetDescriptor;
    }

    private Object getValue(Constants.Parameter param) throws KeyManagerException {
        if (this.parameters.containsKey(param)) {
            return this.parameters.get(param);
        }
        throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.MISSING_PARAMETER, param.toString());
    }

    private void setValue(Constants.Parameter param, Object o) {
        if (this.parameters.containsKey(param)) {
            this.parameters.remove(param);
        }
        this.parameters.put(param, o);
    }

    private static boolean getBoolean(Object value) {
        return (Boolean)value;
    }

    private static int getInt(Object value) {
        return (Integer)value;
    }

    private static String getString(Object value) {
        return (String)value;
    }

    private static List<String> getList(Object value) {
        String fullString = ((String)value).trim();
        String[] tokens = fullString.split("[\\s,]+");
        return Arrays.asList(tokens);
    }

    private static List<String> getCommaList(Object value) {
        String fullString = ((String)value).trim();
        String[] tokens = fullString.split(",");
        ArrayList<String> returnList = new ArrayList<String>();
        for (String token : tokens) {
            returnList.add(token.trim());
        }
        return returnList;
    }

    public boolean isParameterPresent(Constants.Parameter param) {
        return this.parameters.containsKey(param);
    }

    public LabelMap getLabelMap() throws KeyManagerException {
        return (LabelMap)this.getValue(Constants.Parameter.LabelMap);
    }

    public DatabaseDescriptorFactory.DatabaseDescriptor getSourceDescriptor(CallbackHandler handler) throws KeyManagerException {
        if (this.sourceDescriptor != null) {
            return this.sourceDescriptor;
        }
        return DatabaseDescriptorFactory.getDatabaseDescriptor(this, handler, DatabaseDescriptorFactory.DescriptorType.Source);
    }

    public DatabaseDescriptorFactory.DatabaseDescriptor getTargetDescriptor(CallbackHandler handler) throws KeyManagerException {
        if (this.targetDescriptor != null) {
            return this.targetDescriptor;
        }
        return DatabaseDescriptorFactory.getDatabaseDescriptor(this, handler, DatabaseDescriptorFactory.DescriptorType.Target);
    }

    public String getCryptoPassword() throws KeyManagerException {
        if (this.isParameterPresent(Constants.Parameter.SecondPassword)) {
            return CommandParameters.getString(this.getValue(Constants.Parameter.SecondPassword));
        }
        return CommandParameters.getString(this.getValue(Constants.Parameter.Password));
    }

    public String getCrypto() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.Crypto));
    }

    public String getTokenLabel() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.TokenLabel));
    }

    public String getSecondaryDb() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.SecondaryDb));
    }

    public String getSecondaryDbPassword() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.SecondaryDbPassword));
    }

    public Constants.DatabaseType getType() throws KeyManagerException {
        return (Constants.DatabaseType)this.getValue(Constants.Parameter.Type);
    }

    public void setType(Constants.DatabaseType type) {
        this.setValue(Constants.Parameter.Type, type);
    }

    public String getDatabaseName() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.DatabaseName));
    }

    public String getPassword() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.Password));
    }

    public boolean isCa() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants.Parameter.CA));
    }

    public boolean isDefaultCert() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants.Parameter.DefaultCert));
    }

    public DisplayItemFactory.DNItem getDn() throws KeyManagerException {
        return (DisplayItemFactory.DNItem)this.getValue(Constants.Parameter.DN);
    }

    public boolean isEncryption() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants.Parameter.Encryption));
    }

    public int getExpire() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants.Parameter.Expire));
    }

    public int getExpiry() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants.Parameter.Expiry));
    }

    public String getFile() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.File));
    }

    public CertificateWriter.OutputMode getFormat() throws KeyManagerException {
        return (CertificateWriter.OutputMode)this.getValue(Constants.Parameter.Format);
    }

    public String getLabel() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.Label));
    }

    public List<String> getLabels() throws KeyManagerException {
        return CommandParameters.getCommaList(this.getValue(Constants.Parameter.Label));
    }

    public Constants.ListFilter getListWhich() throws KeyManagerException {
        return (Constants.ListFilter)((Object)this.getValue(Constants.Parameter.ListFilter));
    }

    public String getNewLabel() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.NewLabel));
    }

    public String getNewPassword() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.NewPassword));
    }

    public DisplayItemFactory.SanItem getSan() throws KeyManagerException {
        List<String> emailAddresses = null;
        List<String> dnsNames = null;
        List<String> ipAddresses = null;
        if (this.isParameterPresent(Constants.Parameter.SanEmailAddress)) {
            emailAddresses = this.getSanEmailAddress();
        }
        if (this.isParameterPresent(Constants.Parameter.SanDnsName)) {
            dnsNames = this.getSanDnsNames();
        }
        if (this.isParameterPresent(Constants.Parameter.SanIpAddress)) {
            ipAddresses = this.getSanIpAddresses();
        }
        return DisplayItemFactory.getSanItem(emailAddresses, dnsNames, ipAddresses);
    }

    public List<String> getSanDnsNames() throws KeyManagerException {
        return CommandParameters.getList(this.getValue(Constants.Parameter.SanDnsName));
    }

    public List<String> getSanEmailAddress() throws KeyManagerException {
        return CommandParameters.getList(this.getValue(Constants.Parameter.SanEmailAddress));
    }

    public List<String> getSanIpAddresses() throws KeyManagerException {
        return CommandParameters.getList(this.getValue(Constants.Parameter.SanIpAddress));
    }

    public Integer getSerNum() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants.Parameter.SerNum));
    }

    public boolean isShowOid() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants.Parameter.ShowOID));
    }

    public int getSize() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants.Parameter.Size));
    }

    public String getTarget() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.Target));
    }

    public String getTargetPassword() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.TargetPassword));
    }

    public Constants.DatabaseType getTargetType() throws KeyManagerException {
        return (Constants.DatabaseType)this.getValue(Constants.Parameter.TargetType);
    }

    public boolean isTrust() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants.Parameter.Trust));
    }

    public X509Version getX509Ver() throws KeyManagerException {
        return (X509Version)this.getValue(Constants.Parameter.X509Version);
    }

    public Constants.DatabaseType getNewFormat() throws KeyManagerException {
        return (Constants.DatabaseType)this.getValue(Constants.Parameter.NewFormat);
    }

    public Constants.DatabaseType getOldFormat() throws KeyManagerException {
        return (Constants.DatabaseType)this.getValue(Constants.Parameter.OldFormat);
    }

    public int getRelativeSlotNumber() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants.Parameter.RelativeSlotNumber));
    }

    public Constants.DatabaseType getSecondaryDbType() throws KeyManagerException {
        return (Constants.DatabaseType)this.getValue(Constants.Parameter.SecondaryDbType);
    }

    public String getProviderClassName() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.ProviderClass));
    }

    public boolean isStash() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants.Parameter.StashPassword));
    }

    public boolean isPfx() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants.Parameter.Pfx));
    }

    public String getKeyAlgorithm() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.KeyAlgorithm));
    }

    public int getKeySize() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants.Parameter.KeySize));
    }

    public String getKeyAlias() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.KeyAlias));
    }

    public String getLabelRange() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants.Parameter.LabelRange));
    }

    public Constants.SignatureAlgorithms getSigAlg() throws KeyManagerException {
        return (Constants.SignatureAlgorithms)((Object)this.getValue(Constants.Parameter.SigAlg));
    }

    public boolean isPopulate() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants.Parameter.Populate));
    }

    public Vector<ObjectIdentifier> getExtendedKeyUsage() throws KeyManagerException {
        Vector<ObjectIdentifier> retV = new Vector<ObjectIdentifier>();
        try {
            String[] ekuStrings;
            for (String s : ekuStrings = CommandParameters.getString(this.getValue(Constants.Parameter.EKU)).split(",")) {
                if (s.equalsIgnoreCase("anyExtendedKeyUsage") || s.equalsIgnoreCase("any")) {
                    retV.add(new ObjectIdentifier("2.5.29.37.0"));
                    continue;
                }
                if (s.equalsIgnoreCase("serverAuth")) {
                    retV.add(PKIXExtensions.ServerAuth_Id);
                    continue;
                }
                if (s.equalsIgnoreCase("clientAuth")) {
                    retV.add(PKIXExtensions.ClientAuth_Id);
                    continue;
                }
                if (s.equalsIgnoreCase("codeSigning")) {
                    retV.add(PKIXExtensions.CodeSigning_Id);
                    continue;
                }
                if (s.equalsIgnoreCase("emailProtection")) {
                    retV.add(PKIXExtensions.EmailProtection_Id);
                    continue;
                }
                if (s.equalsIgnoreCase("ipsecEndSystem")) {
                    retV.add(PKIXExtensions.IPSecEndSystem_Id);
                    continue;
                }
                if (s.equalsIgnoreCase("ipsecTunnel")) {
                    retV.add(PKIXExtensions.IPSecTunnel_Id);
                    continue;
                }
                if (s.equalsIgnoreCase("ipsecUser")) {
                    retV.add(PKIXExtensions.IPSecUser_Id);
                    continue;
                }
                if (s.equalsIgnoreCase("timeStamping")) {
                    retV.add(PKIXExtensions.TimeStamping_Id);
                    continue;
                }
                if (s.equalsIgnoreCase("OCSPSigning")) {
                    retV.add(new ObjectIdentifier("1.3.6.1.5.5.7.3.9"));
                    continue;
                }
                if (s.equalsIgnoreCase("iKEIntermediate")) {
                    retV.add(new ObjectIdentifier("1.3.6.1.5.5.8.2.2"));
                    continue;
                }
                if (s.equalsIgnoreCase("microsoftSGC")) {
                    retV.add(PKIXExtensions.MicrosoftSGC_Id);
                    continue;
                }
                if (s.equalsIgnoreCase("netscapeSGC")) {
                    retV.add(PKIXExtensions.NetscapeSGC_Id);
                    continue;
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.UNSUPPORTED_ENCODING);
            }
        }
        catch (InternalKeyManagerException e) {
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.UNSUPPORTED_ENCODING);
        }
        return retV;
    }

    public KeyUsageExtension getKeyUsage() throws KeyManagerException {
        KeyUsageExtension keyUsage = null;
        String kuTmp = "";
        try {
            String[] kuStrings = CommandParameters.getString(this.getValue(Constants.Parameter.KU)).split(",");
            keyUsage = new KeyUsageExtension();
            for (String ku : kuStrings) {
                if (ku.equalsIgnoreCase("digitalsignature")) {
                    ku = "digital_signature";
                } else if (ku.equalsIgnoreCase("nonrepudiation")) {
                    ku = "non_repudiation";
                } else if (ku.equalsIgnoreCase("keyencipherment")) {
                    ku = "key_encipherment";
                } else if (ku.equalsIgnoreCase("dataencipherment")) {
                    ku = "data_encipherment";
                } else if (ku.equalsIgnoreCase("keyagreement")) {
                    ku = "key_agreement";
                } else if (ku.equalsIgnoreCase("keycertsign")) {
                    ku = "key_certsign";
                } else if (ku.equalsIgnoreCase("crlsign")) {
                    ku = "crl_sign";
                } else if (ku.equalsIgnoreCase("encipheronly")) {
                    ku = "encipher_only";
                } else if (ku.equalsIgnoreCase("decipheronly")) {
                    ku = "decipher_only";
                }
                kuTmp = ku;
                keyUsage.set(ku, (Object)true);
            }
        }
        catch (InternalKeyManagerException e) {
        }
        catch (IOException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.UNSUPPORTED_ENCODING, Constants.Parameter.KU.toString(), kuTmp);
        }
        return keyUsage;
    }
}

