/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.error;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.messages.ErrorMessages;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.text.MessageFormat;

public class ExceptionInfo {
    private String userMessage;
    private String solutionMessage;
    private String details;

    public ExceptionInfo(KeyManagerException e) {
        this.userMessage = ExceptionInfo.getUserMessage(e);
        this.solutionMessage = ExceptionInfo.getSolutionMessage(e);
        this.details = Messages.getString("ExceptionInfo.ErrorCode") + e.getReason().getErrorCode() + "\n" + ExceptionInfo.getDetails(e);
    }

    public ExceptionInfo(Exception e) {
        this.userMessage = Messages.getString("ExceptionInfo.UnexpectedException");
        this.solutionMessage = ErrorMessages.getString(KeyManagerException.ExceptionReason.Solution.ClearSolution.toString());
        this.details = ExceptionInfo.getDetails(e);
    }

    public ExceptionInfo(Error e) {
        this.userMessage = Messages.getString("ExceptionInfo.UnexpectedException");
        this.solutionMessage = ErrorMessages.getString(KeyManagerException.ExceptionReason.Solution.ClearSolution.toString());
        this.details = ExceptionInfo.getDetails(e);
    }

    private static String getDetails(Throwable e) {
        return Messages.getString("ExceptionInfo.StackTrace") + KeymanUtil.getStackTraceString(e);
    }

    private static String getSolutionMessage(KeyManagerException e) {
        KeyManagerException.ExceptionReason.Solution solution = e.getReason().getSolution();
        if (solution == null) {
            solution = KeyManagerException.ExceptionReason.Solution.ClearSolution;
        }
        return MessageFormat.format(ErrorMessages.getString(solution.toString()), e.getDetails());
    }

    private static String getUserMessage(KeyManagerException e) {
        KeyManagerException.ExceptionReason.UserMessage msg = e.getReason().getUserMessage();
        if (msg == null) {
            return e.getReason().toString();
        }
        return MessageFormat.format(ErrorMessages.getString(msg.toString()), e.getDetails());
    }

    public String getDetails() {
        return this.details;
    }

    public String getSolutionMessage() {
        return this.solutionMessage;
    }

    public String getUserMessage() {
        return this.userMessage;
    }
}

