/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.LabelMap;
import com.ibm.gsk.ikeyman.command.gui.KeymanView;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.CenteredDialog;
import com.ibm.gsk.ikeyman.gui.ChangeLabelsDialog;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.controls.MnemonicLabel;
import com.ibm.gsk.ikeyman.gui.panels.OKResetCancelButtonPanel;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeySelectDialog
extends CenteredDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JScrollPane jScrollPane = null;
    private JList keyList = null;
    private OKResetCancelButtonPanel buttonPanel = null;
    private Collection<? extends Entry> keyStoreEntries;
    private boolean allowMultiSelect;
    private String[] selectedLabels = null;

    protected KeySelectDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    public KeySelectDialog(Frame owner, String fileName, Collection<? extends Entry> keyStoreEntries, boolean allowMultiSelect) {
        super(owner, MessageFormat.format(Messages.getString("GUI.Title.KeySelect"), fileName));
        this.keyStoreEntries = keyStoreEntries;
        this.allowMultiSelect = allowMultiSelect;
        this.initialize();
    }

    public static String getSingleSelection(Frame owner, String fileName, Collection<? extends Entry> keyStoreEntries) throws CancelledException {
        KeySelectDialog ksd = new KeySelectDialog(owner, fileName, keyStoreEntries, false);
        ksd.setVisible(true);
        if (ksd.getDialogResult() == GUIConstants.DialogResult.OK) {
            return ksd.getSelectedLabels()[0];
        }
        throw new CancelledException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LabelMap getLabelMap(KeymanView view, Frame owner, String fileName, Collection<? extends Entry> keyStoreEntries, boolean singleModeEnabled) throws CancelledException, KeyManagerException {
        String[] labels;
        if (keyStoreEntries.size() > 1) {
            KeySelectDialog ksd = new KeySelectDialog(owner, fileName, keyStoreEntries, true);
            ksd.setVisible(true);
            if (ksd.getDialogResult() != GUIConstants.DialogResult.OK) throw new CancelledException();
            labels = ksd.getSelectedLabels();
        } else {
            if (keyStoreEntries.size() == 0) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.SOURCE_DB_IS_EMPTY);
            }
            String label = keyStoreEntries.toArray(new Entry[0])[0].getLabel();
            labels = new String[]{label};
        }
        if (!singleModeEnabled || labels.length != 1) return ChangeLabelsDialog.getLabelMap(owner, labels);
        String newLabel = view.getInput(Messages.getString("Label.EnterLabelForCert"), Messages.getString("GUI.Title.EnterLabel"), "");
        LabelMap labelMap = new LabelMap();
        labelMap.add(labels[0], newLabel);
        return labelMap;
    }

    public static LabelMap getLabelMap(Frame owner, LabelMap initialValues) {
        return ChangeLabelsDialog.getLabelMap(owner, initialValues);
    }

    private String[] getSelectedLabels() {
        return this.selectedLabels;
    }

    private void initialize() {
        this.setSize(549, 533);
        this.setModal(true);
        this.setResizable(false);
        this.setContentPane(this.getJContentPane());
        this.getRootPane().setDefaultButton(this.getButtonPanel().getOkBtn());
        this.pack();
        this.setName(ControlNames.KeySelectDialog.toString());
        this.centerToParent();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.gridheight = 2;
            gridBagConstraints4.gridwidth = 1;
            gridBagConstraints4.anchor = 11;
            gridBagConstraints4.insets = new Insets(10, 20, 0, 5);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.insets = new Insets(0, 5, 5, 10);
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 5, 10, 0);
            gridBagConstraints.gridx = 0;
            this.jLabel = new MnemonicLabel();
            if (this.allowMultiSelect) {
                this.jLabel.setText(Messages.getStringWithMnemonics("Label.SelectKeys"));
            } else {
                this.jLabel.setText(Messages.getStringWithMnemonics("Label.SelectKey"));
            }
            this.jLabel.setName(ControlNames.KeySelectDialogSelectLabel.toString());
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.getJScrollPane(), gridBagConstraints1);
            this.jContentPane.add((Component)this.getButtonPanel(), gridBagConstraints4);
            this.jLabel.setLabelFor(this.getKeyList());
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getKeyList());
        }
        return this.jScrollPane;
    }

    private JList getKeyList() {
        if (this.keyList == null) {
            this.keyList = this.keyStoreEntries != null ? new JList<Entry>(this.keyStoreEntries.toArray(new Entry[0])) : new JList();
            if (this.allowMultiSelect) {
                this.keyList.setSelectionMode(2);
            } else {
                this.keyList.setSelectionMode(0);
            }
            this.keyList.setVisibleRowCount(20);
        }
        return this.keyList;
    }

    private OKResetCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new OKResetCancelButtonPanel(OKResetCancelButtonPanel.Orientation.Vertical, GUIConstants.Actions.OK, GUIConstants.Actions.Cancel);
            this.buttonPanel.addActionListener(this);
        }
        return this.buttonPanel;
    }

    @Override
    protected void okHandler() {
        if (this.keyList.getSelectedValues().length > 0) {
            Object[] selectedValues = this.keyList.getSelectedValues();
            this.selectedLabels = new String[selectedValues.length];
            for (int i = 0; i < selectedValues.length; ++i) {
                this.selectedLabels[i] = ((Entry)selectedValues[i]).getLabel();
            }
            this.setDialogResult(GUIConstants.DialogResult.OK);
            this.setVisible(false);
        }
    }

    @Override
    protected void resetHandler() {
    }
}

