/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.panels.ExportImportRadioPanel;
import com.ibm.gsk.ikeyman.gui.panels.FileNamePanel;
import com.ibm.gsk.ikeyman.gui.panels.KeymanFileFilter;
import com.ibm.gsk.ikeyman.io.CertificateWriter;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanSettings;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.filechooser.FileFilter;

public class FileNamePanelFactory {
    public static FileNamePanel newPanel(PanelType type, GUIConstants.DialogMode mode, FileName databaseName) {
        switch (type) {
            case Database: {
                return new DatabaseFileNamePanel(mode, databaseName);
            }
            case Certificate: {
                return new CertificateFileNamePanel(mode, databaseName);
            }
            case ComboLess: {
                return new CombolessFileNamePanel(mode, databaseName, Constants.Parameter.Target);
            }
            case ExportImport: {
                return new ExportImportFileNamePanel(mode, databaseName);
            }
            case Import: {
                return new PersonalCertImportFileNamePanel(mode, databaseName);
            }
            case AddCertificate: {
                return new AddCertFileNamePanel(mode, databaseName);
            }
            case SecretKey: {
                return new SecretKeyFileNamePanel(mode, databaseName);
            }
        }
        throw new RuntimeException("Invalid panel type.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractImportFileNamePanel
    extends FileNamePanel {
        private static Map<Object, String> defaultLocations = new HashMap<Object, String>();

        protected AbstractImportFileNamePanel(GUIConstants.DialogMode mode, FileName databaseName) {
            super(mode, databaseName);
        }

        @Override
        protected String getComboLabel() {
            return Messages.getStringWithMnemonics("Label.KeyFileType");
        }

        @Override
        protected String getFileNameLabel() {
            return Messages.getStringWithMnemonics("Label.FileName");
        }

        protected Constants.DatabaseType getType() {
            return (Constants.DatabaseType)this.getComboValue();
        }

        @Override
        public ParameterMap getParameters() throws KeyManagerException {
            ParameterMap params = new ParameterMap();
            params.put(Constants.Parameter.DatabaseName, this.getFile().getAbsolutePath());
            params.put(Constants.Parameter.Type, this.getType());
            params.put(Constants.CommandType.ImportCertRename);
            return params;
        }

        @Override
        protected FileFilter getFileFilter() {
            return new KeymanFileFilter(KeymanFileFilter.FilterType.forDatabaseType(this.getType()));
        }

        @Override
        protected Map<Object, String> getDefaultLocationMap() {
            return defaultLocations;
        }

        @Override
        protected String getComboTooltip() {
            return Messages.getString("Tooltip.KeyFileType");
        }

        @Override
        protected String getFileNameTooltip() {
            return Messages.getString("Tooltip.FileName");
        }
    }

    private static class AddCertFileNamePanel
    extends CombolessFileNamePanel {
        private static final String DEFAULT_FILE_NAME = KeymanSettings.Setting.DefaultCertificateNameArm.getString();

        protected AddCertFileNamePanel(GUIConstants.DialogMode mode, FileName databaseName) {
            super(mode, databaseName, Constants.Parameter.File);
        }

        protected FileName getDefaultFileName() {
            String location = this.getDefaultLocation();
            return new FileName(new File(location, DEFAULT_FILE_NAME));
        }

        protected FileFilter getFileFilter() {
            return new KeymanFileFilter(KeymanFileFilter.FilterType.Certificate);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CertificateFileNamePanel
    extends FileNamePanel {
        private static Map<Object, String> defaultLocations = new HashMap<Object, String>();

        protected CertificateFileNamePanel(GUIConstants.DialogMode mode, FileName databaseName) {
            super(mode, databaseName);
        }

        @Override
        protected String getComboLabel() {
            return Messages.getStringWithMnemonics("Label.DataType");
        }

        @Override
        protected Object[] getComboValues() {
            return CertificateWriter.OutputMode.values();
        }

        @Override
        protected String getFileNameLabel() {
            return Messages.getStringWithMnemonics("Label.CertFileName");
        }

        @Override
        public ParameterMap getParameters() throws KeyManagerException {
            ParameterMap params = new ParameterMap();
            params.put(this.getMode() == GUIConstants.DialogMode.Open ? Constants.Parameter.File : Constants.Parameter.Target, this.getFile().getAbsolutePath());
            params.put(Constants.Parameter.Format, this.getEncoding());
            return params;
        }

        private CertificateWriter.OutputMode getEncoding() {
            return (CertificateWriter.OutputMode)this.getComboValue();
        }

        @Override
        protected FileFilter getFileFilter() {
            switch ((CertificateWriter.OutputMode)this.getComboValue()) {
                case Base64EncodedAscii: {
                    return new KeymanFileFilter(KeymanFileFilter.FilterType.Base64EncodedAscii);
                }
                case BinaryDER: {
                    return new KeymanFileFilter(KeymanFileFilter.FilterType.BinaryDer);
                }
            }
            return null;
        }

        @Override
        protected Map<Object, String> getDefaultLocationMap() {
            return defaultLocations;
        }

        @Override
        protected String getComboTooltip() {
            return Messages.getString("Tooltip.DataType");
        }

        @Override
        protected String getFileNameTooltip() {
            return Messages.getString("Tooltip.FileName");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CombolessFileNamePanel
    extends FileNamePanel {
        private static final String DEFAULT_FILE_NAME = KeymanSettings.Setting.DefaultCertReqName.getString();
        private static String defaultLocation = null;
        private Constants.Parameter param;

        protected CombolessFileNamePanel(GUIConstants.DialogMode mode, FileName databaseName, Constants.Parameter param) {
            super(mode, databaseName);
            this.param = param;
        }

        @Override
        protected String getComboLabel() {
            return null;
        }

        protected String[] getComboValues() {
            return null;
        }

        @Override
        protected String getFileNameLabel() {
            return Messages.getStringWithMnemonics("Label.FileName");
        }

        @Override
        public ParameterMap getParameters() throws KeyManagerException {
            ParameterMap params = new ParameterMap();
            params.put(this.param, this.getFile().getAbsolutePath());
            return params;
        }

        @Override
        protected JLabel getComboLabelControl() {
            return null;
        }

        @Override
        protected FileFilter getFileFilter() {
            return new KeymanFileFilter(KeymanFileFilter.FilterType.CertRequest);
        }

        protected String getDefaultLocation() {
            if (defaultLocation == null) {
                return this.getDatabaseName().getDirectory();
            }
            return defaultLocation;
        }

        @Override
        protected FileName getDefaultFileName() {
            String location = this.getDefaultLocation();
            return new FileName(new File(location, DEFAULT_FILE_NAME));
        }

        @Override
        protected Map<Object, String> getDefaultLocationMap() {
            throw new RuntimeException("Method CombolessFileNamePanel.getDefaultLocationMap not supported.");
        }

        @Override
        public void updateDefaultLocation() {
            defaultLocation = this.getFile().getParent();
        }

        @Override
        protected String getComboTooltip() {
            return null;
        }

        @Override
        protected String getFileNameTooltip() {
            return Messages.getString("Tooltip.FileName");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DatabaseFileNamePanel
    extends FileNamePanel {
        private static Map<Object, String> defaultLocations = new HashMap<Object, String>();

        private static void populateDefault(KeymanSettings.Setting setting, Constants.DatabaseType dbType) {
            if (setting.getString() != null) {
                defaultLocations.put(dbType, setting.getString());
            }
        }

        protected DatabaseFileNamePanel(GUIConstants.DialogMode mode, FileName databaseName) {
            super(mode, databaseName);
        }

        @Override
        protected String getComboLabel() {
            return Messages.getStringWithMnemonics("Label.KeyDatabaseType");
        }

        @Override
        protected String getFileNameLabel() {
            return Messages.getStringWithMnemonics("Label.FileName");
        }

        @Override
        protected Object[] getComboValues() {
            if (this.getMode() == GUIConstants.DialogMode.New) {
                return Constants.DatabaseType.values(Constants.DatabaseType.SupportType.Creation);
            }
            return Constants.DatabaseType.values(Constants.DatabaseType.SupportType.Opening);
        }

        protected Constants.DatabaseType getType() {
            return (Constants.DatabaseType)this.getComboValue();
        }

        @Override
        public ParameterMap getParameters() throws KeyManagerException {
            ParameterMap params = new ParameterMap();
            if (this.getType() == Constants.DatabaseType.PKCS11Direct) {
                params.put(Constants.Parameter.Crypto, this.getFile().getAbsolutePath());
            } else if (this.getType() == Constants.DatabaseType.PKCS11Config) {
                params.put(Constants.Parameter.Crypto, "");
            } else {
                params.put(Constants.Parameter.DatabaseName, this.getFile().getAbsolutePath());
                params.put(Constants.Parameter.Type, this.getType());
            }
            return params;
        }

        @Override
        protected FileFilter getFileFilter() {
            return new KeymanFileFilter(KeymanFileFilter.FilterType.forDatabaseType(this.getType()));
        }

        @Override
        protected Map<Object, String> getDefaultLocationMap() {
            return defaultLocations;
        }

        @Override
        protected String getComboTooltip() {
            return Messages.getString("Tooltip.DbType");
        }

        @Override
        protected String getFileNameTooltip() {
            return Messages.getString("Tooltip.DbFileName");
        }

        @Override
        protected boolean fileNameFieldEnabled() {
            return this.fieldsEnabled();
        }

        @Override
        protected FileName getDefaultFileName() {
            if (this.getType() == Constants.DatabaseType.PKCS11Config || this.getType() == Constants.DatabaseType.MSCapi) {
                return null;
            }
            return super.getDefaultFileName();
        }

        @Override
        protected boolean locationFieldEnabled() {
            return this.fieldsEnabled();
        }

        @Override
        protected boolean browseButtonEnabled() {
            return this.fieldsEnabled();
        }

        private boolean fieldsEnabled() {
            return this.getType() != Constants.DatabaseType.PKCS11Config && this.getType() != Constants.DatabaseType.MSCapi;
        }

        @Override
        public void updateDefaultLocation() {
            if (this.getType().useLastOpenedLocation()) {
                super.updateDefaultLocation();
            }
        }

        static {
            DatabaseFileNamePanel.populateDefault(KeymanSettings.Setting.DefaultCMSFileLocation, Constants.DatabaseType.CMS);
            DatabaseFileNamePanel.populateDefault(KeymanSettings.Setting.DefaultJKSFileLocation, Constants.DatabaseType.JKS);
            DatabaseFileNamePanel.populateDefault(KeymanSettings.Setting.DefaultPKCS12FileLocation, Constants.DatabaseType.PKCS12);
            DatabaseFileNamePanel.populateDefault(KeymanSettings.Setting.DefaultPKCS12FileLocation, Constants.DatabaseType.PKCS12S2);
            DatabaseFileNamePanel.populateDefault(KeymanSettings.Setting.DefaultJCEKSFileLocation, Constants.DatabaseType.JCEKS);
            KeymanSettings.Setting cryptoSetting = KeymanSettings.Setting.DefaultCryptoModule;
            if (!cryptoSetting.getString().equals(cryptoSetting.getDefault())) {
                defaultLocations.put(Constants.DatabaseType.PKCS11Direct, new FileName(cryptoSetting.getString()).getDirectory());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExportImportFileNamePanel
    extends FileNamePanel {
        private ExportImportRadioPanel exportImportPanel;
        private static Map<Object, String> defaultLocations = new HashMap<Object, String>();

        protected ExportImportFileNamePanel(GUIConstants.DialogMode mode, FileName databaseName) {
            super(mode, databaseName);
        }

        @Override
        protected String getComboLabel() {
            return Messages.getStringWithMnemonics("Label.KeyFileType");
        }

        @Override
        protected Object[] getComboValues() {
            return Constants.DatabaseType.values(Constants.DatabaseType.SupportType.Opening);
        }

        @Override
        protected String getFileNameLabel() {
            return Messages.getStringWithMnemonics("Label.FileName");
        }

        @Override
        protected GUIConstants.DialogMode getMode() {
            return this.exportImportPanel.isExportSelected() ? GUIConstants.DialogMode.New : GUIConstants.DialogMode.Open;
        }

        @Override
        public ParameterMap getParameters() throws KeyManagerException {
            ParameterMap map = new ParameterMap();
            if (this.exportImportPanel.isExportSelected()) {
                map.put(Constants.Parameter.Target, this.getFile().getAbsolutePath());
                map.put(Constants.Parameter.TargetType, this.getType());
                map.put(Constants.CommandType.ExportCert);
            } else {
                map.put(Constants.Parameter.DatabaseName, this.getFile().getAbsolutePath());
                map.put(Constants.Parameter.Type, this.getType());
                map.put(Constants.CommandType.ImportCertRename);
            }
            return map;
        }

        protected Constants.DatabaseType getType() {
            return (Constants.DatabaseType)this.getComboValue();
        }

        @Override
        protected void extraInitialize() {
            this.add((Component)this.getExportImportPanel(), "North");
        }

        private ExportImportRadioPanel getExportImportPanel() {
            if (this.exportImportPanel == null) {
                this.exportImportPanel = new ExportImportRadioPanel();
            }
            return this.exportImportPanel;
        }

        @Override
        protected FileFilter getFileFilter() {
            return new KeymanFileFilter(KeymanFileFilter.FilterType.forDatabaseType(this.getType()));
        }

        @Override
        protected Map<Object, String> getDefaultLocationMap() {
            return defaultLocations;
        }

        @Override
        protected String getComboTooltip() {
            return Messages.getString("Tooltip.KeyFileType");
        }

        @Override
        protected String getFileNameTooltip() {
            return Messages.getString("Tooltip.FileName");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PanelType {
        Database,
        Certificate,
        ComboLess,
        ExportImport,
        Import,
        AddCertificate,
        SecretKey;

    }

    private static class PersonalCertImportFileNamePanel
    extends AbstractImportFileNamePanel {
        protected PersonalCertImportFileNamePanel(GUIConstants.DialogMode mode, FileName databaseName) {
            super(mode, databaseName);
        }

        protected Object[] getComboValues() {
            return Constants.DatabaseType.values(Constants.DatabaseType.SupportType.KeyImport);
        }
    }

    private static class SecretKeyFileNamePanel
    extends CombolessFileNamePanel {
        private static final String DEFAULT_FILE_NAME = "secKey.key";

        protected SecretKeyFileNamePanel(GUIConstants.DialogMode mode, FileName databaseName) {
            super(mode, databaseName, Constants.Parameter.File);
        }

        protected FileName getDefaultFileName() {
            String location = this.getDefaultLocation();
            return new FileName(new File(location, DEFAULT_FILE_NAME));
        }

        protected FileFilter getFileFilter() {
            return new KeymanFileFilter(KeymanFileFilter.FilterType.SecretKey);
        }
    }
}

