/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.FileName;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class KeymanFileFilter
extends FileFilter {
    private List<String> extensions;
    private String description;

    public KeymanFileFilter(FilterType type) {
        this.extensions = type.getExtensions();
        this.description = type.getDescription();
    }

    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return true;
        }
        FileName name = new FileName(pathname);
        return this.extensions.contains(name.getFileExtension()) || this.extensions.contains(".*");
    }

    public String getDescription() {
        return this.description;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FilterType {
        DatabaseCMS(new String[]{Constants.DatabaseType.CMS.getDefaultExtension()}, Messages.getString("Label.KeyDatabaseType")),
        DatabaseJKS(new String[]{Constants.DatabaseType.JKS.getDefaultExtension()}, Messages.getString("Label.KeyDatabaseType")),
        DatabaseJCEKS(new String[]{Constants.DatabaseType.JCEKS.getDefaultExtension()}, Messages.getString("Label.KeyDatabaseType")),
        DatabasePKCS12(new String[]{Constants.DatabaseType.PKCS12.getDefaultExtension()}, Messages.getString("Label.KeyDatabaseType")),
        DatabasePKCS12S2(new String[]{Constants.DatabaseType.PKCS12S2.getDefaultExtension()}, Messages.getString("Label.KeyDatabaseType")),
        DatabasePKCS11(new String[]{Constants.DatabaseType.PKCS11Direct.getDefaultExtension()}, Messages.getString("Label.KeyDatabaseType")),
        DatabaseDefault(new String[]{".*"}, Messages.getString("Label.KeyDatabaseType")),
        Base64EncodedAscii(new String[]{".cer", ".arm"}, Messages.getString("Label.KeyFileType")),
        BinaryDer(new String[]{".ber", ".der"}, Messages.getString("Label.KeyFileType")),
        CertRequest(new String[]{".arm"}, Messages.getString("Label.KeyFileType")),
        SecretKey(new String[]{".key"}, Messages.getString("Label.KeyFileType")),
        Certificate(new String[]{".cer", ".arm", ".ber", ".der", ".eml"}, Messages.getString("Label.KeyFileType"));

        private String[] extensions;
        private String description;

        private FilterType(String[] extensions, String description) {
            this.extensions = extensions;
            StringBuffer buff = new StringBuffer(description);
            buff.append(" (");
            for (int i = 0; i < extensions.length; ++i) {
                String ext = extensions[i];
                buff.append("*").append(ext);
                if (i >= extensions.length - 1) continue;
                buff.append(", ");
            }
            buff.append(")");
            this.description = buff.toString();
        }

        private List<String> getExtensions() {
            return Arrays.asList(this.extensions);
        }

        private String getDescription() {
            return this.description;
        }

        public static FilterType forDatabaseType(Constants.DatabaseType type) {
            switch (type) {
                case CMS: {
                    return DatabaseCMS;
                }
                case JCEKS: {
                    return DatabaseJCEKS;
                }
                case JKS: {
                    return DatabaseJKS;
                }
                case PKCS12: {
                    return DatabasePKCS12;
                }
                case PKCS12S2: {
                    return DatabasePKCS12S2;
                }
                case PKCS11Direct: {
                    return DatabasePKCS11;
                }
            }
            return DatabaseDefault;
        }
    }
}

