/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui.panels;

import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.controls.ButtonFactory;
import com.ibm.gsk.ikeyman.gui.panels.KeymanPanel;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;

public class OKResetCancelButtonPanel
extends KeymanPanel {
    private JButton okBtn = null;
    private JButton resetBtn = null;
    private JButton cancelBtn = null;
    private List<GUIConstants.Actions> actions;
    private Orientation orientation;

    public OKResetCancelButtonPanel(GUIConstants.Actions ... actions) {
        this(Orientation.Horizontal, actions);
    }

    public OKResetCancelButtonPanel(Orientation orientation, GUIConstants.Actions ... actions) {
        this.actions = Arrays.asList(actions);
        this.orientation = orientation;
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(274, 80));
        this.setLayout(this.orientation == Orientation.Horizontal ? new GridLayout(1, 3, 10, 0) : new GridLayout(3, 1, 0, 10));
        this.addButton(this.getOkBtn());
        this.addButton(this.getResetBtn());
        this.addButton(this.getCancelBtn());
    }

    private void addButton(JButton button) {
        if (button != null) {
            this.add(button);
        }
    }

    public JButton getOkBtn() {
        if (this.okBtn == null && this.actions.contains((Object)GUIConstants.Actions.OK)) {
            this.okBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.OK"), ControlNames.OKResetCancelButtonPanelOKButton);
            this.okBtn.setActionCommand(GUIConstants.Actions.OK.toString());
            this.okBtn.addActionListener(this);
        }
        return this.okBtn;
    }

    private JButton getResetBtn() {
        if (this.resetBtn == null && this.actions.contains((Object)GUIConstants.Actions.Reset)) {
            this.resetBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.Reset"), ControlNames.OKResetCancelButtonPanelResetButton);
            this.resetBtn.setActionCommand(GUIConstants.Actions.Reset.toString());
            this.resetBtn.addActionListener(this);
        }
        return this.resetBtn;
    }

    private JButton getCancelBtn() {
        if (this.cancelBtn == null && this.actions.contains((Object)GUIConstants.Actions.Cancel)) {
            this.cancelBtn = ButtonFactory.getButton(Messages.getStringWithMnemonics("Label.Cancel"), ControlNames.OKResetCancelButtonPanelCancelButton);
            this.cancelBtn.setActionCommand(GUIConstants.Actions.Cancel.toString());
            this.cancelBtn.addActionListener(this);
        }
        return this.cancelBtn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        Horizontal,
        Vertical;

    }
}

