/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAKeyPairParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAKeyPairParameterSpec;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.util.AliasRange;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class KeyCreatorFactory {
    public static KeyCreator getDefaultKeyCreator(String provider) {
        return new DefaultKeyCreator(provider);
    }

    public static KeyCreator getPKCS11KeyCreator(String provider) {
        return new PKCS11KeyCreator(provider);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractKeyCreator
    implements KeyCreator {
        private String provider;

        public AbstractKeyCreator(String provider) {
            this.provider = provider;
        }

        @Override
        public String getProvider() {
            return this.provider;
        }

        @Override
        public KeyPair generateKeyPair(CommandParameters param) throws KeyManagerException {
            try {
                KeyPair kp;
                PublicKey pk;
                int actualSize;
                SecureRandom secureRandom = SecureRandom.getInstance("IBMSecureRandom", this.provider);
                secureRandom.setSeed((long)Math.random());
                String kt = KeymanUtil.getKeyType(param.getSigAlg().toString());
                int size = param.getSize();
                KeyPairGenerator keyPairGenerator = this.getKeyPairGenerator(kt, param.getLabel(), size, secureRandom);
                int retryCount = kt.equals("RSA") || kt.equals("DSA") ? 5 : 0;
                while ((actualSize = KeymanUtil.computeKeySize(pk = (kp = keyPairGenerator.generateKeyPair()).getPublic())) < size && retryCount-- > 0) {
                }
                if (actualSize < size && kt.equals("RSA")) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_KEY_SIZE, (Throwable)new Exception(), actualSize + "", kt);
                }
                return kp;
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
            }
            catch (NoSuchProviderException e) {
                throw new InternalKeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, this.provider);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ALGORITHM_PARAMETERS, (Throwable)e);
            }
            catch (InvalidParameterException e) {
                if (e.getMessage() != null && e.getMessage().startsWith("Modulus size")) {
                    throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_KEY_SIZE_FOR_ALGORITHM, (Throwable)e, param.getSize() + "", KeymanUtil.getKeyType());
                }
                throw new KeyManagerException(KeyManagerException.ExceptionReason.RESTRICTED_POLICY_FILES, (Throwable)e);
            }
        }

        @Override
        public Map<String, SecretKey> generateSecretKeys(CommandParameters param) throws KeyManagerException {
            try {
                HashMap<String, SecretKey> returnMap = new HashMap<String, SecretKey>();
                SecureRandom secureRandom = SecureRandom.getInstance("IBMSecureRandom", this.provider);
                secureRandom.setSeed((long)Math.random());
                if (param.isParameterPresent(Constants.Parameter.Label)) {
                    KeyGenerator generator = this.getKeyGenerator(param.getKeyAlgorithm(), param.getLabel(), param.getKeySize(), secureRandom);
                    SecretKey key = generator.generateKey();
                    returnMap.put(param.getLabel(), key);
                } else {
                    AliasRange range = new AliasRange(param.getLabelRange());
                    range.validate(AliasRange.ValidationMode.NORMAL);
                    Enumeration<String> aliases = range.getAliasEnumerator();
                    while (aliases.hasMoreElements()) {
                        String alias = aliases.nextElement();
                        KeyGenerator generator = this.getKeyGenerator(param.getKeyAlgorithm(), alias, param.getKeySize(), secureRandom);
                        SecretKey key = generator.generateKey();
                        returnMap.put(alias, key);
                    }
                }
                return returnMap;
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_ALGORITHM, (Throwable)e, e.getMessage());
            }
            catch (InvalidParameterException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ALGORITHM_PARAMETER, (Throwable)e, e.getMessage());
            }
            catch (NoSuchProviderException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.NO_SUCH_PROVIDER, (Throwable)e, this.provider);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_ALGORITHM_PARAMETER, (Throwable)e);
            }
        }

        protected abstract KeyPairGenerator getKeyPairGenerator(String var1, String var2, int var3, SecureRandom var4) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyManagerException, NoSuchProviderException;

        protected abstract KeyGenerator getKeyGenerator(String var1, String var2, int var3, SecureRandom var4) throws KeyManagerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException;
    }

    private static class DefaultKeyCreator
    extends AbstractKeyCreator {
        private static final Map<SecretKeyTypes, Integer[]> keySizes = new HashMap<SecretKeyTypes, Integer[]>();

        public DefaultKeyCreator(String provider) {
            super(provider);
        }

        protected KeyPairGenerator getKeyPairGenerator(String kt, String label, int size, SecureRandom secureRandom) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyManagerException, NoSuchProviderException {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(kt, this.getProvider());
            keyPairGenerator.initialize(size, secureRandom);
            return keyPairGenerator;
        }

        protected KeyGenerator getKeyGenerator(String keyAlg, String label, int keySize, SecureRandom secureRandom) throws KeyManagerException, NoSuchAlgorithmException, NoSuchProviderException {
            KeyGenerator generator = KeyGenerator.getInstance(keyAlg, this.getProvider());
            generator.init(keySize, secureRandom);
            return generator;
        }

        public Integer[] getKeySizes(SecretKeyTypes keyType) {
            return keySizes.get((Object)keyType);
        }

        static {
            keySizes.put(SecretKeyTypes.AES, new Integer[]{128, 192, 256});
            keySizes.put(SecretKeyTypes.DES, new Integer[]{56});
            keySizes.put(SecretKeyTypes.DESede, new Integer[]{112, 168});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface KeyCreator {
        public KeyPair generateKeyPair(CommandParameters var1) throws KeyManagerException;

        public Map<String, SecretKey> generateSecretKeys(CommandParameters var1) throws KeyManagerException;

        public Integer[] getKeySizes(SecretKeyTypes var1);

        public String getProvider();
    }

    private static class PKCS11KeyCreator
    extends AbstractKeyCreator {
        private static final int BITS_PER_BYTE = 8;
        private static final boolean TOKEN = true;
        private static final boolean SENSITIVE = true;
        private static final boolean SIGNING = true;
        private static final boolean ENCRYPTION = true;
        private static final boolean WRAPPING = true;
        private static final boolean EXTRACTABLE_PRIVATE = false;
        private static final boolean EXTRACTABLE_SECRET = true;
        private static final Map<SecretKeyTypes, Integer[]> keySizes = new HashMap<SecretKeyTypes, Integer[]>();

        public PKCS11KeyCreator(String provider) {
            super(provider);
        }

        protected KeyGenerator getKeyGenerator(String keyAlg, String label, int keySize, SecureRandom secureRandom) throws KeyManagerException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
            KeyGenerator keyGen = KeyGenerator.getInstance(keyAlg, this.getProvider());
            GeneralPKCS11KeyParameterSpec spec = new GeneralPKCS11KeyParameterSpec(label, label, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), keySize / 8, keyAlg);
            keyGen.init((AlgorithmParameterSpec)spec, secureRandom);
            return keyGen;
        }

        protected KeyPairGenerator getKeyPairGenerator(String sigAlg, String label, int size, SecureRandom secureRandom) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyManagerException, NoSuchProviderException {
            String keyType = KeymanUtil.getKeyType(sigAlg);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(keyType, this.getProvider());
            Object spec = keyType.equals("DSA") ? new PKCS11DSAKeyPairParameterSpec(size, label, null, label, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false), null) : new PKCS11RSAKeyPairParameterSpec(size, label, null, label, Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
            keyPairGenerator.initialize((AlgorithmParameterSpec)spec, secureRandom);
            return keyPairGenerator;
        }

        public Integer[] getKeySizes(SecretKeyTypes keyType) {
            return keySizes.get((Object)keyType);
        }

        static {
            keySizes.put(SecretKeyTypes.AES, new Integer[]{128, 192, 256});
            keySizes.put(SecretKeyTypes.DES, new Integer[]{64});
            keySizes.put(SecretKeyTypes.DESede, new Integer[]{192});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SecretKeyTypes {
        AES,
        DES,
        DESede;

    }
}

