/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.Details;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.gsk.ikeyman.util.TypeDisplayerFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractEntry
implements Entry {
    private static final List<Class<? extends Entry>> sortOrder = new ArrayList<Class<? extends Entry>>();
    private String label;
    private TypeDisplayerFactory.TypeDisplayer<Entry> displayer = null;

    public AbstractEntry(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setDisplayer(TypeDisplayerFactory.TypeDisplayer<Entry> displayer) {
        this.displayer = displayer;
    }

    public TypeDisplayerFactory.TypeDisplayer<Entry> getDisplayer() {
        return this.displayer;
    }

    @Override
    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    @Override
    public String get(Details.DetailIdentifier id) throws KeyManagerException {
        switch (id) {
            case Label: {
                return this.label;
            }
        }
        return "";
    }

    @Override
    public String toString() {
        if (this.displayer != null) {
            return this.displayer.toString(this);
        }
        return EntryFactory.getClassDisplayer().toString(this);
    }

    @Override
    public int compareTo(Entry o) {
        int index1 = -1;
        int index2 = -1;
        for (int i = 0; i < sortOrder.size(); ++i) {
            if (index1 == -1 && sortOrder.get(i).isInstance(this)) {
                index1 = i;
            }
            if (index2 != -1 || !sortOrder.get(i).isInstance(o)) continue;
            index2 = i;
        }
        if (index1 != index2) {
            return index1 < index2 ? -1 : 1;
        }
        return this.compareSameType(o);
    }

    protected int compareSameType(Entry o) {
        return KeymanUtil.compareStrings(this.getLabel(), o.getLabel());
    }

    static {
        sortOrder.add(CertificateItem.class);
        sortOrder.add(CertificateKeyItem.class);
        sortOrder.add(SecretKeyItem.class);
        sortOrder.add(CertificateRequestItem.class);
        sortOrder.add(Entry.class);
    }
}

