/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore.entry;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.io.CertificateWriter;
import com.ibm.gsk.ikeyman.keystore.entry.AbstractEntry;
import com.ibm.gsk.ikeyman.keystore.entry.ByteArray;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.X509Version;
import com.ibm.gsk.ikeyman.keystore.ext.Details;
import com.ibm.gsk.ikeyman.keystore.ext.KeymanTree;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import java.io.File;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CertificateItemImpl
extends AbstractEntry
implements CertificateItem {
    private Integer keySize = null;
    private DisplayItemFactory.TreeDisplayItem version = null;
    private ByteArray serialNumber = null;
    private DisplayItemFactory.DNItem issuerDN = null;
    private DisplayItemFactory.DNItem subjectDN = null;
    private DisplayItemFactory.ValidityItem validity = null;
    private DisplayItemFactory.DisplayItem fingerprint = null;
    private DisplayItemFactory.AlgorithmItem publicKeyAlgorithm = null;
    private List<DisplayItemFactory.ExtensionItem> extensions = null;
    private DisplayItemFactory.AlgorithmItem signatureAlgorithm = null;
    private ByteArray signature = null;
    private DisplayItemFactory.SanItem san = null;
    private Vector<ObjectIdentifier> extendedKeyUsageV = null;
    private KeyUsageExtension keyUsage = null;
    private SubjectKeyIdentifierExtension skid = null;
    private AuthorityKeyIdentifierExtension akid = null;
    protected X509Certificate cert;

    public CertificateItemImpl(String label, X509Certificate cert) throws KeyManagerException {
        super(label);
        this.cert = cert;
        this.populateData();
    }

    private void populateData() throws KeyManagerException {
        try {
            this.validity = DisplayItemFactory.getValidityItem(this.cert.getNotBefore(), this.cert.getNotAfter());
            this.version = X509Version.getVersion(this.cert.getVersion());
            this.extensions = DisplayItemFactory.getExtensionItems(this.cert);
            this.extendedKeyUsageV = DisplayItemFactory.getExtendedKeyUsageItems(this.cert);
            this.keyUsage = DisplayItemFactory.getKeyUsageItems(this.cert);
            this.skid = DisplayItemFactory.getSubjectKeyIdentifierItems(this.cert);
            this.akid = DisplayItemFactory.getAuthorityKeyIdentifierItems(this.cert);
            this.fingerprint = DisplayItemFactory.getFinterprintItem(this.cert);
            this.issuerDN = DisplayItemFactory.getDNItem(this.cert.getIssuerX500Principal());
            this.keySize = CertificateItemImpl.computeKeySize(this.getPublicKey());
            this.publicKeyAlgorithm = DisplayItemFactory.getAlgorithmItem(this.getPublicKey());
            this.serialNumber = new ByteArray(this.cert.getSerialNumber().toByteArray());
            this.signature = new ByteArray(this.cert.getSignature());
            this.signatureAlgorithm = DisplayItemFactory.getAlgorithmItem(this.cert.getSigAlgOID(), this.cert.getSigAlgParams());
            this.subjectDN = DisplayItemFactory.getDNItem(this.cert.getSubjectX500Principal());
        }
        catch (KeyManagerException e) {
            e.addDetail(this.getLabel());
            throw e;
        }
        try {
            this.san = DisplayItemFactory.getSanItem(this.cert.getSubjectAlternativeNames());
        }
        catch (CertificateParsingException e) {
            throw new KeyManagerException(KeyManagerException.ExceptionReason.INVALID_SAN_IN_CERT, (Throwable)e, this.getLabel());
        }
    }

    @Override
    public SubjectKeyIdentifierExtension getSubjectKeyIdentifierExtension() {
        return this.skid;
    }

    @Override
    public AuthorityKeyIdentifierExtension getAuthorityKeyIdentifierExtension() {
        return this.akid;
    }

    @Override
    public X509Certificate getCert() {
        return this.cert;
    }

    public DisplayItemFactory.DisplayItem getFingerprint() {
        return this.fingerprint;
    }

    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    @Override
    public DisplayItemFactory.AlgorithmItem getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public DisplayItemFactory.DNItem getSubjectDN() {
        return this.subjectDN;
    }

    @Override
    public DisplayItemFactory.DNItem getIssuerDN() {
        return this.issuerDN;
    }

    @Override
    public DisplayItemFactory.ValidityItem getValidity() {
        return this.validity;
    }

    private static String getProvider() {
        return KeymanUtil.getJCEProviderName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.getLabel().equals(obj);
        }
        if (obj instanceof CertificateItemImpl) {
            return this.getLabel().equals(((CertificateItemImpl)obj).getLabel());
        }
        return super.equals(obj);
    }

    private static int computeKeySize(PublicKey key) {
        int kSize = 0;
        if (key instanceof RSAPublicKey) {
            kSize = ((RSAPublicKey)key).getModulus().bitLength();
        } else if (key instanceof DSAPublicKey) {
            kSize = ((DSAPublicKey)key).getY().bitLength();
        } else if (key instanceof ECPublicKey) {
            kSize = ((ECPublicKey)key).getParams().getCurve().getA().bitLength();
        }
        if (kSize % 2 != 0) {
            ++kSize;
        }
        return kSize;
    }

    @Override
    public void extract(String targetFile, CertificateWriter.OutputMode mode) throws KeyManagerException {
        CertificateWriter writer = new CertificateWriter(this.cert, mode);
        writer.write(new File(targetFile));
    }

    @Override
    public DisplayItemFactory.SanItem getSan() {
        return this.san;
    }

    public boolean isTrusted() {
        return true;
    }

    private String trustString() {
        return this.isTrusted() ? Messages.getString("Label.Enabled") : Messages.getString("Label.Disabled");
    }

    @Override
    public String toLongString() {
        return Messages.getString("Label.Label") + " " + this.getLabel() + "\n" + Messages.getString("Label.KeySize") + KeymanUtil.getLocalisedColon() + " " + this.keySize + "\n" + Messages.getString("Label.Version") + KeymanUtil.getLocalisedColon() + " " + this.version.toString() + "\n" + Messages.getString("Label.SerialNumber") + KeymanUtil.getLocalisedColon() + " " + this.serialNumber.toString() + "\n" + Messages.getString("Label.IssuedBy") + " " + this.issuerDN.toString() + "\n" + Messages.getString("Label.Subject") + KeymanUtil.getLocalisedColon() + " " + this.subjectDN.toString() + "\n" + Messages.getString("Label.Valid") + KeymanUtil.getLocalisedColon() + " " + this.validity.toString() + "\n" + Messages.getString("Label.Fingerprint") + " " + this.fingerprint + "\n" + Messages.getString("Label.Extensions") + ": " + this.getExtensionString() + "\n" + Messages.getString("Label.SigAlg") + KeymanUtil.getLocalisedColon() + " " + this.signatureAlgorithm.toString() + "\n" + Messages.getString("Label.TrustStatus") + KeymanUtil.getLocalisedColon() + " " + this.trustString() + "\n";
    }

    private String getExtensionString() {
        StringBuffer ret = new StringBuffer(" \n");
        if (!this.extensions.isEmpty()) {
            for (DisplayItemFactory.ExtensionItem nodes : this.extensions) {
                Extension ex = nodes.getExtension();
                if (ex instanceof ExtKeyUsageExtension) {
                    List usages = ((ExtKeyUsageExtension)ex).getExtendedKeyUsage();
                    ret.append("  - ExtKeyUsage: ");
                    for (String s : usages) {
                        if (s.equalsIgnoreCase("2.5.29.37.0")) {
                            s = "any";
                        } else if (s.equalsIgnoreCase("1.3.6.1.5.5.7.3.1")) {
                            s = "serverAuth";
                        } else if (s.equalsIgnoreCase("1.3.6.1.5.5.7.3.2")) {
                            s = "clientAuth";
                        } else if (s.equalsIgnoreCase("1.3.6.1.5.5.7.3.3")) {
                            s = "codeSigning";
                        } else if (s.equalsIgnoreCase("1.3.6.1.5.5.7.3.4")) {
                            s = "emailProtection";
                        } else if (s.equalsIgnoreCase("1.3.6.1.5.5.7.3.5")) {
                            s = "ipsecEndSystem";
                        } else if (s.equalsIgnoreCase("1.3.6.1.5.5.7.3.6")) {
                            s = "ipsecTunnel";
                        } else if (s.equalsIgnoreCase("1.3.6.1.5.5.7.3.7")) {
                            s = "ipsecUser";
                        } else if (s.equalsIgnoreCase("1.3.6.1.5.5.7.3.8")) {
                            s = "timeStamping";
                        } else if (s.equalsIgnoreCase("1.3.6.1.5.5.7.3.9")) {
                            s = "OCSPSigning";
                        } else if (s.equalsIgnoreCase("1.3.6.1.5.5.8.2.2")) {
                            s = "iKEIntermediate";
                        } else if (s.equalsIgnoreCase("1.3.6.1.4.1.311.10.3.3")) {
                            s = "microsoftSGC";
                        } else if (s.equalsIgnoreCase("2.16.840.1.113730.4.1")) {
                            s = "netscapeSGC";
                        }
                        ret.append(s + ", ");
                    }
                    if (!ret.toString().endsWith(", ") || ret.length() < 2) continue;
                    ret.replace(ret.length() - 2, ret.length(), "\n");
                    continue;
                }
                if (ex instanceof KeyUsageExtension) {
                    String tempString = "";
                    Enumeration keyUsages = ((KeyUsageExtension)ex).getElements();
                    while (keyUsages.hasMoreElements()) {
                        tempString = tempString + (String)keyUsages.nextElement() + ", ";
                    }
                    if (!tempString.equals("")) {
                        tempString = tempString.substring(0, tempString.length() - 2) + "\n";
                    }
                    ret.append("  - KeyUsage: " + tempString);
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.9")) {
                    ret.append("  - SubjectDirectoryAttributes: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.14")) {
                    ret.append("  - SubjectKeyIdentifier: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.16")) {
                    ret.append("  - PrivateKeyUsagePeriod: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.17")) {
                    ret.append("  - SAN: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.18")) {
                    ret.append("  - IssuerAlternativeNames: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.19")) {
                    ret.append("  - BasicConstraints: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.30")) {
                    ret.append("  - NameConstraints: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.31")) {
                    ret.append("  - CRLDistributionPoints: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.32")) {
                    ret.append("  - CertificatePolicies: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.33")) {
                    ret.append("  - PolicyMappings: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.35")) {
                    ret.append("  - AuthorityKeyIdentifier: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (ex.getExtensionId().toString().equals("2.5.29.36")) {
                    ret.append("  - PolicyConstraints: ").append(ex.toString()).append("\n");
                    continue;
                }
                if (!ex.getExtensionId().toString().equals("1.3.6.1.5.5.7.1.1")) continue;
                ret.append("  - AuthorityInfoAccess: ").append(ex.toString()).append("\n");
            }
        }
        return ret.toString().substring(0, ret.length() - 1);
    }

    @Override
    public KeymanTree toTree() {
        KeymanTree tree = new KeymanTree(KeymanTree.newNode(this.getLabel()));
        KeymanTree.KeymanTreeNode rootNode = (KeymanTree.KeymanTreeNode)tree.getRoot();
        KeymanTree.KeymanTreeNode certNode = rootNode.addChild(KeymanTree.newNode(Messages.getString("Label.Certificate")));
        KeymanTree.KeymanTreeNode tbsCertNode = certNode.addChild(KeymanTree.newNode(Messages.getString("Label.TBSCertificate")));
        tbsCertNode.addChildren(this.version.getTreeNodes());
        tbsCertNode.addChild(KeymanTree.newNode(Messages.getString("Label.SerialNumber"), this.serialNumber.toString()));
        KeymanTree.KeymanTreeNode issuerNode = tbsCertNode.addChild(KeymanTree.newNode(Messages.getString("Label.Issuer")));
        issuerNode.addChildren(this.issuerDN.getTreeNodes());
        tbsCertNode.addChildren(this.getValidity().getTreeNodes());
        KeymanTree.KeymanTreeNode subjectNode = tbsCertNode.addChild(KeymanTree.newNode(Messages.getString("Label.Subject")));
        subjectNode.addChildren(this.subjectDN.getTreeNodes());
        KeymanTree.KeymanTreeNode spkiNode = tbsCertNode.addChild(KeymanTree.newNode(Messages.getString("Label.SubjectPublicKeyInfo")));
        KeymanTree.KeymanTreeNode algorithmNode = spkiNode.addChild(KeymanTree.newNode(Messages.getString("Label.Algorithm")));
        algorithmNode.addChildren(this.publicKeyAlgorithm.getTreeNodes());
        spkiNode.addChild(KeymanTree.newNode(Messages.getString("Label.SubjectPublicKey"), new ByteArray(this.getPublicKey().getEncoded()).toString()));
        if (this.extensions.size() > 0) {
            KeymanTree.KeymanTreeNode extensionsNode = tbsCertNode.addChild(KeymanTree.newNode(Messages.getString("Label.Extensions")));
            for (DisplayItemFactory.TreeDisplayItem treeDisplayItem : this.extensions) {
                extensionsNode.addChildren(treeDisplayItem.getTreeNodes());
            }
        }
        KeymanTree.KeymanTreeNode saNode = certNode.addChild(KeymanTree.newNode(Messages.getString("Label.SigAlg")));
        saNode.addChildren(this.signatureAlgorithm.getTreeNodes());
        certNode.addChild(KeymanTree.newNode(Messages.getString("Label.SigVal"), this.signature.toString()));
        return tree;
    }

    @Override
    public KeyStore.Entry toKeyStoreEntry() {
        return new KeyStore.TrustedCertificateEntry(this.getCert());
    }

    @Override
    public String get(Details.DetailIdentifier id) throws KeyManagerException {
        switch (id) {
            case Fingerprint: {
                return this.getFingerprint().toString();
            }
            case IssuedBy: {
                return this.issuerDN.toString();
            }
            case KeySize: {
                return this.keySize + "";
            }
            case SerialNumber: {
                return this.serialNumber.toString();
            }
            case SignatureAlgorithm: {
                return this.signatureAlgorithm.toString();
            }
            case Subject: {
                return this.subjectDN.toString();
            }
            case TrustStatus: {
                return this.isTrusted() + "";
            }
            case Valid: {
                return this.validity.toString();
            }
            case Version: {
                return this.version.toString();
            }
            case EmailAddress: {
                return this.san.getEmailAddress();
            }
            case DnsName: {
                return this.san.getDnsName();
            }
            case IpAddress: {
                return this.san.getIpAddress();
            }
        }
        return super.get(id);
    }

    @Override
    public boolean isValid() {
        return !this.validity.isExpired();
    }

    @Override
    public Vector<ObjectIdentifier> getExtendedKeyUsageV() {
        return this.extendedKeyUsageV;
    }

    @Override
    public KeyUsageExtension getKeyUsage() {
        return this.keyUsage;
    }
}

