/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.util;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.ext.Defaultable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDisplayerFactory {
    public static TypeDisplayer newEnumDisplayer() {
        return new EnumDisplayer();
    }

    public static TypeDisplayer<Constants.CommandLineParameterEnum> newCliDisplayer() {
        return new CLIParameterDisplayer();
    }

    public static TypeDisplayer<Entry> newGUIEntryDisplayer() {
        return new EntryDisplayer(new DefaultableDisplayer(true));
    }

    public static TypeDisplayer<Entry> newCliEntryDisplayer() {
        return new EntryDisplayer(new DefaultableDisplayer(false));
    }

    public static TypeDisplayer<Entry> newPKCS11EntryDisplayer(String slot) {
        return new PKCS11EntryDisplayer(slot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CLIParameterDisplayer
    implements TypeDisplayer<Constants.CommandLineParameterEnum> {
        private CLIParameterDisplayer() {
        }

        @Override
        public String toString(Constants.CommandLineParameterEnum param) {
            return param.getCommandLineParameter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultableDisplayer
    implements TypeDisplayer<Defaultable> {
        private boolean showDefaultable;

        public DefaultableDisplayer(boolean showDefaultable) {
            this.showDefaultable = showDefaultable;
        }

        @Override
        public String toString(Defaultable param) {
            if (this.showDefaultable && param.isDefault()) {
                return "* ";
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryDisplayer
    implements TypeDisplayer<Entry> {
        private DefaultableDisplayer defaultableDisplayer;

        public EntryDisplayer(DefaultableDisplayer defaultableDisplayer) {
            this.defaultableDisplayer = defaultableDisplayer;
        }

        @Override
        public String toString(Entry param) {
            if (param instanceof Defaultable) {
                return this.defaultableDisplayer.toString((Defaultable)((Object)param)) + param.getLabel();
            }
            return param.getLabel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumDisplayer
    implements TypeDisplayer<Enum> {
        private EnumDisplayer() {
        }

        @Override
        public String toString(Enum param) {
            return param.name();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCS11EntryDisplayer
    implements TypeDisplayer<Entry> {
        private String slot;

        public PKCS11EntryDisplayer(String slot) {
            this.slot = slot;
        }

        @Override
        public String toString(Entry param) {
            return this.slot + ": " + param.getLabel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TypeDisplayer<T> {
        public String toString(T var1);
    }
}

