/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class CRLReason {
    private int code;
    private java.security.cert.CRLReason crlReason = null;
    private static java.security.cert.CRLReason[] values = java.security.cert.CRLReason.values();

    public CRLReason(int code) {
        this.code = code;
        if (this.code <= values.length) {
            this.crlReason = values[this.code];
        }
    }

    public byte[] encode() throws IOException {
        DerOutputStream dos = new DerOutputStream();
        dos.putEnumerated(BigInteger.valueOf(this.code));
        return dos.toByteArray();
    }

    public String toString() {
        if (this.crlReason == null) {
            return null;
        }
        if (this.crlReason == java.security.cert.CRLReason.UNSPECIFIED) {
            return "CRLReason: unspecified";
        }
        if (this.crlReason == java.security.cert.CRLReason.KEY_COMPROMISE) {
            return "CRLReason: key compromise";
        }
        if (this.crlReason == java.security.cert.CRLReason.CA_COMPROMISE) {
            return "CRLReason: ca compromise";
        }
        if (this.crlReason == java.security.cert.CRLReason.AFFILIATION_CHANGED) {
            return "CRLReason: affiliation changed";
        }
        if (this.crlReason == java.security.cert.CRLReason.SUPERSEDED) {
            return "CRLReason: superseded";
        }
        if (this.crlReason == java.security.cert.CRLReason.CESSATION_OF_OPERATION) {
            return "CRLReason: cessation of operation";
        }
        if (this.crlReason == java.security.cert.CRLReason.CERTIFICATE_HOLD) {
            return "CRLReason: certificate hold";
        }
        if (this.crlReason == java.security.cert.CRLReason.REMOVE_FROM_CRL) {
            return "CRLReason: remove from crl";
        }
        if (this.crlReason == java.security.cert.CRLReason.PRIVILEGE_WITHDRAWN) {
            return "CRLReason: privilege withdrown";
        }
        if (this.crlReason == java.security.cert.CRLReason.AA_COMPROMISE) {
            return "CRLReason: aa compromise";
        }
        return null;
    }
}

