/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertID;
import com.ibm.security.cert.OCSPException;
import com.ibm.security.cert.SingleRequest;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class OCSPRequest {
    private GeneralName reqName = null;
    private Extension[] exts = null;
    private SingleRequest[] requests = null;
    private CertID[] certIDs = null;
    private int version = 1;
    private String sigAld = "SHA-1";
    private byte[] sig = null;
    private X509Certificate[] certs = null;
    private static Debug debug = Debug.getInstance((String)"certpath");

    public OCSPRequest(SingleRequest[] requests) {
        if (requests == null) {
            OCSPException e = new OCSPException("request is null");
            e.printStackTrace();
        }
        this.requests = requests;
        this.certIDs = new CertID[requests.length];
        for (int i = 0; i < requests.length; ++i) {
            this.certIDs[i] = requests[i].getCertID();
        }
    }

    public OCSPRequest(SingleRequest[] requests, GeneralName requestorName, Extension[] exts, byte[] signature) {
        if (requests == null) {
            OCSPException e = new OCSPException("request is null");
            e.printStackTrace();
        }
        this.reqName = requestorName;
        this.exts = exts;
        this.requests = requests;
        this.certIDs = new CertID[exts.length];
        for (int i = 0; i < exts.length; ++i) {
            this.certIDs[i] = requests[i].getCertID();
        }
        this.sig = signature;
    }

    public OCSPRequest(byte[] encodedData) throws IOException {
        DerInputStream dis = new DerInputStream(encodedData);
        DerValue[] ders = dis.getSequence(1);
        if (ders.length == 0) {
            throw new IOException("encoded data of OCSPRequest is empty");
        }
        dis = new DerInputStream(ders[0].toByteArray());
        ders = dis.getSequence(2);
        block5: for (int i = 0; i < ders.length; ++i) {
            int tag = ders[i].getTag() & 0x1F;
            switch (tag) {
                case 0: {
                    int version = ders[i].getData().getBigInteger().intValue();
                    if (version == 0) continue block5;
                    throw new IOException("Unsupport OCSPRequest version");
                }
                case 1: {
                    this.reqName = new GeneralName(ders[i].getData().getDerValue());
                    if (debug == null) continue block5;
                    System.out.println("get request name: " + this.reqName);
                    continue block5;
                }
                case 2: {
                    DerInputStream dis2 = ders[i].getData();
                    DerValue[] ders2 = dis2.getSequence(1);
                    this.exts = new Extension[ders2.length];
                    for (int j = 0; j < ders2.length; ++j) {
                        this.exts[j] = new Extension(ders2[j]);
                    }
                    continue block5;
                }
                default: {
                    if (ders[i].getTag() == 48) {
                        DerValue[] ders3 = new DerInputStream(ders[i].toByteArray()).getSequence(1);
                        this.requests = new SingleRequest[ders3.length];
                        if (this.certIDs == null) {
                            this.certIDs = new CertID[ders3.length];
                        }
                        for (int j = 0; j < ders3.length; ++j) {
                            this.requests[j] = new SingleRequest(ders3[j]);
                            this.certIDs[j] = this.requests[j].getCertID();
                        }
                        continue block5;
                    }
                    throw new IOException("invalid tag");
                }
            }
        }
    }

    public OCSPRequest(DerValue der) throws IOException {
        this(der.toByteArray());
    }

    public byte[] encode() throws IOException {
        ArrayList<DerValue> alist = new ArrayList<DerValue>();
        DerOutputStream dos = new DerOutputStream();
        dos.putInteger(new BigInteger("0"));
        DerValue der1 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), dos.toByteArray());
        alist.add(der1);
        if (this.reqName != null) {
            dos = new DerOutputStream();
            this.reqName.encode(dos);
            DerValue der2 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), dos.toByteArray());
            alist.add(der2);
        }
        DerValue[] ders2 = new DerValue[this.requests.length];
        if (debug != null) {
            System.out.println("request length: " + this.requests.length);
        }
        DerOutputStream innerst = new DerOutputStream();
        for (int i = 0; i < this.requests.length; ++i) {
            try {
                innerst.write(this.requests[i].encode());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        dos = new DerOutputStream();
        DerValue der3 = new DerValue(48, innerst.toByteArray());
        alist.add(der3);
        if (this.exts != null) {
            DerValue[] ders3 = new DerValue[this.exts.length];
            for (int i = 0; i < ders3.length; ++i) {
                dos = new DerOutputStream();
                if (this.exts[i] == null) continue;
                this.exts[i].encode(dos);
                ders3[i] = new DerValue(dos.toByteArray());
            }
            dos = new DerOutputStream();
            if (ders3.length > 0) {
                boolean allNull = true;
                for (int i = 0; i < ders3.length; ++i) {
                    if (ders3[i] == null) continue;
                    allNull = false;
                    break;
                }
                if (!allNull) {
                    dos.putSequence(ders3);
                    DerValue der4 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), dos.toByteArray());
                    alist.add(der4);
                }
            }
        }
        DerValue[] temp = new DerValue[alist.size()];
        alist.toArray(temp);
        dos = new DerOutputStream();
        dos.putSequence(temp);
        DerValue value = new DerValue(dos.toByteArray());
        dos = new DerOutputStream();
        dos.putSequence(new DerValue[]{value});
        return dos.toByteArray();
    }

    public String toString() {
        String data = null;
        if (this.reqName != null) {
            data = data + "RequesterName\n" + this.reqName.toString();
        }
        data = data + "CertID's\n";
        for (int c = 0; c < this.certIDs.length; ++c) {
            data = data + this.certIDs[c].toString();
        }
        return data;
    }

    public CertID[] getCertIDs() {
        return this.certIDs;
    }

    public void setRequester(GeneralName requesterName) {
        this.reqName = requesterName;
    }

    public GeneralName getRequester() {
        return this.reqName;
    }

    public SingleRequest[] getRequests() {
        return this.requests;
    }

    public Extension[] getExtensions() {
        return this.exts;
    }
}

