/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert.deploy;

import com.ibm.misc.Debug;
import com.ibm.security.cert.deploy.CertId;
import com.ibm.security.cert.deploy.OCSPRequest;
import com.ibm.security.cert.deploy.OCSPResponse;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.AuthorityInfoAccessExtension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import sun.security.action.GetIntegerAction;

public final class OCSP {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int CONNECT_TIMEOUT = OCSP.initializeTimeout();

    private static int initializeTimeout() {
        Integer tmp = AccessController.doPrivileged(new GetIntegerAction("com.ibm.security.ocsp.timeout"));
        if (tmp == null || tmp < 0) {
            return 15000;
        }
        return tmp * 1000;
    }

    private OCSP() {
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert) throws IOException, CertPathValidatorException {
        CertId certId = null;
        URI responderURI = null;
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl((X509Certificate)cert);
            responderURI = OCSP.getResponderURI(certImpl);
            if (responderURI == null) {
                throw new CertPathValidatorException("No OCSP Responder URI in certificate");
            }
            certId = new CertId(issuerCert, certImpl.getSerialNumberObject());
        }
        catch (CertificateException ce) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ce);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ioe);
        }
        OCSPResponse ocspResponse = OCSP.check(Collections.singletonList(certId), responderURI, Collections.singletonList(issuerCert), null);
        return ocspResponse.getSingleResponse(certId);
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert, URI responderURI, X509Certificate responderCert, Date date) throws IOException, CertPathValidatorException {
        return OCSP.check(cert, issuerCert, responderURI, Collections.singletonList(responderCert), date);
    }

    public static RevocationStatus check(X509Certificate cert, X509Certificate issuerCert, URI responderURI, List<X509Certificate> responderCerts, Date date) throws IOException, CertPathValidatorException {
        CertId certId = null;
        try {
            X509CertImpl certImpl = X509CertImpl.toImpl((X509Certificate)cert);
            certId = new CertId(issuerCert, certImpl.getSerialNumberObject());
        }
        catch (CertificateException ce) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ce);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ioe);
        }
        OCSPResponse ocspResponse = OCSP.check(Collections.singletonList(certId), responderURI, responderCerts, date);
        return ocspResponse.getSingleResponse(certId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OCSPResponse check(List<CertId> certIds, URI responderURI, List<X509Certificate> responderCerts, Date date) throws IOException, CertPathValidatorException {
        byte[] bytes = null;
        try {
            OCSPRequest request = new OCSPRequest(certIds);
            bytes = request.encodeBytes();
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException("Exception while encoding OCSPRequest", ioe);
        }
        InputStream in = null;
        OutputStream out = null;
        byte[] response = null;
        try {
            int count;
            URL url = responderURI.toURL();
            if (debug != null) {
                System.out.println("connecting to OCSP service at: " + url);
            }
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setConnectTimeout(CONNECT_TIMEOUT);
            con.setReadTimeout(CONNECT_TIMEOUT);
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/ocsp-request");
            con.setRequestProperty("Content-length", String.valueOf(bytes.length));
            out = con.getOutputStream();
            out.write(bytes);
            out.flush();
            if (debug != null && con.getResponseCode() != 200) {
                System.out.println("Received HTTP error: " + con.getResponseCode() + " - " + con.getResponseMessage());
            }
            in = con.getInputStream();
            int contentLength = con.getContentLength();
            if (contentLength == -1) {
                contentLength = Integer.MAX_VALUE;
            }
            response = new byte[contentLength > 2048 ? 2048 : contentLength];
            int total = 0;
            while (total < contentLength && (count = in.read(response, total, response.length - total)) >= 0) {
                if ((total += count) < response.length || total >= contentLength) continue;
                response = Arrays.copyOf(response, total * 2);
            }
            response = Arrays.copyOf(response, total);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        OCSPResponse ocspResponse = null;
        try {
            ocspResponse = new OCSPResponse(response, date, responderCerts);
        }
        catch (IOException ioe) {
            throw new CertPathValidatorException(ioe);
        }
        if (ocspResponse.getResponseStatus() != OCSPResponse.ResponseStatus.SUCCESSFUL) {
            throw new CertPathValidatorException("OCSP response error: " + (Object)((Object)ocspResponse.getResponseStatus()));
        }
        for (CertId certId : certIds) {
            OCSPResponse.SingleResponse sr = ocspResponse.getSingleResponse(certId);
            if (sr == null) {
                if (debug != null) {
                    System.out.println("No response found for CertId: " + certId);
                }
                throw new CertPathValidatorException("OCSP response does not include a response for a certificate supplied in the OCSP request");
            }
            if (debug == null) continue;
            System.out.println("Status of certificate (with serial number " + certId.getSerialNumber() + ") is: " + (Object)((Object)sr.getCertStatus()));
        }
        return ocspResponse;
    }

    public static URI getResponderURI(X509Certificate cert) {
        try {
            return OCSP.getResponderURI(X509CertImpl.toImpl((X509Certificate)cert));
        }
        catch (CertificateException ce) {
            return null;
        }
    }

    static URI getResponderURI(X509CertImpl certImpl) {
        AuthorityInfoAccessExtension aia = certImpl.getAuthorityInfoAccessExtension();
        if (aia == null) {
            return null;
        }
        Vector descriptions = aia.getAccessDescriptions();
        for (AccessDescription description : descriptions) {
            GeneralName generalName;
            if (!description.getAccessMethod().equals((Object)AccessDescription.Ad_OCSP_Id) || (generalName = description.getAccessLocation()).getType() != 6) continue;
            URIName uri = (URIName)generalName.getName();
            return uri.getURI();
        }
        return null;
    }

    public static interface RevocationStatus {
        public CertStatus getCertStatus();

        public Date getRevocationTime();

        public CRLReason getRevocationReason();

        public Map<String, Extension> getSingleExtensions();

        public static enum CertStatus {
            GOOD,
            REVOKED,
            UNKNOWN;

        }
    }
}

