/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.security.AccessController;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public abstract class ByteToCharArabic
extends ByteToCharConverter {
    protected char[] byteToCharTable;
    protected boolean doArabicDeshaping = true;
    private boolean bidiEnv;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;
    private static final String IBMdeshapeString = "\u0635\u0634\u0633\u0636\u0625\u0623\u0622\u0627\ufffe";
    protected static final char[] CUAdeshape;
    protected char firstPrivate = (char)63732;
    protected char lastPrivate = (char)63740;
    private static final String deshapeString = "\u064b\u064b\u064c\ufe73\u064d\ufe75\u064e\u064e\u064f\u064f\u0650\u0650\u0651\u0651\u0652\u0652\u0621\u0622\u0622\u0623\u0623\u0624\u0624\u0625\u0625\u0626\u0626\u0626\u0626\u0627\u0627\u0628\u0628\u0628\u0628\u0629\u0629\u062a\u062a\u062a\u062a\u062b\u062b\u062b\u062b\u062c\u062c\u062c\u062c\u062d\u062d\u062d\u062d\u062e\u062e\u062e\u062e\u062f\u062f\u0630\u0630\u0631\u0631\u0632\u0632\u0633\u0633\u0633\u0633\u0634\u0634\u0634\u0634\u0635\u0635\u0635\u0635\u0636\u0636\u0636\u0636\u0637\u0637\u0637\u0637\u0638\u0638\u0638\u0638\u0639\u0639\u0639\u0639\u063a\u063a\u063a\u063a\u0641\u0641\u0641\u0641\u0642\u0642\u0642\u0642\u0643\u0643\u0643\u0643\u0644\u0644\u0644\u0644\u0645\u0645\u0645\u0645\u0646\u0646\u0646\u0646\u0647\u0647\u0647\u0647\u0648\u0648\u0649\u0649\u064a\u064a\u064a\u064a\u0622\u0622\u0623\u0623\u0625\u0625\u0627\u0627";
    protected static final char[] deshape;
    private static final String deshapeStringFB = "\u0671\u0671\u067b\u067b\u067b\u067b\u067e\u067e\u067e\u067e\u0680\u0680\u0680\u0680\u067a\u067a\u067a\u067a\u067f\u067f\u067f\u067f\u0679\u0679\u0679\u0679\u06a4\u06a4\u06a4\u06a4\u06a6\u06a6\u06a6\u06a6\u0684\u0684\u0684\u0684\u0683\u0683\u0683\u0683\u0686\u0686\u0686\u0686\u0687\u0687\u0687\u0687\u068d\u068d\u068c\u068c\u068e\u068e\u0688\u0688\u0698\u0698\u0691\u0691\u06a9\u06a9\u06a9\u06a9\u06af\u06af\u06af\u06af\u06b3\u06b3\u06b3\u06b3\u06b1\u06b1\u06b1\u06b1\u06ba\u06ba\u06bb\u06bb\u06bb\u06bb\u06c0\u06c0\u06c1\u06c1\u06c1\u06c1\u06be\u06be\u06be\u06be\u06d2\u06d2\u06d3\u06d3\ufbb2\ufbb3\ufbb4\ufbb5\ufbb6\ufbb7\ufbb8\ufbb9\ufbba\ufbbb\ufbbc\ufbbd\ufbbe\ufbbf\ufbc0\ufbc1\ufbc2\ufbc3\ufbc4\ufbc5\ufbc6\ufbc7\ufbc8\ufbc9\ufbca\ufbcb\ufbcc\ufbcd\ufbce\ufbcf\ufbd0\ufbd1\ufbd2\u06ad\u06ad\u06ad\u06ad\u06c7\u06c7\u06c6\u06c6\u06c8\u06c8\u0677\u06cb\u06cb\u06c5\u06c5\u06c9\u06c9\u06d0\u06d0\u06d0\u06d0\u0649\u0649";

    public String getType() {
        return "arabic";
    }

    public char[] getCharData() {
        return this.byteToCharTable;
    }

    public byte[] getByteData() {
        byte[] byArray = new byte[]{(byte)(this.doArabicDeshaping ? 1 : 0)};
        return byArray;
    }

    public ByteToCharArabic() {
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public int flush(char[] cArray, int n, int n2) {
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int n5 = 65533;
        this.charOff = n3;
        this.byteOff = n;
        BidiConvert bidiConvert = new BidiConvert();
        this.bidiEnv = bidiConvert.isBidiEnv(this.bidiParms, this.getCharacterEncoding());
        while (this.byteOff < n2) {
            int n6;
            char c;
            block13: {
                block16: {
                    block15: {
                        block14: {
                            c = this.byteToCharTable[byArray[this.byteOff] + 128];
                            n6 = 1;
                            if (c < '\ue000') break block13;
                            if (c != '\ufffd') break block14;
                            if (!this.subMode) {
                                this.badInputLength = 1;
                                throw new UnknownCharacterException();
                            }
                            c = this.subChars[0];
                            break block13;
                        }
                        if (!this.doArabicDeshaping || this.bidiEnv) break block13;
                        if (c < '\ufe70') break block15;
                        if (c <= '\ufef4') {
                            c = deshape[c - 65136];
                            break block16;
                        } else if (c <= '\ufefc') {
                            n5 = deshape[c - 65136];
                            c = '\u0644';
                            n6 = 2;
                        }
                        break block16;
                    }
                    if (c >= '\ufb50' && c <= '\ufbe9') {
                        c = deshapeStringFB.charAt(c - 64336);
                    } else if (c >= this.firstPrivate && c <= this.lastPrivate) {
                        c = CUAdeshape[c - this.firstPrivate];
                    }
                }
                if (c == '\ufffe') {
                    n6 = 0;
                }
            }
            if (this.charOff + n6 > n4) {
                throw new ConversionBufferFullException();
            }
            if (n6 > 0) {
                cArray[this.charOff++] = c;
            }
            if (n6 > 1) {
                cArray[this.charOff++] = n5;
            }
            ++this.byteOff;
        }
        if (this.bidiEnabled && bidiConvert.isBidiData(cArray, n3, this.charOff, this.bidiParms, this.getCharacterEncoding())) {
            char[] cArray2 = new char[this.charOff - n3];
            cArray2 = bidiConvert.toUnicode(cArray, n3, this.charOff, this.bidiParms, this.getCharacterEncoding());
            System.arraycopy(cArray2, 0, cArray, n3, this.charOff - n3);
        }
        return this.charOff - n3;
    }

    public int getMaxCharsPerByte() {
        return this.doArabicDeshaping ? 2 : 1;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }

    static {
        CUAdeshape = IBMdeshapeString.toCharArray();
        deshape = deshapeString.toCharArray();
    }
}

