/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharDoubleByte;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.HKSCS_2004;

public class ByteToCharHKSCS_2004
extends ByteToCharDoubleByte {
    private final String SurrogateMappings;
    private char highSurrogate;
    private char lowSurrogate;

    public String getCharacterEncoding() {
        return "HKSCS_2004";
    }

    public ByteToCharHKSCS_2004() {
        this.index1 = HKSCS_2004.getDecoderIndex1();
        this.index2 = HKSCS_2004.getDecoderIndex2();
        this.SurrogateMappings = HKSCS_2004.getSurrogateMappings();
        this.start = 64;
        this.end = 254;
    }

    @Override
    protected char getUnicode(int n, int n2) {
        char c = super.getUnicode(n, n2);
        int n3 = c - 55296;
        if (c >= '\ud800' && c <= '\udfff') {
            this.highSurrogate = this.SurrogateMappings.charAt(n3 * 2);
            this.lowSurrogate = this.SurrogateMappings.charAt(n3 * 2 + 1);
            return '\ud800';
        }
        return c;
    }

    @Override
    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int n5 = 65533;
        int n6 = 0;
        this.charOff = n3;
        this.byteOff = n;
        int n7 = 1;
        while (this.byteOff < n2) {
            int n8;
            if (this.savedByte == 0) {
                n8 = byArray[this.byteOff];
                n6 = 1;
            } else {
                n8 = this.savedByte;
                this.savedByte = 0;
                n6 = 0;
            }
            n5 = this.convSingleByte(n8);
            if (n5 >= 65533 && this.isLeadByte(n8)) {
                if (this.byteOff + n6 >= n2) {
                    this.savedByte = (byte)n8;
                    this.byteOff += n6;
                    break;
                }
                int n9 = byArray[this.byteOff + n6] & 0xFF;
                ++n6;
                this.lowSurrogate = '\u0000';
                this.highSurrogate = '\u0000';
                n5 = this.getUnicode(n8 &= 0xFF, n9);
                int n10 = n7 = this.highSurrogate > '\u0000' ? 2 : 1;
            }
            if (n5 >= 65533) {
                if (n5 == 65534) {
                    throw new MalformedInputException();
                }
                if (this.subMode) {
                    n5 = this.subChars[0];
                } else {
                    this.badInputLength = n6;
                    throw new UnknownCharacterException();
                }
            }
            if (this.charOff >= n4) {
                throw new ConversionBufferFullException();
            }
            if (n7 == 2) {
                cArray[this.charOff++] = this.highSurrogate;
                cArray[this.charOff++] = this.lowSurrogate;
                n7 = 1;
            } else {
                cArray[this.charOff++] = n5;
            }
            this.byteOff += n6;
        }
        return this.charOff - n3;
    }
}

