/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public abstract class DoubleByteEncoder
extends CharsetEncoder {
    private short[] index1;
    private String[] index2;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected DoubleByteEncoder(Charset charset, short[] sArray, String[] stringArray) {
        super(charset, 2.0f, 2.0f);
        this.index1 = sArray;
        this.index2 = stringArray;
    }

    protected DoubleByteEncoder(Charset charset) {
        super(charset, 2.0f, 2.0f);
    }

    protected DoubleByteEncoder(Charset charset, short[] sArray, String[] stringArray, float f, float f2) {
        super(charset, f, f2);
        this.index1 = sArray;
        this.index2 = stringArray;
    }

    protected DoubleByteEncoder(Charset charset, short[] sArray, String[] stringArray, byte[] byArray) {
        super(charset, 2.0f, 2.0f, byArray);
        this.index1 = sArray;
        this.index2 = stringArray;
    }

    protected DoubleByteEncoder(Charset charset, short[] sArray, String[] stringArray, byte[] byArray, float f, float f2) {
        super(charset, f, f2, byArray);
        this.index1 = sArray;
        this.index2 = stringArray;
    }

    @Override
    public boolean canEncode(char c) {
        return this.encodeSingle(c) != -1 || this.encodeDouble(c) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        try {
            while (n < n2) {
                int n5;
                char c = cArray[n];
                if (Character.isSurrogate(c)) {
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    if (n2 - n < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    n5 = cArray[n + 1];
                    byte[] byArray2 = new byte[2];
                    byArray2 = this.encodeSurrogate(c, (char)n5);
                    if (byArray2 == null) {
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (n4 - n3 < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = byArray2[0];
                    byArray[n3++] = byArray2[1];
                    n += 2;
                    continue;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                n5 = this.encodeSingle(c);
                if (n5 != -1) {
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)n5;
                    ++n;
                    continue;
                }
                int n6 = this.encodeDouble(c);
                if (n6 != 0 && c != '\u0000') {
                    if (n4 - n3 < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byArray[n3++] = (byte)((n6 & 0xFF00) >> 8);
                    byArray[n3++] = (byte)(n6 & 0xFF);
                    ++n;
                    continue;
                }
                CoderResult coderResult = CoderResult.unmappableForLength(1);
                return coderResult;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
            byteBuffer.position(n3 - byteBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                Object object;
                int n2;
                int n3;
                char c = charBuffer.get();
                if (Character.isSurrogate(c)) {
                    n3 = this.sgp.parse(c, charBuffer);
                    if (n3 < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    n2 = Surrogate.low(n3);
                    object = new byte[2];
                    object = this.encodeSurrogate(c, (char)n2);
                    if (object == null) {
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (byteBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    n += 2;
                    byteBuffer.put(object[0]);
                    byteBuffer.put(object[1]);
                    continue;
                }
                if (c >= '\ufffe') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                n3 = this.encodeSingle(c);
                if (n3 != -1) {
                    if (byteBuffer.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    ++n;
                    byteBuffer.put((byte)n3);
                    continue;
                }
                n2 = this.encodeDouble(c);
                if (n2 != 0 && c != '\u0000') {
                    if (byteBuffer.remaining() < 2) {
                        object = CoderResult.OVERFLOW;
                        return object;
                    }
                    ++n;
                    byteBuffer.put((byte)((n2 & 0xFF00) >> 8));
                    byteBuffer.put((byte)n2);
                    continue;
                }
                object = CoderResult.unmappableForLength(1);
                return object;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray()) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    protected int encodeDouble(char c) {
        int n = this.index1[(c & 0xFF00) >> 8] << 8;
        return this.index2[n >> 12].charAt((n & 0xFFF) + (c & 0xFF));
    }

    protected int encodeSingle(char c) {
        if (c < '\u0080') {
            return (byte)c;
        }
        return -1;
    }

    protected byte[] encodeSurrogate(char c, char c2) {
        return null;
    }
}

