/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.Cuda;
import com.ibm.cuda.CudaBuffer;
import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaGrid;
import com.ibm.cuda.CudaKernel;
import com.ibm.cuda.CudaStream;

public final class CudaFunction {
    public static final int ATTRIBUTE_BINARY_VERSION = 6;
    public static final int ATTRIBUTE_CONST_SIZE_BYTES = 2;
    public static final int ATTRIBUTE_LOCAL_SIZE_BYTES = 3;
    public static final int ATTRIBUTE_MAX_THREADS_PER_BLOCK = 0;
    public static final int ATTRIBUTE_NUM_REGS = 4;
    public static final int ATTRIBUTE_PTX_VERSION = 5;
    public static final int ATTRIBUTE_SHARED_SIZE_BYTES = 1;
    final int deviceId;
    private final long nativeHandle;

    private static native int getAttribute(int var0, long var1, int var3) throws CudaException;

    private static native void launch(int var0, long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long[] var12) throws CudaException;

    static long nativeValueOf(Object parameter) {
        long value = 0L;
        if (parameter != null) {
            Class<?> type = parameter.getClass();
            if (type == CudaBuffer.class) {
                value = ((CudaBuffer)parameter).getAddress();
            } else if (type == Integer.class) {
                value = ((Integer)parameter).intValue();
            } else if (type == Long.class) {
                value = (Long)parameter;
            } else if (type == Double.class) {
                value = Double.doubleToRawLongBits((Double)parameter);
            } else if (type == Float.class) {
                value = Float.floatToRawIntBits(((Float)parameter).floatValue());
            } else if (type == Short.class) {
                value = ((Short)parameter).shortValue();
            } else if (type == Byte.class) {
                value = ((Byte)parameter).byteValue();
            } else if (type == Character.class) {
                value = ((Character)parameter).charValue();
            } else {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    private static native void setCacheConfig(int var0, long var1, int var3) throws CudaException;

    private static native void setSharedMemConfig(int var0, long var1, int var3) throws CudaException;

    CudaFunction(int deviceId, long nativeHandle) {
        this.deviceId = deviceId;
        this.nativeHandle = nativeHandle;
    }

    public int getAttribute(int attribute) throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        return CudaFunction.getAttribute(this.deviceId, this.nativeHandle, attribute);
    }

    void launch(CudaGrid grid, Object ... parameters) throws CudaException {
        int parameterCount = parameters.length;
        long[] nativeValues = new long[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            nativeValues[i] = CudaFunction.nativeValueOf(parameters[i]);
        }
        Cuda.checkInitialization(this.deviceId);
        CudaStream stream = grid.stream;
        CudaFunction.launch(this.deviceId, this.nativeHandle, grid.gridDimX, grid.gridDimY, grid.gridDimZ, grid.blockDimX, grid.blockDimY, grid.blockDimZ, grid.sharedMemBytes, stream != null ? stream.getHandle() : 0L, nativeValues);
    }

    void launch(CudaGrid grid, CudaKernel.Parameters parameters) throws CudaException {
        if (!parameters.isComplete()) {
            throw new IllegalArgumentException();
        }
        Cuda.checkInitialization(this.deviceId);
        CudaStream stream = grid.stream;
        CudaFunction.launch(this.deviceId, this.nativeHandle, grid.gridDimX, grid.gridDimY, grid.gridDimZ, grid.blockDimX, grid.blockDimY, grid.blockDimZ, grid.sharedMemBytes, stream != null ? stream.getHandle() : 0L, parameters.values);
    }

    public void setCacheConfig(CudaDevice.CacheConfig config) throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        CudaFunction.setCacheConfig(this.deviceId, this.nativeHandle, config.nativeValue);
    }

    public void setSharedMemConfig(CudaDevice.SharedMemConfig config) throws CudaException {
        Cuda.checkInitialization(this.deviceId);
        CudaFunction.setSharedMemConfig(this.deviceId, this.nativeHandle, config.nativeValue);
    }
}

