/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.Cuda;
import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaEvent;
import com.ibm.cuda.CudaException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaStream
implements AutoCloseable {
    public static final int FLAG_DEFAULT = 0;
    public static final int FLAG_NON_BLOCKING = 1;
    final int deviceId;
    private final AtomicLong nativeHandle;

    private static native long create(int var0) throws CudaException;

    private static native long createWithPriority(int var0, int var1, int var2) throws CudaException;

    private static native void destroy(long var0) throws CudaException;

    private static native int getFlags(long var0) throws CudaException;

    private static native int getPriority(long var0) throws CudaException;

    private static native int query(long var0);

    private static native void synchronize(long var0) throws CudaException;

    private static native void waitFor(long var0, long var2) throws CudaException;

    public CudaStream(CudaDevice device) throws CudaException {
        this.deviceId = device.getDeviceId();
        Cuda.checkInitialization(this.deviceId);
        this.nativeHandle = new AtomicLong(CudaStream.create(this.deviceId));
    }

    public CudaStream(CudaDevice device, int flags, int priority) throws CudaException {
        this.deviceId = device.getDeviceId();
        Cuda.checkInitialization(this.deviceId);
        this.nativeHandle = new AtomicLong(CudaStream.createWithPriority(this.deviceId, flags, priority));
    }

    public void addCallback(Runnable callback) throws CudaException {
        Objects.requireNonNull(callback);
        CudaDevice.addCallback(this.deviceId, this.getHandle(), callback);
    }

    @Override
    public void close() throws CudaException {
        long handle = this.nativeHandle.getAndSet(0L);
        if (handle != 0L) {
            CudaStream.destroy(handle);
        }
    }

    public int getFlags() throws CudaException {
        return CudaStream.getFlags(this.getHandle());
    }

    long getHandle() {
        long handle = this.nativeHandle.get();
        if (handle == 0L) {
            throw new IllegalStateException();
        }
        return handle;
    }

    public int getPriority() throws CudaException {
        return CudaStream.getPriority(this.getHandle());
    }

    public int query() {
        return CudaStream.query(this.getHandle());
    }

    public void synchronize() throws CudaException {
        CudaStream.synchronize(this.getHandle());
    }

    public void waitFor(CudaEvent event) throws CudaException {
        CudaStream.waitFor(this.getHandle(), event.getHandle());
    }
}

