/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Credentials;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.KrbApReq;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.internal.APRep;
import com.ibm.security.krb5.internal.EncAPRepPart;
import com.ibm.security.krb5.internal.KRBError;
import com.ibm.security.krb5.internal.KdcErrException;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.LocalSeqNumber;
import com.ibm.security.krb5.internal.SeqNumber;
import com.ibm.security.krb5.internal.crypto.KrbCryptoException;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public class KrbApRep {
    private byte[] a;
    private EncAPRepPart b;
    private APRep c;

    public KrbApRep(KrbApReq krbApReq, boolean bl, boolean bl2) throws KrbException, IOException {
        EncryptionKey encryptionKey = bl2 ? new EncryptionKey(krbApReq.getCreds().getSessionKey()) : null;
        LocalSeqNumber localSeqNumber = new LocalSeqNumber();
        this.a(krbApReq, encryptionKey, localSeqNumber);
    }

    public KrbApRep(KrbApReq krbApReq, EncryptionKey encryptionKey, boolean bl) throws KrbException, IOException {
        LocalSeqNumber localSeqNumber = null;
        if (bl) {
            localSeqNumber = new LocalSeqNumber();
        }
        if (encryptionKey == null) {
            encryptionKey = krbApReq.getCreds().getSessionKey();
        }
        this.a(krbApReq, encryptionKey, localSeqNumber);
    }

    public KrbApRep(byte[] byArray, Credentials credentials, KrbApReq krbApReq) throws KrbException, IOException {
        this(byArray, credentials);
        this.a(krbApReq);
    }

    public KrbApRep(DerValue derValue, Credentials credentials, KrbApReq krbApReq) throws KrbException, IOException {
        this(derValue, credentials);
        this.a(krbApReq);
    }

    void a(KrbApReq krbApReq, EncryptionKey encryptionKey, SeqNumber seqNumber) throws KrbException, IOException {
        this.a(krbApReq.getCreds().d, krbApReq.b(), krbApReq.c(), encryptionKey, seqNumber);
        this.a = this.c.asn1Encode();
    }

    KrbApRep(byte[] byArray, Credentials credentials) throws KrbException, IOException {
        this(new DerValue(byArray), credentials);
    }

    KrbApRep(DerValue derValue, Credentials credentials) throws KrbException, IOException {
        APRep aPRep = null;
        try {
            aPRep = new APRep(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            aPRep = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.eText.charAt(kRBError.eText.length() - 1) == '\u0000' ? kRBError.eText.substring(0, kRBError.eText.length() - 1) : kRBError.eText;
            throw new KrbException(kRBError.errorCode, string, true);
        }
        byte[] byArray = null;
        if (aPRep.encPart.isDesEncType()) {
            byte[] byArray2 = aPRep.encPart.decrypt(credentials.d, 12);
            byArray = aPRep.encPart.reset(byArray2, true);
        } else if (aPRep.encPart.isAES128EncType()) {
            byte[] byArray3 = aPRep.encPart.decrypt(credentials.d, 12);
            byArray = aPRep.encPart.reset(byArray3, true);
        } else if (aPRep.encPart.isAES256EncType()) {
            byte[] byArray4 = aPRep.encPart.decrypt(credentials.d, 12);
            byArray = aPRep.encPart.reset(byArray4, true);
        } else {
            byArray = aPRep.encPart.decrypt(credentials.d, 12);
        }
        derValue = new DerValue(byArray);
        this.b = new EncAPRepPart(derValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(KrbApReq krbApReq) throws KrbException, IOException {
        if (this.b.getTime().getSeconds() == krbApReq.b().getSeconds() && this.b.getMicroSeconds() == krbApReq.b().getMicroSeconds()) {
            return;
        }
        throw new KrbApErrException(46);
    }

    public EncryptionKey getSubKey() {
        return this.b.getSubKey();
    }

    public Integer getSeqNumber() {
        return this.b.getSeqNumber();
    }

    public byte[] getMessage() {
        return this.a;
    }

    private void a(EncryptionKey encryptionKey, KerberosTime kerberosTime, int n2, EncryptionKey encryptionKey2, SeqNumber seqNumber) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer n3 = null;
        if (seqNumber != null) {
            n3 = new Integer(seqNumber.current());
        }
        this.b = new EncAPRepPart(kerberosTime, n2, encryptionKey2, n3);
        byte[] byArray = this.b.asn1Encode();
        EncryptedData encryptedData = null;
        encryptedData = EncryptedData.isDesEncType(encryptionKey.getEType()) ? new EncryptedData(encryptionKey, byArray, 12) : (EncryptedData.isAES128EncType(encryptionKey.getEType()) ? new EncryptedData(encryptionKey, byArray, 12) : (EncryptedData.isAES256EncType(encryptionKey.getEType()) ? new EncryptedData(encryptionKey, byArray, 12) : new EncryptedData(encryptionKey, byArray, 12)));
        this.c = new APRep(encryptedData);
    }
}

