/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm;

import com.ibm.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xtq.xml.xdm.ExpandedNameTable;
import com.ibm.xtq.xml.xdm.ObjectFactory;
import com.ibm.xtq.xml.xdm.SecuritySupport;
import com.ibm.xtq.xml.xdm.XDMClassCache;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMManager;
import com.ibm.xtq.xml.xdm.XDMSource;
import com.ibm.xtq.xml.xdm.XDMWSFilter;
import com.ibm.xtq.xml.xdm.dom.XDMNodeAdapterEmpty;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;

public class XDMManagerFactory {
    private static int m_uniqueDocNumber = 0;
    private static final String XDM_MANAGERMAP_FILE = "com/ibm/xtq/xml/xdm/XDMManagerMap.properties";
    private static final String XDM_MANAGERMAP_PROP = "com.ibm.xtq.xml.xdm.XDMManagerMap";
    private HashMap m_managerMap;
    private Properties m_propMap;
    private ExpandedNameTable m_expandedNameTable;
    private HashMap m_stylesheetCursors;
    private Hashtable m_documents = new Hashtable();
    private static final boolean CACHE_XDM_MANAGER_MAP = true;
    private static Properties m_cachedPropMap;

    public static synchronized int uniqueDocNumber() {
        return ++m_uniqueDocNumber;
    }

    public XDMManagerFactory() {
        this.m_propMap = XDMManagerFactory.getPropertyMap();
        this.m_managerMap = new HashMap(this.m_propMap.size());
        this.m_expandedNameTable = new ExpandedNameTable();
    }

    private static Properties getNewPropertyMap() {
        try {
            Properties properties = new Properties();
            String string = null;
            InputStream inputStream = null;
            try {
                string = System.getProperty(XDM_MANAGERMAP_PROP, "");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string != null && string.length() > 0) {
                URL uRL = new URL(string);
                inputStream = uRL.openStream();
            }
            if (inputStream == null) {
                inputStream = SecuritySupport.getResourceAsStream(ObjectFactory.findClassLoader(), XDM_MANAGERMAP_FILE);
            }
            if (inputStream != null) {
                properties.load(inputStream);
                inputStream.close();
            }
            return properties;
        }
        catch (MalformedURLException malformedURLException) {
            throw new WrappedRuntimeException(malformedURLException);
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertyMap() {
        Class<XDMManagerFactory> clazz = XDMManagerFactory.class;
        synchronized (XDMManagerFactory.class) {
            if (m_cachedPropMap == null) {
                m_cachedPropMap = XDMManagerFactory.getNewPropertyMap();
            }
            Properties properties = m_cachedPropMap;
            // ** MonitorExit[var1] (shouldn't be in output)
            return properties;
        }
    }

    public XDMManager get(Class clazz) {
        try {
            XDMManager xDMManager = (XDMManager)this.m_managerMap.get(clazz);
            if (null == xDMManager) {
                xDMManager = (XDMManager)clazz.newInstance();
                xDMManager.setManagerFactory(this);
                xDMManager.init();
                this.m_managerMap.put(clazz, xDMManager);
            }
            return xDMManager;
        }
        catch (InstantiationException instantiationException) {
            throw new WrappedRuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new WrappedRuntimeException(illegalAccessException);
        }
    }

    public void setExpandedNameTable(ExpandedNameTable expandedNameTable) {
        this.m_expandedNameTable = expandedNameTable;
    }

    public ExpandedNameTable getExpandedNameTable() {
        return this.m_expandedNameTable;
    }

    public XDMCursor getXDM(Source source, boolean bl, XDMWSFilter xDMWSFilter, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, XDMClassCache xDMClassCache, String string) {
        if (source instanceof XDMSource) {
            return ((XDMSource)source).getXDM();
        }
        try {
            if (null == source) {
                XDMManager xDMManager = this.get(Class.forName("com.ibm.xtq.xml.xdm.dtm.XDMManagerDTM"));
                return xDMManager.getXDM(source, bl, xDMWSFilter, bl2, bl3, bl4, bl5, bl6, this, xDMClassCache, string);
            }
            String string2 = source instanceof StreamSource ? this.m_propMap.getProperty("javax.xml.transform.stream.StreamSource") : (source instanceof DOMSource ? this.m_propMap.getProperty("javax.xml.transform.dom.DOMSource") : (source instanceof StAXSource ? this.m_propMap.getProperty("javax.xml.transform.stax.StAXSource") : this.m_propMap.getProperty("javax.xml.transform.sax.SAXSource")));
            if (null != string2) {
                XDMManager xDMManager = this.get(Class.forName(string2));
                return xDMManager.getXDM(source, bl, xDMWSFilter, bl2, bl3, bl4, bl5, bl6, this, xDMClassCache, string);
            }
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrappedRuntimeException(classNotFoundException);
        }
    }

    public XDMCursor getXDM(Source source, boolean bl, XDMWSFilter xDMWSFilter, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return this.getXDM(source, bl, xDMWSFilter, bl2, bl3, bl4, bl5, false, null, null);
    }

    public XDMCursor getXDM(Source source, boolean bl, XDMWSFilter xDMWSFilter, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string) {
        return this.getXDM(source, bl, xDMWSFilter, bl2, bl3, bl4, bl5, bl6, null, string);
    }

    public XDMCursor getStylesheetCursor(String string) {
        return this.m_stylesheetCursors != null ? (XDMCursor)this.m_stylesheetCursors.get(string) : null;
    }

    public void setStylesheetCursor(String string, XDMCursor xDMCursor) {
        if (this.m_stylesheetCursors == null) {
            this.m_stylesheetCursors = new HashMap();
        }
        this.m_stylesheetCursors.put(string, xDMCursor);
    }

    public void addDocumentCursor(XDMCursor xDMCursor) {
        String string = xDMCursor.getDocumentBaseURI();
        if (string != null) {
            this.m_documents.put(string, xDMCursor);
        }
    }

    public void addDocumentCursor(XDMCursor xDMCursor, String string) {
        if (string != null) {
            this.m_documents.put(string, xDMCursor);
        }
    }

    public XDMCursor getDocumentMask(String string) {
        XDMCursor xDMCursor = (XDMCursor)this.m_documents.get(string);
        return xDMCursor;
    }

    public XDMCursor createGenericEmptyCursor() {
        return new XDMNodeAdapterEmpty(this);
    }

    public void reset() {
        this.m_stylesheetCursors = null;
        this.m_documents.clear();
        this.m_managerMap.clear();
    }
}

