/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.typechecker.v1;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.FunctionCall;
import com.ibm.xtq.ast.nodes.FunctionDecl;
import com.ibm.xtq.ast.nodes.Literal;
import com.ibm.xtq.ast.res.ASTBaseMsg;
import com.ibm.xtq.ast.res.ASTMsg;
import com.ibm.xtq.scontext.XStaticContext;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import com.ibm.xtq.xslt.res.ErrorMsg;
import com.ibm.xtq.xslt.runtime.JavaMethodResolver;
import com.ibm.xtq.xslt.runtime.res.RuntimeMsg;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator1;
import com.ibm.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xtq.xslt.translator.FunctionOperatorHelper;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xtq.xslt.typechecker.v1.CastHelper;
import com.ibm.xtq.xslt.typechecker.v1.MultiHashtable;
import com.ibm.xtq.xslt.typechecker.v1.ObjectFactory;
import com.ibm.xtq.xslt.typechecker.v1.TypeChecker1Base;
import com.ibm.xtq.xslt.typechecker.v1.types.MethodType;
import com.ibm.xtq.xslt.typechecker.v1.types.ObjectType;
import com.ibm.xtq.xslt.typechecker.v1.types.ReferenceType;
import com.ibm.xtq.xslt.typechecker.v1.types.Type;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public abstract class FunctionTypeChecker
extends TypeChecker1Base {
    private static final MultiHashtable _internal2Java = new MultiHashtable();
    private static final Hashtable _java2Internal = new Hashtable();
    protected boolean m_inKey = false;

    public FunctionTypeChecker(XPathCompiler xPathCompiler) {
        super(xPathCompiler);
    }

    @Override
    public Type visitFunction(FunctionCall functionCall) throws TypeCheckError {
        QName qName = functionCall.getFunctionQName();
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        if (this.isJAXPFunctionCall(functionCall)) {
            return this.jaxpFunctionCall(functionCall);
        }
        if (FunctionOperatorHelper.isStandardFunctionNamespace(string2)) {
            if (string.equals("concat")) {
                return this.concatCall(functionCall);
            }
            if (string.equals("document")) {
                return this.documentCall(functionCall);
            }
            if (string.equals("element-available")) {
                return this.elementAvailableCall(functionCall);
            }
            if (string.equals("format-number")) {
                return this.formatNumberCall(functionCall);
            }
            if (string.equals("function-available")) {
                return this.functionAvailableCall(functionCall);
            }
            if (string.equals("id")) {
                return this.idCall(functionCall);
            }
            if (string.equals("key")) {
                return this.keyCall(functionCall, string2, string);
            }
            if (string.equals("system-property")) {
                return this.systemPropertyCall(functionCall);
            }
            if (string.equals("sql")) {
                return this.sqlCall(functionCall);
            }
            return this.standardFunctionCall(functionCall, string2, string);
        }
        if (this.isStylesheetFunctionCall(functionCall)) {
            return this.stylesheetFunctionCall(functionCall);
        }
        if (FunctionOperatorHelper.isExtensionNamespace(string2)) {
            return this.extensionFunctionCall(functionCall);
        }
        return this.standardFunctionCall(functionCall, string2, string);
    }

    protected Type concatCall(FunctionCall functionCall) throws TypeCheckError {
        int n = functionCall.getOperandCount();
        if (n < 2) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_ARGUMENTS_CONCAT", (Object)functionCall.getFunctionQName().toString(), (Expr)functionCall);
            this._parser.reportError(3, errorMsg);
            return Type.String;
        }
        for (int i = 0; i < n; ++i) {
            Expr expr = functionCall.getOperand(i);
            Type type = this.visitExpression(expr);
            if (type.identicalTo(Type.String)) continue;
            CastHelper.setExpressionCastType(expr, Type.String);
        }
        return Type.String;
    }

    protected Type documentCall(FunctionCall functionCall) throws TypeCheckError {
        int n = functionCall.getOperandCount();
        if (n != 1 && n != 2) {
            ErrorMsg errorMsg = new ErrorMsg("ILLEGAL_ARG_ERR", (Object)functionCall.getFunctionQName().toString(), (Expr)functionCall);
            this._parser.reportError(3, errorMsg);
            return Type.NodeSet;
        }
        Expr expr = functionCall.getOperand(0);
        Type type = this.visitExpression(expr);
        if (!type.identicalTo(Type.String) && !type.identicalTo(Type.NodeSet)) {
            CastHelper.setExpressionCastType(expr, Type.String);
        }
        if (n == 2 && !(type = this.visitExpression(expr = functionCall.getOperand(1))).identicalTo(Type.Node) && !type.identicalTo(Type.NodeSet)) {
            ErrorMsg errorMsg = new ErrorMsg("DOCUMENT_ARG_ERR", (Object)functionCall);
            this._parser.reportError(3, errorMsg);
        }
        return Type.NodeSet;
    }

    protected Type elementAvailableCall(FunctionCall functionCall) throws TypeCheckError {
        this.checkNoOfArguments(functionCall);
        return Type.Boolean;
    }

    protected Type formatNumberCall(FunctionCall functionCall) throws TypeCheckError {
        Expr expr;
        XSLTCHelper.getStylesheet(functionCall).setNumberFormattingUsed(true);
        Type type = this.standardFunctionCall(functionCall);
        if (functionCall.getOperandCount() == 3 && (expr = functionCall.getOperand(2)) instanceof Literal) {
            QName qName = this.lookupStaticQName((Literal)expr, true, functionCall);
            ASTDecorator.setResolvedQNameArgument(expr, qName);
        }
        return type;
    }

    protected Type functionAvailableCall(FunctionCall functionCall) throws TypeCheckError {
        this.checkNoOfArguments(functionCall);
        Expr expr = functionCall.getOperand(0);
        if (expr instanceof Literal) {
            String string;
            XStaticContext xStaticContext;
            String string2;
            int n;
            String string3 = ((Literal)expr).getValue().trim();
            if (string3.length() == 0) {
                ErrorMsg errorMsg = new ErrorMsg("ERR_ARG_FUN_AVAILABLE", ((Literal)expr).getValue());
                this._parser.reportError(3, errorMsg);
            }
            if ((n = string3.indexOf(":")) != -1 && (string2 = (xStaticContext = this._parser.getStaticContext()).getNamespaceURI(string = string3.substring(0, n))) == null) {
                ErrorMsg errorMsg = new ErrorMsg("ERR_ARG_FUN_AVAILABLE", ((Literal)expr).getValue());
                this._parser.reportError(3, errorMsg);
            }
            boolean bl = this.getCompiler().getFOHelper().isFunctionAvailable(this._parser, functionCall);
            ASTDecorator.setFunctionAvailable(functionCall, bl);
        }
        return Type.Boolean;
    }

    protected Type idCall(FunctionCall functionCall) throws TypeCheckError {
        this._compiler.setHasIdCall(true);
        return this.standardFunctionCall(functionCall);
    }

    protected Type sqlCall(FunctionCall functionCall) throws TypeCheckError {
        int n = functionCall.getOperandCount();
        for (int i = 0; i < n; ++i) {
            Expr expr = functionCall.getOperand(i);
            Type type = this.visitExpression(expr);
            if (type.identicalTo(Type.String)) continue;
            CastHelper.setExpressionCastType(expr, Type.String);
        }
        return Type.Node;
    }

    protected Type keyCall(FunctionCall functionCall, String string, String string2) throws TypeCheckError {
        Type type = this.standardFunctionCall(functionCall, string, string2);
        if (this.m_inKey) {
            ASTMsg aSTMsg = new ASTMsg("RECURSIVE_KEY_CALL", this);
            throw new TypeCheckError(aSTMsg);
        }
        if (functionCall.getOperandCount() != 2) {
            Object var5_7 = null;
            ErrorMsg errorMsg = new ErrorMsg("ERR_FUNCTION_NOT_DEFINED_ARITY", (Object)functionCall.getFunctionQName().toString(), (Expr)functionCall);
            throw new TypeCheckError(errorMsg);
        }
        Expr expr = functionCall.getOperand(0);
        Expr expr2 = functionCall.getOperand(1);
        this.visitExpression(expr2);
        List list = this.typeCheckArguments(functionCall, false);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != Type.Reference) continue;
            return Type.Reference;
        }
        if (expr instanceof Literal) {
            QName qName = this.lookupStaticQName((Literal)expr, true, functionCall);
            ASTDecorator.setResolvedQNameArgument(expr, qName);
        }
        return type;
    }

    protected Type systemPropertyCall(FunctionCall functionCall) throws TypeCheckError {
        Expr expr;
        Type type = this.standardFunctionCall(functionCall);
        if (functionCall.getOperandCount() >= 1 && (expr = functionCall.getOperand(0)) instanceof Literal) {
            QName qName = this.lookupStaticQName((Literal)expr, true, functionCall);
            ASTDecorator.setResolvedQNameArgument(expr, qName);
        }
        return type;
    }

    protected MethodType checkNoOfArguments(FunctionCall functionCall, String string, String string2) throws TypeCheckError {
        List list = this.typeCheckArguments(functionCall, false);
        MethodType methodType = new MethodType(Type.Void, list);
        MethodType methodType2 = this.getCompiler().getFOHelper().resolveFunction(string, string2, methodType);
        if (methodType2 == null) {
            ErrorMsg errorMsg = new ErrorMsg("ERR_FUNCTION_NOT_DEFINED_ARITY", (Object)functionCall.getFunctionQName().toString(), (Expr)functionCall);
            this._parser.reportError(3, errorMsg);
        }
        return methodType2;
    }

    protected List typeCheckArguments(FunctionCall functionCall, boolean bl) throws TypeCheckError {
        int n = bl ? 1 : 0;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        int n2 = functionCall.getOperandCount();
        for (int i = n; i < n2; ++i) {
            Expr expr = functionCall.getOperand(i);
            arrayList.add(this.visitExpression(expr));
        }
        return arrayList;
    }

    protected MethodType checkNoOfArguments(FunctionCall functionCall) throws TypeCheckError {
        String string = functionCall.getFunctionQName().getNamespaceURI();
        String string2 = functionCall.getFunctionQName().getLocalPart();
        return this.checkNoOfArguments(functionCall, string, string2);
    }

    protected Type standardFunctionCall(FunctionCall functionCall) throws TypeCheckError {
        String string = functionCall.getFunctionQName().getNamespaceURI();
        String string2 = functionCall.getFunctionQName().getLocalPart();
        return this.standardFunctionCall(functionCall, string, string2);
    }

    protected Type standardFunctionCall(FunctionCall functionCall, String string, String string2) throws TypeCheckError {
        int n = functionCall.getOperandCount();
        MethodType methodType = this.checkNoOfArguments(functionCall, string, string2);
        if (methodType == null) {
            return Type.Reference;
        }
        for (int i = 0; i < n; ++i) {
            Expr expr;
            Type type = (Type)methodType.argsType().get(i);
            if (type.identicalTo(ASTDecorator1.getType(expr = functionCall.getOperand(i)))) continue;
            CastHelper.setExpressionCastType(expr, type);
        }
        Type type = methodType.resultType();
        ASTDecorator1.setType(functionCall, type);
        return type;
    }

    protected Type extensionFunctionCall(FunctionCall functionCall) throws TypeCheckError {
        QName qName = functionCall.getFunctionQName();
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        FunctionOperatorHelper functionOperatorHelper = this.getCompiler().getFOHelper();
        String string3 = functionOperatorHelper.getClassNameFromUri(string);
        boolean bl = false;
        int n = 0;
        Class clazz = null;
        int n2 = string2.lastIndexOf(46);
        if (n2 > 0) {
            bl = true;
            if (string3 != null && string3.length() > 0) {
                n = 2;
                string3 = string3 + "." + string2.substring(0, n2);
            } else {
                n = 0;
                string3 = string2.substring(0, n2);
            }
            string2 = string2.substring(n2 + 1);
        } else {
            if (string3 != null && string3.length() > 0) {
                try {
                    clazz = ObjectFactory.findProviderClass(string3, ObjectFactory.findClassLoader(), true);
                    n = 1;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    n = 2;
                }
            } else {
                n = 0;
            }
            if (functionOperatorHelper.lookupPrimfunc(string, string2) != null) {
                Type type = this.standardFunctionCall(functionCall, string, string2);
                if (FunctionOperatorHelper.isNodesetExtensionCall(string, string2)) {
                    this._compiler.setCallsNodeset(true);
                }
                Method method = null;
                try {
                    method = this.lookupPredefinedExtension(string, string2, functionCall.getOperandCount());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (method != null) {
                    this.getCompiler().getResolvedExtensionMap().addMethod(functionCall, method);
                }
                return type;
            }
        }
        return this.externalFunctionCall(functionCall, clazz, string2, string3, bl, n);
    }

    protected Type constructorCall(FunctionCall functionCall, Class clazz, String string) throws TypeCheckError {
        List list;
        int n;
        List list2 = this.typeCheckArguments(functionCall, false);
        for (n = 0; n < list2.size(); ++n) {
            if (list2.get(n) != Type.Reference) continue;
            ASTDecorator.setMethodName(functionCall, "new");
            ASTDecorator.setClassName(functionCall, string);
            return Type.Reference;
        }
        n = functionCall.getOperandCount();
        if (clazz == null) {
            try {
                clazz = ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                RuntimeMsg runtimeMsg = new RuntimeMsg("CLASS_NOT_FOUND_ERR", (Object)string, functionCall);
                ASTDecorator.setFunctionCallErrorMessage(functionCall, runtimeMsg);
                return Type.Reference;
            }
        }
        if ((list = JavaMethodResolver.findConstructors(clazz, n)) == null || list.isEmpty()) {
            RuntimeMsg runtimeMsg = new RuntimeMsg("CONSTRUCTOR_NOT_FOUND", (Object)string, functionCall);
            ASTDecorator.setFunctionCallErrorMessage(functionCall, runtimeMsg);
            return Type.Reference;
        }
        int n2 = list.size();
        int n3 = Integer.MAX_VALUE;
        ObjectType objectType = null;
        Constructor constructor = null;
        for (int i = 0; i < n2; ++i) {
            int n4;
            Constructor constructor2 = (Constructor)list.get(i);
            Class<?>[] classArray = constructor2.getParameterTypes();
            Class<?> clazz2 = null;
            int n5 = 0;
            for (n4 = 0; n4 < n; ++n4) {
                clazz2 = classArray[n4];
                Type type = (Type)list2.get(n4);
                Object object = _internal2Java.maps(type, clazz2);
                if (object != null) {
                    n5 += ((JavaType)object).distance;
                    continue;
                }
                if (type instanceof ObjectType) {
                    ObjectType objectType2 = (ObjectType)type;
                    if (objectType2.isSameClass(clazz2)) continue;
                    if (objectType2.isAssignableTo(clazz2)) {
                        ++n5;
                        continue;
                    }
                    n5 = Integer.MAX_VALUE;
                    break;
                }
                n5 = Integer.MAX_VALUE;
                break;
            }
            if (n4 != n || n5 >= n3) continue;
            constructor = constructor2;
            n3 = n5;
            objectType = clazz != null ? new ObjectType(clazz) : new ObjectType(string);
        }
        if (constructor != null) {
            this.getCompiler().getResolvedExtensionMap().addConstructor(functionCall, constructor);
        }
        if (objectType != null) {
            ASTDecorator1.setType(functionCall, objectType);
            return objectType;
        }
        String string2 = XSLTCHelper.getMethodSignature(string, "<init>", list2);
        RuntimeMsg runtimeMsg = new RuntimeMsg("ARGUMENT_CONVERSION_ERR", (Object)string2, functionCall);
        ASTDecorator.setFunctionCallErrorMessage(functionCall, runtimeMsg);
        return Type.Reference;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Type externalFunctionCall(FunctionCall functionCall, Class clazz, String string, String string2, boolean bl, int n) throws TypeCheckError {
        List list;
        int n2 = functionCall.getOperandCount();
        Expr expr = null;
        boolean bl2 = false;
        if (string.equals("new")) {
            return this.constructorCall(functionCall, clazz, string2);
        }
        List list2 = this.typeCheckArguments(functionCall, bl2);
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i) != Type.Reference) continue;
            ASTDecorator.setMethodName(functionCall, string);
            ASTDecorator.setClassName(functionCall, string2);
            return Type.Reference;
        }
        if (n2 == 0) {
            bl = true;
        }
        if (!bl) {
            Type type = (Type)list2.get(0);
            if (n == 0 || n == 2) {
                bl2 = true;
            }
            if (n == 1 && type instanceof ObjectType && clazz != null && ((ObjectType)type).isAssignableTo(clazz)) {
                bl2 = true;
            }
            if (bl2) {
                expr = functionCall.getOperand(0);
                --n2;
                if (!(type instanceof ObjectType)) {
                    RuntimeMsg runtimeMsg = new RuntimeMsg("NO_JAVA_FUNCT_THIS_REF", (Object)string, functionCall);
                    ASTDecorator.setFunctionCallErrorMessage(functionCall, runtimeMsg);
                    return Type.Reference;
                }
                string2 = ((ObjectType)type).getJavaClassName();
            }
        } else if (string2.length() == 0) {
            RuntimeMsg runtimeMsg = new RuntimeMsg("FUNCTION_RESOLVE_ERR", (Object)functionCall.getFunctionQName().toString(), functionCall);
            ASTDecorator.setFunctionCallErrorMessage(functionCall, runtimeMsg);
            return Type.Reference;
        }
        if (clazz == null) {
            try {
                clazz = ObjectFactory.findProviderClass(string2, ObjectFactory.findClassLoader(), true);
            }
            catch (ClassNotFoundException classNotFoundException) {
                RuntimeMsg runtimeMsg = new RuntimeMsg("CLASS_NOT_FOUND_ERR", (Object)string2, functionCall);
                ASTDecorator.setFunctionCallErrorMessage(functionCall, runtimeMsg);
                return Type.Reference;
            }
        }
        if ((list = JavaMethodResolver.findMethods(clazz, string, n2)) == null || list.isEmpty()) {
            RuntimeMsg runtimeMsg = new RuntimeMsg("FUNCTION_RESOLVE_ERR", (Object)functionCall.getFunctionQName().toString(), functionCall);
            ASTDecorator.setFunctionCallErrorMessage(functionCall, runtimeMsg);
            return Type.Reference;
        }
        Class<?> clazz2 = null;
        int n3 = list.size();
        if (bl2) {
            list2.remove(0);
        }
        int n4 = Integer.MAX_VALUE;
        Type type = null;
        Method method = null;
        int n5 = 0;
        while (true) {
            int n6;
            int n7;
            Class<?>[] classArray;
            Method method2;
            if (n5 < n3) {
                method2 = (Method)list.get(n5);
                classArray = method2.getParameterTypes();
                n7 = 0;
            } else {
                if (method != null && expr == null && !Modifier.isStatic(method.getModifiers()) && !JavaMethodResolver.hasConstructors(string2, 0)) {
                    RuntimeMsg runtimeMsg = new RuntimeMsg("NO_DEFAULT_CONSTRUCTOR_ERR", (Object)string2, functionCall);
                    ASTDecorator.setFunctionCallErrorMessage(functionCall, runtimeMsg);
                    return Type.Reference;
                }
                if (method != null) {
                    this.getCompiler().getResolvedExtensionMap().addMethod(functionCall, method);
                }
                if (expr != null) {
                    ASTDecorator.setThisArgumentF(functionCall, expr);
                }
                if (type != null) {
                    ASTDecorator1.setType(functionCall, type);
                    return type;
                }
                String string3 = XSLTCHelper.getMethodSignature(string2, string, list2);
                RuntimeMsg runtimeMsg = new RuntimeMsg("ARGUMENT_CONVERSION_ERR", (Object)string3, functionCall);
                ASTDecorator.setFunctionCallErrorMessage(functionCall, runtimeMsg);
                return Type.Reference;
            }
            for (n6 = 0; n6 < n2; ++n6) {
                clazz2 = classArray[n6];
                Type type2 = (Type)list2.get(n6);
                Object object = _internal2Java.maps(type2, clazz2);
                if (object != null) {
                    n7 += ((JavaType)object).distance;
                    continue;
                }
                if (type2 instanceof ReferenceType) {
                    ++n7;
                    continue;
                }
                if (type2 instanceof ObjectType) {
                    ObjectType objectType = (ObjectType)type2;
                    if (clazz2.getName().equals(objectType.getJavaClassName())) {
                        n7 += 0;
                        continue;
                    }
                    if (objectType.isAssignableTo(clazz2)) {
                        ++n7;
                        continue;
                    }
                    n7 = Integer.MAX_VALUE;
                    break;
                }
                n7 = Integer.MAX_VALUE;
                break;
            }
            if (n6 == n2) {
                clazz2 = method2.getReturnType();
                type = (Type)_java2Internal.get(clazz2);
                if (type == null) {
                    type = new ObjectType(clazz2);
                }
                if (type != null && n7 < n4) {
                    method = method2;
                    n4 = n7;
                }
            }
            ++n5;
        }
    }

    protected boolean isStylesheetFunctionCall(FunctionCall functionCall) {
        return XSLTCHelper.isStylesheetFunctionCall(functionCall, this._compiler);
    }

    protected Type stylesheetFunctionCall(FunctionCall functionCall) throws TypeCheckError {
        FunctionDecl functionDecl = XSLTCHelper.getStylesheetFunctionCall(functionCall, this._compiler);
        if (functionDecl == null) {
            throw new TypeCheckError(functionCall);
        }
        ASTDecorator2.setFunction(functionCall, functionDecl);
        MethodType methodType = XSLTCHelper.generateTypeForFunction(functionCall, this._compiler);
        if (null == methodType) {
            throw new TypeCheckError("TYPE_CHECK_ERR", functionCall.getFunctionQName().toString(), this);
        }
        int n = functionCall.getOperandCount();
        for (int i = 0; i < n; ++i) {
            Expr expr;
            Type type;
            Type type2 = (Type)methodType.argsType().get(i);
            if (type2.identicalTo(type = this.visitExpression(expr = functionCall.getOperand(i)))) continue;
            CastHelper.setExpressionCastType(expr, type2);
        }
        Type type = methodType.resultType();
        ASTDecorator1.setType(functionCall, type);
        return type;
    }

    protected boolean isJAXPFunctionCall(FunctionCall functionCall) {
        return XSLTCHelper.isJAXPFunctionCall(functionCall, this._compiler);
    }

    protected Type jaxpFunctionCall(FunctionCall functionCall) throws TypeCheckError {
        return Type.Object;
    }

    protected QName lookupStaticQName(Literal literal, boolean bl, Expr expr) {
        Object object;
        String string = literal.getStringLiteral();
        if (!this.getParser().isValidQName(string)) {
            object = new ASTMsg("INVALID_QNAME_ERR_XTQHP", (Object)string, expr);
            this._parser.reportError(3, (ASTBaseMsg)object);
        }
        object = bl ? this.getParser().getQNameIgnoreDefaultNs(string) : this.getParser().getQName(string);
        return object;
    }

    private Method lookupPredefinedExtension(String string, String string2, int n) throws ClassNotFoundException {
        String string3;
        int n2;
        Object object;
        String string4 = this.getCompiler().getFOHelper().getClassName(string);
        if (string4 == null) {
            return null;
        }
        Class clazz = ObjectFactory.findProviderClass(string4, ObjectFactory.findClassLoader(), true);
        if (clazz == null) {
            return null;
        }
        if (string2.indexOf(45) > 0) {
            object = new StringBuffer("");
            for (n2 = 0; n2 < string2.length(); ++n2) {
                if (n2 > 0 && string2.charAt(n2 - 1) == '-') {
                    ((StringBuffer)object).append(Character.toUpperCase(string2.charAt(n2)));
                    continue;
                }
                if (string2.charAt(n2) == '-') continue;
                ((StringBuffer)object).append(string2.charAt(n2));
            }
            string3 = ((StringBuffer)object).toString();
        } else {
            string3 = string2;
        }
        object = JavaMethodResolver.findMethods(clazz, string3);
        for (n2 = 0; n2 < object.size(); ++n2) {
            Method method = (Method)object.get(n2);
            if (method.getParameterTypes().length != n) continue;
            return method;
        }
        return null;
    }

    static {
        Class<Object> clazz = Object.class;
        Class<String> clazz2 = String.class;
        Class<Boolean> clazz3 = Boolean.class;
        Class<Node> clazz4 = Node.class;
        Class<NodeList> clazz5 = NodeList.class;
        Class<NodeIterator> clazz6 = NodeIterator.class;
        Class<DocumentFragment> clazz7 = DocumentFragment.class;
        Class<Character> clazz8 = Character.class;
        Class<Byte> clazz9 = Byte.class;
        Class<Short> clazz10 = Short.class;
        Class<Integer> clazz11 = Integer.class;
        Class<Long> clazz12 = Long.class;
        Class<Float> clazz13 = Float.class;
        Class<Double> clazz14 = Double.class;
        _internal2Java.put(Type.Boolean, new JavaType(Boolean.TYPE, 0));
        _internal2Java.put(Type.Boolean, new JavaType(Boolean.class, 1));
        _internal2Java.put(Type.Boolean, new JavaType(clazz, 2));
        _internal2Java.put(Type.Boolean, new JavaType(clazz2, 3));
        _internal2Java.put(Type.Real, new JavaType(Double.TYPE, 0));
        _internal2Java.put(Type.Real, new JavaType(Double.class, 1));
        _internal2Java.put(Type.Real, new JavaType(Number.class, 2));
        _internal2Java.put(Type.Real, new JavaType(Float.TYPE, 3));
        _internal2Java.put(Type.Real, new JavaType(Long.TYPE, 4));
        _internal2Java.put(Type.Real, new JavaType(Integer.TYPE, 5));
        _internal2Java.put(Type.Real, new JavaType(Short.TYPE, 6));
        _internal2Java.put(Type.Real, new JavaType(Character.TYPE, 7));
        _internal2Java.put(Type.Real, new JavaType(Byte.TYPE, 8));
        _internal2Java.put(Type.Real, new JavaType(Boolean.TYPE, 9));
        _internal2Java.put(Type.Real, new JavaType(clazz2, 10));
        _internal2Java.put(Type.Real, new JavaType(clazz, 11));
        _internal2Java.put(Type.Int, new JavaType(Integer.TYPE, 0));
        _internal2Java.put(Type.Int, new JavaType(Double.class, 1));
        _internal2Java.put(Type.Int, new JavaType(Number.class, 2));
        _internal2Java.put(Type.Int, new JavaType(Long.TYPE, 3));
        _internal2Java.put(Type.Int, new JavaType(Double.TYPE, 4));
        _internal2Java.put(Type.Int, new JavaType(Float.TYPE, 5));
        _internal2Java.put(Type.Int, new JavaType(Short.TYPE, 6));
        _internal2Java.put(Type.Int, new JavaType(Character.TYPE, 7));
        _internal2Java.put(Type.Int, new JavaType(Byte.TYPE, 8));
        _internal2Java.put(Type.Int, new JavaType(Boolean.TYPE, 9));
        _internal2Java.put(Type.Int, new JavaType(clazz2, 10));
        _internal2Java.put(Type.Int, new JavaType(clazz, 11));
        _internal2Java.put(Type.String, new JavaType(clazz2, 0));
        _internal2Java.put(Type.String, new JavaType(clazz, 1));
        _internal2Java.put(Type.String, new JavaType(Character.TYPE, 2));
        _internal2Java.put(Type.String, new JavaType(Double.TYPE, 3));
        _internal2Java.put(Type.String, new JavaType(Float.TYPE, 3));
        _internal2Java.put(Type.String, new JavaType(Long.TYPE, 3));
        _internal2Java.put(Type.String, new JavaType(Integer.TYPE, 3));
        _internal2Java.put(Type.String, new JavaType(Short.TYPE, 3));
        _internal2Java.put(Type.String, new JavaType(Byte.TYPE, 3));
        _internal2Java.put(Type.String, new JavaType(Boolean.TYPE, 4));
        _internal2Java.put(Type.NodeSet, new JavaType(clazz6, 0));
        _internal2Java.put(Type.NodeSet, new JavaType(clazz5, 1));
        _internal2Java.put(Type.NodeSet, new JavaType(clazz4, 2));
        _internal2Java.put(Type.NodeSet, new JavaType(clazz2, 3));
        _internal2Java.put(Type.NodeSet, new JavaType(clazz, 5));
        _internal2Java.put(Type.NodeSet, new JavaType(Character.TYPE, 6));
        _internal2Java.put(Type.NodeSet, new JavaType(Double.TYPE, 7));
        _internal2Java.put(Type.NodeSet, new JavaType(Float.TYPE, 7));
        _internal2Java.put(Type.NodeSet, new JavaType(Long.TYPE, 7));
        _internal2Java.put(Type.NodeSet, new JavaType(Integer.TYPE, 7));
        _internal2Java.put(Type.NodeSet, new JavaType(Short.TYPE, 7));
        _internal2Java.put(Type.NodeSet, new JavaType(Byte.TYPE, 7));
        _internal2Java.put(Type.NodeSet, new JavaType(Boolean.TYPE, 8));
        _internal2Java.put(Type.Node, new JavaType(clazz6, 0));
        _internal2Java.put(Type.Node, new JavaType(clazz5, 1));
        _internal2Java.put(Type.Node, new JavaType(clazz4, 2));
        _internal2Java.put(Type.Node, new JavaType(clazz2, 3));
        _internal2Java.put(Type.Node, new JavaType(clazz, 5));
        _internal2Java.put(Type.Node, new JavaType(Character.TYPE, 6));
        _internal2Java.put(Type.Node, new JavaType(Double.TYPE, 7));
        _internal2Java.put(Type.Node, new JavaType(Float.TYPE, 7));
        _internal2Java.put(Type.Node, new JavaType(Long.TYPE, 7));
        _internal2Java.put(Type.Node, new JavaType(Integer.TYPE, 7));
        _internal2Java.put(Type.Node, new JavaType(Short.TYPE, 7));
        _internal2Java.put(Type.Node, new JavaType(Byte.TYPE, 7));
        _internal2Java.put(Type.Node, new JavaType(Boolean.TYPE, 8));
        _internal2Java.put(Type.ResultTree, new JavaType(clazz6, 0));
        _internal2Java.put(Type.ResultTree, new JavaType(clazz5, 1));
        _internal2Java.put(Type.ResultTree, new JavaType(clazz4, 2));
        _internal2Java.put(Type.ResultTree, new JavaType(clazz2, 3));
        _internal2Java.put(Type.ResultTree, new JavaType(clazz, 5));
        _internal2Java.put(Type.ResultTree, new JavaType(Character.TYPE, 6));
        _internal2Java.put(Type.ResultTree, new JavaType(Double.TYPE, 7));
        _internal2Java.put(Type.ResultTree, new JavaType(Float.TYPE, 7));
        _internal2Java.put(Type.ResultTree, new JavaType(Long.TYPE, 7));
        _internal2Java.put(Type.ResultTree, new JavaType(Integer.TYPE, 7));
        _internal2Java.put(Type.ResultTree, new JavaType(Short.TYPE, 7));
        _internal2Java.put(Type.ResultTree, new JavaType(Byte.TYPE, 7));
        _internal2Java.put(Type.ResultTree, new JavaType(Boolean.TYPE, 8));
        _internal2Java.put(Type.Reference, new JavaType(clazz, 0));
        _java2Internal.put(Void.TYPE, Type.Void);
        _java2Internal.put(Byte.TYPE, Type.Real);
        _java2Internal.put(Short.TYPE, Type.Real);
        _java2Internal.put(Integer.TYPE, Type.Real);
        _java2Internal.put(Long.TYPE, Type.Real);
        _java2Internal.put(Float.TYPE, Type.Real);
        _java2Internal.put(Double.TYPE, Type.Real);
        _java2Internal.put(clazz9, Type.Real);
        _java2Internal.put(clazz10, Type.Real);
        _java2Internal.put(clazz11, Type.Real);
        _java2Internal.put(clazz12, Type.Real);
        _java2Internal.put(clazz13, Type.Real);
        _java2Internal.put(clazz14, Type.Real);
        _java2Internal.put(clazz2, Type.String);
        _java2Internal.put(Boolean.TYPE, Type.Boolean);
        _java2Internal.put(clazz3, Type.Boolean);
        _java2Internal.put(clazz, Type.Reference);
        _java2Internal.put(clazz6, Type.NodeSet);
        _java2Internal.put(clazz5, Type.NodeSet);
        _java2Internal.put(clazz4, Type.NodeSet);
        _java2Internal.put(clazz7, Type.ResultTree);
    }

    static class JavaType {
        public Class type;
        public int distance;

        public JavaType(Class clazz, int n) {
            this.type = clazz;
            this.distance = n;
        }

        public boolean equals(Object object) {
            return object.equals(this.type);
        }
    }
}

