/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.optimizers;

import com.ibm.xtq.xslt.translator.SerializationHelper;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.types.SAXEventsLibrary;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.Type;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.instructions.AndInstruction;
import com.ibm.xylem.instructions.AssertTypeInstruction;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.LambdaInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xylem.instructions.NotInstruction;
import com.ibm.xylem.instructions.OrInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.TypeMatchInstruction;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SAXEventStreamOptimizer
extends Optimizer {
    private static Type s_saxEventStreamType = null;
    private static Type s_saxEventType = null;
    private static HashSet s_visitedFunctions;
    public static final boolean s_verbose = false;

    public static String getStringFromInstruction(Instruction instruction) {
        if (instruction instanceof CoerceInstruction) {
            CoerceInstruction coerceInstruction = (CoerceInstruction)instruction;
            if (coerceInstruction.getType().equals(CharType.s_charType.getStreamType())) {
                return SAXEventStreamOptimizer.getStringFromInstruction(coerceInstruction.getOperand());
            }
            return null;
        }
        if (instruction instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            String string = streamInstruction.getStringContent();
            if (null != string) {
                return string;
            }
            if (streamInstruction.getElementType().equals(CharType.s_charType) && 1 == streamInstruction.getChildInstructionCount()) {
                return SAXEventStreamOptimizer.getStringFromInstruction(streamInstruction.getChildInstruction(0));
            }
            return null;
        }
        if (instruction instanceof LetInstruction) {
            LetInstruction letInstruction = (LetInstruction)instruction;
            return SAXEventStreamOptimizer.getStringFromInstruction(letInstruction.getBody());
        }
        return null;
    }

    private void initialize() {
        if (null == s_saxEventStreamType) {
            s_saxEventStreamType = SAXEventsLibrary.getSAXEventStream();
            s_saxEventType = SAXEventsLibrary.getSAXEvent();
        }
        s_visitedFunctions = new HashSet();
    }

    private void cleanup() {
        s_visitedFunctions = null;
    }

    @Override
    public void optimizeFunction(Function function) {
        this.initialize();
        s_visitedFunctions.add(function.getName());
        super.optimizeFunction(function);
        this.cleanup();
    }

    @Override
    public Instruction optimize(Instruction instruction) {
        return super.optimize(instruction);
    }

    Instruction optimizeAttrSerializerGuard(Instruction instruction, AttributeInfoArray attributeInfoArray, boolean bl) {
        TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
        if (instruction instanceof StreamInstruction) {
            StreamInstruction streamInstruction = (StreamInstruction)instruction;
            StreamInstruction streamInstruction2 = (StreamInstruction)streamInstruction.cloneWithoutTypeInformation();
            Type type = streamInstruction.getElementType();
            if (!type.equals(s_saxEventType)) {
                return instruction;
            }
            int n = streamInstruction.getChildInstructionCount();
            for (int i = 0; i < n; ++i) {
                Instruction instruction2 = this.optimizeAttrSerializerGuard(streamInstruction.getChildInstruction(i), attributeInfoArray, bl);
                if (null == instruction2) {
                    attributeInfoArray.leavingStream(streamInstruction2);
                    return streamInstruction2;
                }
                streamInstruction2.setChildInstruction(i, instruction2);
            }
            attributeInfoArray.leavingStream(streamInstruction2);
            return streamInstruction2;
        }
        if (instruction instanceof ChooseInstruction) {
            Object object;
            int n;
            ChooseInstruction chooseInstruction = (ChooseInstruction)instruction;
            ChooseInstruction chooseInstruction2 = (ChooseInstruction)chooseInstruction.cloneWithoutTypeInformation();
            AttributeInfoArray attributeInfoArray2 = new AttributeInfoArray(attributeInfoArray);
            Instruction instruction3 = LiteralInstruction.booleanFalseLiteral();
            Instruction instruction4 = chooseInstruction.getDefaultHandler();
            int n2 = chooseInstruction.m_cases.length + (null == instruction4 ? 0 : 1);
            AttributeInfoArray[] attributeInfoArrayArray = new AttributeInfoArray[n2];
            Instruction[] instructionArray = new Instruction[n2];
            for (n = 0; n < chooseInstruction.m_cases.length; ++n) {
                attributeInfoArrayArray[n] = new AttributeInfoArray();
                instructionArray[n] = chooseInstruction.m_cases[n].getTest();
                instruction3 = new OrInstruction(instruction3, chooseInstruction.m_cases[n].getTest());
                object = this.optimizeAttrSerializerGuard(chooseInstruction.m_cases[n].getHandler(), attributeInfoArrayArray[n], bl);
                if (null == object) continue;
                chooseInstruction2.m_cases[n].setHandler((Instruction)object);
            }
            instruction3 = new NotInstruction(instruction3);
            if (instruction4 != null) {
                n = chooseInstruction.m_cases.length;
                attributeInfoArrayArray[n] = new AttributeInfoArray();
                instructionArray[n] = instruction3;
                object = this.optimizeAttrSerializerGuard(instruction4, attributeInfoArrayArray[n], bl);
                if (null != object) {
                    chooseInstruction2.setDefaultHandler((Instruction)object);
                }
            }
            if (n2 == 0) {
                return chooseInstruction2;
            }
            HashSet hashSet = new HashSet();
            object = new Set[n2];
            for (int i = 0; i < n2; ++i) {
                object[i] = attributeInfoArrayArray[i].getAllAttrNames();
                hashSet.addAll(object[i]);
            }
            for (String string : hashSet) {
                Object object2;
                int n3;
                if (null == string) {
                    attributeInfoArray.add(AttributeInfo.newUnknown());
                    return null;
                }
                boolean[] blArray = new boolean[n2];
                boolean bl2 = true;
                boolean bl3 = true;
                for (n3 = 0; n3 < n2; ++n3) {
                    blArray[n3] = object[n3].contains(string);
                    if (!blArray[n3]) {
                        bl2 = false;
                        continue;
                    }
                    object2 = attributeInfoArrayArray[n3].get(string);
                    if (((AttributeInfo[])object2).length == 1 && null == object2[0].getConditional()) continue;
                    bl2 = false;
                    bl3 = false;
                }
                if (bl2) {
                    MultiBranchAttributeInfo multiBranchAttributeInfo = new MultiBranchAttributeInfo(string, bl);
                    for (int i = 0; i < n2; ++i) {
                        AttributeInfo attributeInfo = attributeInfoArrayArray[i].get(string)[0];
                        attributeInfo.restrictConditional(instructionArray[i]);
                        multiBranchAttributeInfo.addCase(attributeInfo);
                    }
                    attributeInfoArray.add(multiBranchAttributeInfo);
                    continue;
                }
                if (attributeInfoArray.getAllAttrNames().contains(string) && 1 == attributeInfoArray.get(string).length && null == attributeInfoArray.get(string)[0].getConditional() && bl3) {
                    AttributeInfo attributeInfo = attributeInfoArray.get(string)[0];
                    object2 = new MultiBranchAttributeInfo(string, bl);
                    for (int i = 0; i < n2; ++i) {
                        if (!blArray[i]) continue;
                        AttributeInfo attributeInfo2 = attributeInfoArrayArray[i].get(string)[0];
                        attributeInfo2.restrictConditional(instructionArray[i]);
                        ((MultiBranchAttributeInfo)object2).addCase(attributeInfo2);
                    }
                    ((MultiBranchAttributeInfo)object2).setOriginalNeedsGuard();
                    attributeInfoArray.add((AttributeInfo)object2);
                    continue;
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    if (!blArray[n3]) continue;
                    object2 = attributeInfoArrayArray[n3].get(string);
                    for (int i = 0; i < ((AttributeInfo[])object2).length; ++i) {
                        object2[i].restrictConditional(instructionArray[n3]);
                        attributeInfoArray.add(object2[i]);
                    }
                }
            }
            return chooseInstruction2;
        }
        if (instruction instanceof ModuleFunctionCallInstruction) {
            ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction;
            if (moduleFunctionCallInstruction.getModule().equals("xslt1")) {
                if (moduleFunctionCallInstruction.getFunction().startsWith("start-tag-event")) {
                    return null;
                }
                if (moduleFunctionCallInstruction.getFunction().equals("modifySpecialAttributeForElement")) {
                    attributeInfoArray.add(AttributeInfo.newUnknown());
                    return null;
                }
                if (moduleFunctionCallInstruction.getFunction().equals("xsl-copy")) {
                    return this.optimizeAttrSerializerGuard(moduleFunctionCallInstruction.getParameters()[1], attributeInfoArray, bl);
                }
                if (moduleFunctionCallInstruction.getFunction().equals("fix-html-special-attributes")) {
                    attributeInfoArray.add(AttributeInfo.newUnknown());
                    return null;
                }
                throw new StaticError("ERR_SYSTEM", "SAXEventStreamOptimizer: oops 1 - code not written yet: " + moduleFunctionCallInstruction.getFunction());
            }
            throw new StaticError("ERR_SYSTEM", "SAXEventStreamOptimizer: oops 2 - code not written yet: " + moduleFunctionCallInstruction.getModule());
        }
        if (instruction instanceof FunctionCallInstruction) {
            FunctionCallInstruction functionCallInstruction = (FunctionCallInstruction)instruction;
            if (!s_visitedFunctions.contains(functionCallInstruction.getFunction())) {
                s_visitedFunctions.add(functionCallInstruction.getFunction());
                this.optimizeAttrSerializerGuard(functionCallInstruction.getInstantiation().m_function.getBody(), attributeInfoArray, true);
            }
            return instruction;
        }
        if (instruction instanceof CoerceInstruction || instruction instanceof AssertTypeInstruction) {
            Instruction instruction5;
            Type type;
            Object object;
            if (instruction instanceof CoerceInstruction) {
                object = (CoerceInstruction)instruction;
                type = ((Instruction)object).getCachedType();
                instruction5 = ((UnaryPrimopInstruction)object).getOperand();
                boolean bl4 = true;
            } else {
                object = (AssertTypeInstruction)instruction;
                type = ((Instruction)object).getCachedType();
                instruction5 = ((UnaryPrimopInstruction)object).getOperand();
                boolean bl5 = false;
            }
            if (type.equals(CharType.s_charType.getStreamType())) {
                return null;
            }
            if (!type.equals(s_saxEventStreamType) && !(type instanceof TypeVariable)) {
                throw new StaticError("ERR_SYSTEM", "Should never happen:  attributes is a stream of bad type");
            }
            if (instruction5 instanceof StreamInstruction) {
                object = ((StreamInstruction)instruction5).getElementType();
                if (object.equals(CharType.s_charType)) {
                    return null;
                }
                if (object.equals(s_saxEventType)) {
                    Instruction instruction6 = this.optimizeAttrSerializerGuard(instruction5, attributeInfoArray, bl);
                    if (null == instruction6) {
                        return null;
                    }
                    return instruction6;
                }
                throw new StaticError("ERR_SYSTEM", "Should never happen: attibutes is of a stream of unexpected type");
            }
            object = this.optimizeAttrSerializerGuard(instruction5, attributeInfoArray, bl);
            if (null == object) {
                return null;
            }
            Instruction instruction7 = instruction.cloneWithoutTypeInformation();
            instruction7.setChildInstruction(0, (Instruction)object);
            return instruction7;
        }
        if (instruction instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction constructorInstantiationInstruction = (ConstructorInstantiationInstruction)instruction;
            Type type = constructorInstantiationInstruction.getCachedType();
            if (!type.equals(s_saxEventType)) {
                return instruction;
            }
            String string = constructorInstantiationInstruction.getConstructorName();
            if (string.equals("beginAttribute")) {
                AttributeInfo attributeInfo = new AttributeInfo(constructorInstantiationInstruction.getChildInstruction(0), bl);
                attributeInfoArray.add(attributeInfo);
            } else if (string.equals("beginAttributeHTML")) {
                AttributeInfo attributeInfo = new AttributeInfo(constructorInstantiationInstruction.getOperands()[0], bl);
                attributeInfo.setDone();
                attributeInfoArray.add(attributeInfo);
            } else if (string.equals("addAttrText")) {
                AttributeInfo attributeInfo = attributeInfoArray.get(attributeInfoArray.size() - 1);
                attributeInfo.appendValue(constructorInstantiationInstruction.getChildInstruction(0));
            } else if (string.equals("addAttrTextNoEscaping")) {
                AttributeInfo attributeInfo = attributeInfoArray.get(attributeInfoArray.size() - 1);
                attributeInfo.appendValue(constructorInstantiationInstruction.getChildInstruction(0));
            } else if (string.equals("addText") || string.equals("addTextNoEscaping")) {
                AttributeInfo attributeInfo = attributeInfoArray.getLast();
                if (null == attributeInfo || attributeInfo.isDone()) {
                    return null;
                }
                attributeInfo.appendValue(constructorInstantiationInstruction.getChildInstruction(0));
            } else {
                if (string.equals("beginElementNS") || string.equals("addComment") || string.equals("beginElement") || string.equals("processingInstruction")) {
                    return null;
                }
                if (string.equals("endAttribute")) {
                    AttributeInfo attributeInfo = attributeInfoArray.get(attributeInfoArray.size() - 1);
                    attributeInfo.setDone();
                } else if (!string.equals("declareNamespaceTable")) {
                    throw new StaticError("ERR_SYSTEM", "Don't know how to deal with SAXEvent: " + string);
                }
            }
        } else {
            if (instruction instanceof LetInstruction) {
                LetInstruction letInstruction = (LetInstruction)instruction;
                LetInstruction letInstruction2 = (LetInstruction)letInstruction.cloneWithoutTypeInformation();
                Type type = letInstruction.getCachedType();
                Instruction instruction8 = letInstruction.getBody();
                if (type.equals(CharType.s_charType.getStreamType())) {
                    return null;
                }
                if (!type.equals(s_saxEventStreamType) && !(type instanceof TypeVariable)) {
                    throw new StaticError("ERR_SYSTEM", "Should never happen:  attributes is a stream of bad type");
                }
                if (instruction8 instanceof StreamInstruction) {
                    Type type2 = ((StreamInstruction)instruction8).getElementType();
                    if (type2.equals(CharType.s_charType)) {
                        return null;
                    }
                    if (type2.equals(s_saxEventType)) {
                        Instruction instruction9 = this.optimizeAttrSerializerGuard(instruction8, attributeInfoArray, bl);
                        if (null == instruction9) {
                            return null;
                        }
                        letInstruction2.setBody(instruction9);
                        return letInstruction2;
                    }
                    throw new StaticError("ERR_SYSTEM", "Should never happen: attibutes is of a stream of unexpected type");
                }
                Instruction instruction10 = this.optimizeAttrSerializerGuard(instruction8, attributeInfoArray, bl);
                if (null == instruction10) {
                    return null;
                }
                letInstruction2.setBody(instruction10);
                return letInstruction2;
            }
            if (instruction instanceof TypeMatchInstruction) {
                attributeInfoArray.add(AttributeInfo.newUnknown());
                s_logger.debug("Don't yet know what to do with a " + instruction.getClass().getName());
                return null;
            }
            if (instruction instanceof LambdaInstruction) {
                LambdaInstruction lambdaInstruction = (LambdaInstruction)instruction;
                Instruction instruction11 = this.optimizeAttrSerializerGuard(lambdaInstruction.getBody(), attributeInfoArray, bl);
                if (null != instruction11) {
                    LambdaInstruction lambdaInstruction2 = (LambdaInstruction)lambdaInstruction.cloneWithoutTypeInformation();
                    lambdaInstruction2.setBody(instruction11);
                }
                return null;
            }
            s_logger.debug("Don't yet know what to do with a " + instruction.getClass().getName());
            return instruction;
        }
        return instruction;
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction) {
        if (!(instruction instanceof ModuleFunctionCallInstruction)) {
            return instruction;
        }
        ModuleFunctionCallInstruction moduleFunctionCallInstruction = (ModuleFunctionCallInstruction)instruction;
        if (!moduleFunctionCallInstruction.getModule().equals("xslt1")) {
            return instruction;
        }
        String string = moduleFunctionCallInstruction.getFunction();
        if (string.equals("attr-serializer-guard")) {
            AttributeInfoArray attributeInfoArray = new AttributeInfoArray();
            Instruction instruction2 = this.optimizeAttrSerializerGuard(moduleFunctionCallInstruction.m_parameters[0], attributeInfoArray, false);
            if (attributeInfoArray.doesNotNeedGuard()) {
                if (null == instruction2) {
                    return moduleFunctionCallInstruction.m_parameters[0];
                }
                instruction2 = instruction2.cloneWithoutTypeInformation();
                this.doTypeCheck(instruction, instruction2, instruction.getBindingEnvironment());
                SerializationHelper.bumpGuardRemovedCount(0);
                return instruction2;
            }
            SerializationHelper.bumpGuardNotRemovedCount(0);
        }
        return instruction;
    }

    private static class AttributeInfo {
        final boolean m_readOnly;
        StreamInstruction m_stream = null;
        String m_name = null;
        String m_value = null;
        boolean m_done = false;
        boolean m_valueUnknown = false;
        Instruction m_conditional = null;

        public AttributeInfo(AttributeInfo attributeInfo) {
            this.m_readOnly = attributeInfo.m_readOnly;
            this.m_stream = null != attributeInfo.m_stream ? (StreamInstruction)attributeInfo.m_stream.cloneWithoutTypeInformation() : null;
            this.m_name = attributeInfo.m_name;
            this.m_value = attributeInfo.m_value;
            this.m_done = attributeInfo.m_done;
            this.m_valueUnknown = attributeInfo.m_valueUnknown;
            this.m_conditional = null != attributeInfo.m_conditional ? attributeInfo.m_conditional.cloneWithoutTypeInformation() : null;
        }

        public static AttributeInfo newUnknown() {
            return new AttributeInfo((String)null, false);
        }

        public String getName() {
            return this.m_name;
        }

        public String toString() {
            return "(" + this.m_name + "=" + this.m_value + (this.m_conditional != null ? this.m_conditional.toString() : "") + ")";
        }

        public AttributeInfo(Instruction instruction, boolean bl) {
            this.m_name = SAXEventStreamOptimizer.getStringFromInstruction(instruction);
            this.m_readOnly = bl;
        }

        protected AttributeInfo(String string, boolean bl) {
            this.m_name = string;
            this.m_readOnly = bl;
        }

        public void setValue(Instruction instruction) {
            this.m_value = SAXEventStreamOptimizer.getStringFromInstruction(instruction);
        }

        public void setValue(String string) {
            this.m_value = string;
        }

        public void appendValue(Instruction instruction) {
            if (this.m_done) {
                throw new StaticError("ERR_SYSTEM", "Seeing attrValue after endAttribute!");
            }
            if (this.m_valueUnknown) {
                return;
            }
            String string = SAXEventStreamOptimizer.getStringFromInstruction(instruction);
            if (null == string) {
                this.m_value = null;
                this.m_valueUnknown = true;
            } else {
                this.m_value = null == this.m_value ? string : this.m_value + string;
            }
        }

        public void setDone() {
            if (this.m_done) {
                throw new StaticError("ERR_SYSTEM", "Seeing endAttribute twice!");
            }
            this.m_done = true;
        }

        public boolean isDone() {
            return this.m_done;
        }

        public void setConditional(Instruction instruction) {
            this.m_conditional = instruction;
        }

        public Instruction getConditional() {
            return this.m_conditional;
        }

        public void restrictConditional(Instruction instruction) {
            this.m_conditional = null == this.m_conditional ? instruction : new AndInstruction(this.m_conditional, instruction);
        }

        public void setStream(StreamInstruction streamInstruction) {
            this.m_stream = streamInstruction;
        }

        public boolean guard(Instruction instruction) {
            if (this.m_readOnly || null == this.m_stream) {
                return false;
            }
            Instruction[] instructionArray = this.m_stream.getElements();
            this.m_stream.setElements(new Instruction[]{new ChooseInstruction(instruction, (Instruction)new StreamInstruction(s_saxEventType, instructionArray), new StreamInstruction(s_saxEventType))});
            return true;
        }

        public boolean remove() {
            if (this.m_readOnly) {
                return false;
            }
            if (null == this.m_stream) {
                throw new StaticError("ERR_SYSTEM", "The stream is null.");
            }
            this.m_stream.setElements(new Instruction[0]);
            return true;
        }
    }

    private class AttributeInfoArray {
        List m_arr = new ArrayList();

        public AttributeInfoArray() {
        }

        public AttributeInfoArray(AttributeInfoArray attributeInfoArray) {
            this.m_arr.addAll(attributeInfoArray.m_arr);
        }

        public void add(AttributeInfo attributeInfo) {
            this.m_arr.add(attributeInfo);
        }

        public AttributeInfo get(int n) {
            return (AttributeInfo)this.m_arr.get(n);
        }

        public AttributeInfo[] get(String string) {
            AttributeInfo[] attributeInfoArray;
            Iterator iterator = this.m_arr.iterator();
            ArrayList<AttributeInfo[]> arrayList = new ArrayList<AttributeInfo[]>();
            while (iterator.hasNext()) {
                attributeInfoArray = (AttributeInfo[])iterator.next();
                if (null == attributeInfoArray.getName() || !attributeInfoArray.getName().equals(string)) continue;
                arrayList.add(attributeInfoArray);
            }
            attributeInfoArray = new AttributeInfo[arrayList.size()];
            arrayList.toArray(attributeInfoArray);
            return attributeInfoArray;
        }

        public AttributeInfo getLast() {
            return 0 == this.size() ? null : this.get(this.size() - 1);
        }

        public int size() {
            return this.m_arr.size();
        }

        public String toString() {
            return this.m_arr.toString();
        }

        public Set getAllAttrNames() {
            HashSet<String> hashSet = new HashSet<String>();
            for (AttributeInfo attributeInfo : this.m_arr) {
                hashSet.add(attributeInfo.getName());
            }
            return hashSet;
        }

        public void leavingStream(StreamInstruction streamInstruction) {
            for (AttributeInfo attributeInfo : this.m_arr) {
                if (!attributeInfo.isDone() || null != attributeInfo.m_stream) continue;
                attributeInfo.m_stream = streamInstruction;
            }
        }

        public boolean doesNotNeedGuard() {
            boolean bl = true;
            HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
            for (AttributeInfo attributeInfo : this.m_arr) {
                String string = attributeInfo.getName();
                if (null == string) {
                    return false;
                }
                if (hashMap.containsKey(string)) {
                    AttributeInfo attributeInfo2 = (AttributeInfo)hashMap.get(string);
                    if (null == attributeInfo.getConditional()) {
                        if (attributeInfo instanceof MultiBranchAttributeInfo && ((MultiBranchAttributeInfo)attributeInfo).originalNeedsGuard()) {
                            MultiBranchAttributeInfo multiBranchAttributeInfo = (MultiBranchAttributeInfo)attributeInfo;
                            Instruction[] instructionArray = new NotInstruction[multiBranchAttributeInfo.m_cases.size()];
                            Iterator iterator = multiBranchAttributeInfo.m_cases.iterator();
                            int n = 0;
                            while (iterator.hasNext()) {
                                instructionArray[n++] = new NotInstruction(((AttributeInfo)iterator.next()).getConditional());
                            }
                            AndInstruction andInstruction = new AndInstruction(instructionArray);
                            bl = bl && attributeInfo2.guard(andInstruction);
                        } else {
                            bl = bl && attributeInfo2.remove();
                        }
                    } else {
                        return false;
                    }
                }
                hashMap.put(string, attributeInfo);
            }
            return bl;
        }
    }

    private static class MultiBranchAttributeInfo
    extends AttributeInfo {
        List m_streams = new LinkedList();
        List m_cases = new LinkedList();
        boolean m_originalNeedsGuard = false;

        MultiBranchAttributeInfo(String string, boolean bl) {
            super(string, bl);
        }

        public void setOriginalNeedsGuard() {
            this.m_originalNeedsGuard = true;
        }

        public boolean originalNeedsGuard() {
            return this.m_originalNeedsGuard;
        }

        public void addStream(StreamInstruction streamInstruction) {
            if (null != this.m_stream) {
                throw new StaticError("ERR_SYSTEM", "Using addStream after setStream");
            }
            this.m_streams.add(streamInstruction);
        }

        public void addCase(AttributeInfo attributeInfo) {
            this.m_cases.add(attributeInfo);
        }

        @Override
        public boolean remove() {
            if (this.m_readOnly) {
                return false;
            }
            if (null == this.m_stream) {
                throw new StaticError("ERR_SYSTEM", "The steam is null.");
            }
            for (StreamInstruction streamInstruction : this.m_streams) {
                streamInstruction.setElements(new Instruction[0]);
            }
            return true;
        }
    }
}

